# chargement du fichier
library(xlsx)
cars <- read.xlsx("cars_outliers.xlsx",header=TRUE,sheetIndex=1)
rownames(cars) <- cars$Modele
cars <- cars[-1]
print(str(cars))

# identification des outliers
library(isotree)
#variables prises individuellement en split
iso <- isolation.forest(cars,ndim=1)
#calcul du score pour chaque obs.
scores <- predict.isolation_forest(iso,newdata=cars)
scores <- sort(scores,decreasing = TRUE)
print(round(scores,4))

#décroissance du score
plot(scores,type="b",pch=16,cex=0.5)
text(4,scores[1]+0.005,names(scores)[1],cex=0.75,col='red')
text(5.5,scores[2],names(scores)[2],cex=0.75,col='red')
text(6,scores[3],names(scores)[3],cex=0.75,col='red')

#analyse en composantes principales
acp <- princomp(cars,cor=TRUE,scores=TRUE)
F1 <- acp$scores[,1]
F2 <- acp$scores[,2]

#projection dans le plan factoriel
plot(F1,F2,xlim=c(-3,8),ylim=c(-3,8), xlab='Comp.1',ylab='Comp.2',asp=1)
text(F1['Ferrari 456 GT'],F2['Ferrari 456 GT'],'Ferrari 456 GT',col='red',cex=0.75)
text(F1['Mercedes S 600'],F2['Mercedes S 600'],'Mercedes S 600',col='red',cex=0.75)
text(F1['Maserati Ghibli GT'],F2['Maserati Ghibli GT'],'Maserati Ghibli GT',col='red',cex=0.75)

