{ **********************************************************************
  *                               PLOT.INC                             *
  **********************************************************************
         Variables and routines common to PLOT.PAS and WINPLOT.PAS
  ********************************************************************** }

const
  EPS = 1.0E-10;  { Lower limit for an axis label }

var
  XminPixel, YminPixel : Integer;  { Pixel coord. of upper left corner }
  XmaxPixel, YmaxPixel : Integer;  { Pixel coord. of lower right corner }
  FactX, FactY         : Float;    { Scaling factors }

  function Xpixel(X : Float) : Integer;
  var
    P : Float;
  begin
    P := FactX * (X - XAxis.Min);
    if Abs(P) > 30000 then
      Xpixel := 30000
    else
      Xpixel := Round(P) + XminPixel;
  end;

  function Ypixel(Y : Float) : Integer;
  var
    P : Float;
  begin
    P := FactY * (YAxis.Max - Y);
    if Abs(P) > 30000 then
      Ypixel := 30000
    else
      Ypixel := Round(P) + YminPixel;
  end;

  function Xuser(X : Integer) : Float;
  begin
    Xuser := XAxis.Min + (X - XminPixel) / FactX;
  end;

  function Yuser(Y : Integer) : Float;
  begin
    Yuser := YAxis.Max - (Y - YminPixel) / FactY;
  end;

  procedure Interval(X1, X2 : Float; MinDiv, MaxDiv : Integer;
                     var Min, Max, Step : Float);
  var
    H, R, K : Float;
  begin
    if X1 >= X2 then Exit;
    H := X2 - X1;
    R := Int(Log10(H));
    if H < 1.0 then R := R - 1.0;
    Step := Exp10(R);

    repeat
      K := Int(H / Step);
      if K < MinDiv then Step := 0.5 * Step;
      if K > MaxDiv then Step := 2.0 * Step;
    until (K >= MinDiv) and (K <= MaxDiv);

    Min := Step * Int(X1 / Step);
    Max := Step * Int(X2 / Step);
    while Min > X1 do Min := Min - Step;
    while Max < X2 do Max := Max + Step;
  end;

  procedure AutoScale(Z : PVector; Lbound, Ubound : Integer;
                      var Axis : TAxis);
  var
    T : PVector;     { Working array }
    I, P : Integer;
    Tmin, Tmax, T1, T2 : Float;
  begin
    DimVector(T, Ubound);
    P := Pred(Lbound);

    for I := Lbound to Ubound do
      if (Axis.Scale = LIN_SCALE) or
      ((Axis.Scale = LOG_SCALE) and (Z^[I] > 0.0)) then
        begin
          Inc(P);          { If linear scale, use all elements in Z, }
          T^[P] := Z^[I];  {   otherwise remove all null elements    }
        end;

    Tmin := Min(T, Lbound, P);
    Tmax := Max(T, Lbound, P);

    if Axis.Scale = LIN_SCALE then
      Interval(Tmin, Tmax, 2, 6, Axis.Min, Axis.Max, Axis.Step)
    else
      begin
        T1 := Int(Log10(Tmin));
        T2 := Int(Log10(Tmax));
        if Tmin < 1.0 then T1 := T1 - 1.0;
        if Tmax > 1.0 then T2 := T2 + 1.0;
        Axis.Min := T1;
        Axis.Max := T2;
        Axis.Step := 1.0;
      end;

    DelVector(T, Ubound);
  end;


