{ **********************************************************************
                            Program TESTCONC.PAS
                                Version 1.0
                       (c) J. Debord, November 1996
  **********************************************************************
  This program computes the plasma concentration at given times from the
  model and administration parameters
  ********************************************************************** }

program TestConc;

uses
  { Turbo Pascal unit }
  Crt,
  { TpMath units }
  FMath,
  Pharmac;

const
{ -------------------------------------------
  Example for high dose methotrexate infusion
  ------------------------------------------- }

  Admin : TAdmin =
  (Route : INFUS;
   Dose  : 13000;
   T_inf : 4.0;
   F     : 1.0);

  Model : TPharModel =
  { The model is defined by the following parameters }
  (Ncomp  : 3;
   Ka     : 0.0;
   V1     : 15.7;
   Ke     : 0.42;
   K12    : 0.053;
   K21    : 0.24;
   K13    : 0.0037;
   K31    : 0.02;
  { Additional parameters are not used here }
   CL     : 0.0;
   Vz     : 0.0;
   Vss    : 0.0;
   MRT    : 0.0;
   T_half : (0.0, 0.0, 0.0, 0.0));

var
  T, C : Float;  { Time & concentration }

begin
  ClrScr;
  repeat
    Write('Time (-1 to end) : ');
    ReadLn(T);
    if T >= 0.0 then
      begin
        C := PharConc(Admin, Model, T);
        WriteLn('Concentration    : ', C:10:4, #10);
      end;
  until T < 0.0;
end.
