unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Memo1: TMemo;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private-dclarations }
  public
    { Public-dclarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  FMath, Random;

procedure TForm1.Button1Click(Sender: TObject);
const
  FileName : string = 'rantest.out';
  Correct : array[1..6] of LongInt =
  (921625997, 1094293978, 115775252, 499820504, -1929018715, 2008943384);

var
  I, R : LongInt;
  F : TextFile;

begin
  AssignFile(F, FileName);
  Rewrite(F);

  Writeln(F, '---------------------------------------------');
  Writeln(F, '       Correct           Actual');
  Writeln(F, '---------------------------------------------');

  RMarIn(1802, 9373);

  { Pick 20000 random numbers }
  for I := 1 to 20000 do
    IRanMar;

  { Display 6 more numbers with correct values }
  for I := 1 to 6 do
    begin
      R := IRanMar;
      Write(F, '  ', Correct[I]:12, '     ', R:12, '           ');
      if Correct[I] = R then WriteLn(F, 'OK') else WriteLn(F, 'BAD');
    end;
  WriteLn(F, '---------------------------------------------');

  CloseFile(F);
  Memo1.Lines.LoadFromFile(FileName);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Form1.Close;
end;

end.
