{ **********************************************************************
  *                         Program MASK1.PAS                          *
  *                            Version 1.0                             *
  *                     (c) J. Debord, April 1997                      *
  **********************************************************************
  This program demonstrates the use of an entry mask to read variables.
  ********************************************************************** }

uses
  Crt, FMath, PaString, Interfac;

const
  NFIELDS = 4;  { Number of fields }

const  { Variables to read. Must be initialized }
  Name   : String  = '';
  Sex    : Char    = 'M';
  Age    : Integer = 20;
  Weight : Float   = 50;

var
  Mask : PEntryMask;

begin
  DimEntryMask(Mask, NFIELDS);

  { Clear screen }
  ClrScr;

  { Draw a frame around the mask }
  Frame('', 15, 2, 65, 12, 1, ATT_FB, True);

  { Initialize fields }
  InitStrField(  20, 4,  'Your name        ', False, 20, Name,   Mask^[1]);
  InitCharField( 20, 6,  'Your sex         ', 'MF',      Sex,    Mask^[2]);
  InitIntField(  20, 8,  'Your age in years', 1, 100,    Age,    Mask^[3]);
  InitFloatField(20, 10, 'Your weight in kg', 1, 100,    Weight, Mask^[4]);

  { Read variables from mask and display their values }
  if ReadMask(Mask, NFIELDS) <> ESCAPE then
    begin
      Name   := Mask^[1].S;
      Sex    := Mask^[2].C;
      Age    := Mask^[3].N;
      Weight := Mask^[4].F;

      { Don't display non-significant zero's }
      NSZero := False;

      GotoXY(26, 17); Write('Your name   : ', Name);
      GotoXY(26, 18); Write('Your sex    : ', Sex);
      GotoXY(26, 19); Write('Your age    : ', Age, ' years');
      GotoXY(26, 20); Write('Your weight : ', Trim(FloatToStr(Weight)), ' kg');
    end;

  DelEntryMask(Mask, NFIELDS);
end.