{ **********************************************************************
  *                           Program SPEED.PAS                        *
  *                              Version 1.4                           *
  *                     (c) J. Debord, February 1999                   *
  **********************************************************************
  This program measures the execution time of the mathematical functions
  provided in the unit FMATH.PAS, with or without a 387 math coprocessor

  The use of the coprocessor is specified by defining the symbol CPU387
  in the compiler's "Conditional defines" option.

  The results are stored in two different output files : SPEED387.OUT
  if the coprocessor is used, SPEED.OUT otherwise. So, the execution
  times may be compared by displaying the two files.

  The program must be rebuilt after any modification to the "Conditional
  defines". Be sure to "build" the program, not simply "make" it, in
  order to force the FMATH.PAS unit to be recompiled.

  NB: The execution time of each function takes into account the
      computation of random arguments. This corresponds to the execution
      time of the function RanMar.
  ********************************************************************** }

program Speed;

uses
  Crt, Dos, FMath, Random;

const
  NMAX = 50000;    { Number of function evaluations }

const
  FILENAME =       { Name of output file }
{$IFDEF CPU387}
  'speed387.out';
{$ELSE}
  'speed.out';
{$ENDIF}

var
  T0, DT, Y : Float;
  I : LongInt;
  F : Text;

function Time : Float;
{ Returns time in seconds }
var
  H, M, S, C : Word;
begin
  GetTime(H, M, S, C);
  Time := 3600.0 * H + 60.0 * M + S + 0.01 * C;
end;

begin
  { Open output file }
  Assign(F, FILENAME);
  Rewrite(F);

  ClrScr;
  Writeln('Time in seconds to evaluate ', NMAX, ' functions', #10);
  Writeln(F, 'Time in seconds to evaluate ', NMAX, ' functions', #10);

  T0 := Time;
  for I := 1 to NMAX do
    Y := Ln(RanMar);
  DT := Time - T0;
  WriteLn('Ln      ', DT:6:2);
  WriteLn(F, 'Ln      ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := Log10(RanMar);
  DT := Time - T0;
  WriteLn('Log10   ', DT:6:2);
  WriteLn(F, 'Log10   ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := Log2(RanMar);
  DT := Time - T0;
  WriteLn('Log2    ', DT:6:2);
  WriteLn(F, 'Log2    ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := Exp(RanMar);
  DT := Time - T0;
  WriteLn('Exp     ', DT:6:2);
  WriteLn(F, 'Exp     ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := Exp10(RanMar);
  DT := Time - T0;
  WriteLn('Exp10   ', DT:6:2);
  WriteLn(F, 'Exp10   ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := Exp2(RanMar);
  DT := Time - T0;
  WriteLn('Exp2    ', DT:6:2);
  WriteLn(F, 'Exp2    ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := Pow(RanMar, 0.5);
  DT := Time - T0;
  WriteLn('Pow     ', DT:6:2);
  WriteLn(F, 'Pow     ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := Sin(RanMar);
  DT := Time - T0;
  WriteLn('Sin     ', DT:6:2);
  WriteLn(F, 'Sin     ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := Cos(RanMar);
  DT := Time - T0;
  WriteLn('Cos     ', DT:6:2);
  WriteLn(F, 'Cos     ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := Tan(RanMar);
  DT := Time - T0;
  WriteLn('Tan     ', DT:6:2);
  WriteLn(F, 'Tan     ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := ArcSin(RanMar);
  DT := Time - T0;
  WriteLn('ArcSin  ', DT:6:2);
  WriteLn(F, 'ArcSin  ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := ArcCos(RanMar);
  DT := Time - T0;
  WriteLn('ArcCos  ', DT:6:2);
  WriteLn(F, 'ArcCos  ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := ArcTan(RanMar);
  DT := Time - T0;
  WriteLn('ArcTan  ', DT:6:2);
  WriteLn(F, 'ArcTan  ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := ArcTan2(RanMar, 0.5);
  DT := Time - T0;
  WriteLn('ArcTan2 ', DT:6:2);
  WriteLn(F, 'ArcTan2 ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := SinH(RanMar);
  DT := Time - T0;
  WriteLn('SinH    ', DT:6:2);
  WriteLn(F, 'SinH    ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := CosH(RanMar);
  DT := Time - T0;
  WriteLn('CosH    ', DT:6:2);
  WriteLn(F, 'CosH    ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := TanH(RanMar);
  DT := Time - T0;
  WriteLn('TanH    ', DT:6:2);
  WriteLn(F, 'TanH    ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := ArcSinH(RanMar);
  DT := Time - T0;
  WriteLn('ArcSinH ', DT:6:2);
  WriteLn(F, 'ArcSinH ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := ArcCosH(RanMar + 1.0);
  DT := Time - T0;
  WriteLn('ArcCosH ', DT:6:2);
  WriteLn(F, 'ArcCosH ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := ArcTanH(RanMar);
  DT := Time - T0;
  WriteLn('ArcTanH ', DT:6:2);
  WriteLn(F, 'ArcTanH ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := Gamma(RanMar);
  DT := Time - T0;
  WriteLn('Gamma   ', DT:6:2);
  WriteLn(F, 'Gamma   ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := IGamma(RanMar, 0.5);
  DT := Time - T0;
  WriteLn('IGamma  ', DT:6:2);
  WriteLn(F, 'IGamma  ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := Beta(RanMar, 0.5);
  DT := Time - T0;
  WriteLn('Beta    ', DT:6:2);
  WriteLn(F, 'Beta    ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := IBeta(RanMar, 0.5, 0.5);
  DT := Time - T0;
  WriteLn('IBeta   ', DT:6:2);
  WriteLn(F, 'IBeta   ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := Erf(RanMar);
  DT := Time - T0;
  WriteLn('Erf     ', DT:6:2);
  WriteLn(F, 'Erf     ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := Erfc(RanMar);
  DT := Time - T0;
  WriteLn('Erfc    ', DT:6:2);
  WriteLn(F, 'Erfc    ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := RanMar;
  DT := Time - T0;
  WriteLn('RanMar  ', DT:6:2);
  WriteLn(F, 'RanMar  ', DT:6:2);

  T0 := Time;
  for I := 1 to NMAX do
    Y := RanGauss(0, 1);
  DT := Time - T0;
  WriteLn('RanGauss', DT:6:2);
  WriteLn(F, 'RanGauss', DT:6:2);

  Close(F);
end.
