{ **********************************************************************
  *                         Program DETINV.PAS                         *
  *                             Version 1.0                            *
  *                     (c) J. Debord, January 1997                    *
  **********************************************************************
  This program computes the determinant and inverse of a square matrix.
  The matrix is stored in a data file with the following structure :

    Line 1             : dimension of the matrix (N)
    Lines 2 to (N + 1) : matrix

  The file MATRIX1.DAT is an example data file with N = 4
  ********************************************************************** }

uses
  Crt, FMath, Matrices;

var
  A, A_inv : PMatrix;  { Matrix and its inverse }
  N        : Integer;  { Dimension of matrix }
  D        : Float;    { Determinant }
  Ch       : Char;     { Key pressed to exit program }

  procedure ReadMatrix(FileName : String; var A : PMatrix;
                       var N : Integer);
{ ----------------------------------------------------------------------
  Reads matrix from file. Note that A is passed as a VAR parameter
  because it is dimensioned inside the procedure.
  ---------------------------------------------------------------------- }
  var
    F    : Text;     { Data file }
    I, J : Integer;  { Loop variable }
  begin
    Assign(F, FileName);
    Reset(F);
    Read(F, N);
    DimMatrix(A, N, N);
    for I := 1 to N do
      for J := 1 to N do
        Read(F, A^[I]^[J]);
    Close(F);
  end;

  procedure WriteMatrix(Title : String; A : PMatrix; N : Integer);
{ ----------------------------------------------------------------------
  Writes matrix on screen
  ---------------------------------------------------------------------- }
  var
    I, J : Integer;
  begin
    WriteLn(Title, ' :', #10);
    for I := 1 to N do
      begin
        for J := 1 to N do
          Write(A^[I]^[J]:12:6);
        WriteLn;
      end;
    WriteLn;
  end;

begin
  ClrScr;

  { Read matrix from file }
  ReadMatrix('matrix1.dat', A, N);
  WriteMatrix('Original matrix', A, N);

  { Dimension inverse matrix }
  DimMatrix(A_inv, N, N);

  { Compute inverse matrix and determinant (taking care that the Det
    function destroys the original matrix), then reinvert the inverse
    matrix for verification }
  case InvMat(A, 1, N, A_inv) of
    MAT_OK     : begin
                   WriteMatrix('Inverse matrix', A_inv, N);
                   D := Det(A, 1, N);
                   WriteLn('Determinant = ', D:12:6, #10);
                   if InvMat(A_inv, 1, N, A) = MAT_OK then
                     WriteMatrix('Reinverted inverse matrix', A, N);
                 end;
    MAT_SINGUL : Write('Singular matrix!');
  end;

  GotoXY(1, 25);
  Write('Press a key ... ');
  Ch := ReadKey;
end.

