{ **********************************************************************
  *                           Program MIN1.PAS                         *
  *                             Version 1.0                            *
  *                       (c) J. Debord, May 2000                      *
  **********************************************************************
  This program tests the Uniplex procedure for finding the minimum of a
  function of one variable.
  ********************************************************************** }

program Min1;

uses
  FMath, Optim;

var
  Xmin, Fmin : Float;

{$F+}
function Func(X : Float) : Float;
{ Function to be minimized. True minimum is at (Ln(2), -1/4) }
begin
  Func := Exp(- 2.0 * X) - Exp(- X);
end;
{$F-}

begin
  if Uniplex({$IFDEF FPK}@{$ENDIF}Func, 0.0, 1.0, 100, 1.0E-6, Xmin, Fmin) = 0 then
    Writeln('Minimum found at X = ', Xmin:10:6, ',  Y = ', Fmin:10:6)
  else
    Writeln('Minimum not found');
end.

