{ --------------------------------------------------------------------
  Fletcher & Powell function.

  True minimum is at (1, 0, 0), F = 0

  Ref: R. Fletcher & M.J.D. Powell, Comput. J., 1964, 7, 155
  -------------------------------------------------------------------- }

const
  NVAR       = 3;       { Number of variables }
  SA_MAXITER = 300;     { Simul. annealing: number of annealing steps }
  SA_T_RATIO = 1.0E-08; { Simul. annealing: ratio of final to initial temp. }

  {$F+}
  function Func(X : PVector) : Float;
  var
    R, Theta : Float;
  begin
    R := Pythag(X^[1], X^[2]);
    Theta := ArcTan2(X^[2], X^[1]) / TWOPI;
    Func := 100.0 * (Sqr(X^[3] - 10.0 * Theta) + Sqr(R - 1.0)) + Sqr(X^[3]);
  end;
  {$F-}

  procedure InitVar;
  begin
    X^[1] := - 1.0;
    X^[2] := 1.0;
    X^[3] := 1.0;
  end;

