{ **********************************************************************
  *                         File REG_OUT.INC                           *
  *                           Version 1.3                              *
  *                     (c) J. Debord, July 1999                       *
  **********************************************************************
   Include file used by several linear or nonlinear regression programs
  ********************************************************************** }


  procedure WriteOutputFile(InFName, Title, XName, YName : String;
                            N                            : Integer;
                            Y, Ycalc, S, B               : PVector;
                            V                            : PMatrix;
                            Test                         : TRegTest);
{ ----------------------------------------------------------------------
  Writes the result of a regression program to an output file
  ---------------------------------------------------------------------- }
  var
    OutFName : String;   { Name of output file }
    OutF     : Text;     { Output file }
    Line1,
    Line2    : String;   { Separating lines }
    Sr       : Float;    { Residual standard deviation }
    Delta    : Float;    { Residual }
    SB       : PVector;  { Standard deviations of parameters }
    T        : PVector;  { Student's t }
    Prob     : PVector;  { Probabilities }
    I, K     : Integer;  { Loop variables }
  begin
    DimVector(SB, LastParam);
    DimVector(T, LastParam);
    DimVector(Prob, LastParam);

    K := Pos('.', InFName);
    OutFName := Copy(InFName, 1, Pred(K)) + '.out';
    Assign(OutF, OutFName);
    Rewrite(OutF);

    Line1 := StrChar(73, '-');
    Line2 := StrChar(73, '=');

    WriteLn(OutF, Line2);
    WriteLn(OutF, 'Data file  : ', InFName);
    WriteLn(OutF, 'Study name : ', Title);
    WriteLn(OutF, 'x variable : ', XName);
    WriteLn(OutF, 'y variable : ', YName);
    WriteLn(OutF, 'Function   : ', FuncName);

    { Perform tests on parameters }
    ParamTest(B, V, N, FirstParam, LastParam, SB, T, Prob);

    WriteLn(OutF, Line1);
    WriteLn(OutF, 'Parameter    Est.value         Std.dev.        t Student       Prob(>|t|)');
    WriteLn(OutF, Line1);
    for I := FirstParam to LastParam do
      WriteLn(OutF, ParamName(I):5, B^[I]:17:8, SB^[I]:17:8, T^[I]:17:2, Prob^[I]:17:4);
    WriteLn(OutF, Line1);
    WriteLn(OutF, 'Number of observations            : n   = ', N:5);

    with Test do
      begin
        Sr := Sqrt(Vr);
        WriteLn(OutF, 'Residual error                    : s   = ', Sr:10:8);
        if (R2 >= 0.0) and (R2 <= 1.0) then
          WriteLn(OutF, 'Coefficient of determination      : r2  = ', R2:10:8);
        if (R2a >= 0.0) and (R2a <= 1.0) then
          WriteLn(OutF, 'Adjusted coeff. of determination  : r2a = ', R2a:10:8);
        Write(OutF, 'Variance ratio (explained/resid.) : F   = ', F:10:4);
        WriteLn(OutF, '    Prob(>F) = ', Prob:6:4);
      end;

    WriteLn(OutF, Line1);
    WriteLn(OutF, '  i        Y obs.       Y calc.      Residual      Std.dev.      Std.res.');
    WriteLn(OutF, Line1);
    for K := 1 to N do
      begin
        Delta := Y^[K] - Ycalc^[K];
        WriteLn(OutF, K:3, Y^[K]:14:4, Ycalc^[K]:14:4, Delta:14:4, S^[K]:14:4, (Delta / S^[K]):14:4);
      end;
    WriteLn(OutF, Line2);

    Close(OutF);
    WriteLn('Results written to file ', OutFName);

    DelVector(SB, LastParam);
    DelVector(T, LastParam);
    DelVector(Prob, LastParam);
  end;
