{ **********************************************************************
  *                          Program GRAFUNC.PAS                       *
  *                              Version 1.2                           *
  *                       (c) J. Debord, June 1999                     *
  **********************************************************************
  This program plots the graph of a function. See PLOT.PAS for details
  on the graphic variables and procedures.

  The Gamma function is used as example. Note that the program draws an
  appearance of asymptotes by connecting the points where the function
  tends to Infinity.
  ********************************************************************** }

uses
  Crt, Graph, FMath, Plot;

var
  Ch : Char;

{ ----------------------------------------------------------------------
  Define here the function to be plotted. With a 16-bit compiler (TP/BP)
  the function must be compiled in FAR mode ($F+). According to its
  definition in PLOT.PAS, the function must have a single parameter.
  If more parameters are needed they must be declared as global
  variables.
  ---------------------------------------------------------------------- }

  {$F+}
  function Func(X : Float) : Float;
  begin
    Func := Gamma(X);
  end;
  {$F-}

begin
  { Define scale }
  XAxis.Min := -5;
  XAxis.Max :=  5;
  XAxis.Step := 5;

  YAxis.Min := -5;
  YAxis.Max :=  5;
  YAxis.Step := 5;

  { Define graph title }
  GraphTitle.Text := 'Gamma function';

  { Define the path to the graphic drivers if necessary.
    The default path is C:\BP\BGI) }
  { BGIPath := 'C:\BP\BGI'; }

  { Plot graph }
  if GraphOk then
    begin
      WriteLegend(0);
      SetClipping(True);
      if XAxis.Min < 0.0 then
        Line(Xpixel(0), Ypixel(YAxis.Min), Xpixel(0), Ypixel(YAxis.Max));
      if YAxis.Min < 0.0 then
        Line(Xpixel(XAxis.Min), Ypixel(0), Xpixel(XAxis.Max), Ypixel(0));

      { Plot function }
      SetColor(12);
      {$IFDEF FPK}
        PlotFunc(@Func, XAxis.Min, XAxis.Max, 1);
      {$ELSE}
        PlotFunc(Func, XAxis.Min, XAxis.Max, 1);
      {$ENDIF}

      { Leave graphic mode }
      Ch := ReadKey;
      CloseGraph;
    end;
end.
