{ **********************************************************************
  *                          Program TESTCOMP.PAS                      *
  *                              Version 1.2                           *
  *                      (c) J. Debord, February 1998                  *
  **********************************************************************
                    Test of complex numbers and functions
                      (Based on CDEMO.PAS by E.F.Glynn)
  ********************************************************************** }

program TestComp;

uses
  Crt, FMath, PaString;

var
  A : array[1..20] of Complex;
  I : Integer;

  procedure Pause;
  begin
    GotoXY(1, 25);
    Write('Press <Enter> to continue');
    ReadLn;
    ClrScr;
  end;

  procedure TestConv;
  var
    K : Integer;
    Z : Complex;
  begin
    WriteLn('Complex number definition/conversion/output: CSet / CConvert / CompToStr');
    WriteLn(#10, '   z rectangular':25, 'z polar':28);
    WriteLn('    --------------------------  -------------------------------');
    for K := 1 to 20 do
      begin
        Z := A[K];
        CConvert(Z, Pol);
        WriteLn(K:3, CompToStr(A[K]), ' ', CompToStr(Z));
      end;
    Pause;
  end;

  procedure TestArith;
  var
    Z, Z1, Z2 : Complex;
  begin
    WriteLn('Complex arithmetic: CAdd, CSub, CMult, CDiv');
    WriteLn;
    CSet(Z1, 1, 1, Rec);
    WriteLn('Let z1 = ':12, CompToStr(Z1));
    CSet(Z2, Sqrt(3), - 1, Rec);
    WriteLn('z2 = ':12, CompToStr(Z2));
    WriteLn;
    CAdd(Z1, Z2, Z); WriteLn('z1 + z2 = ':12, CompToStr(Z));
    CSub(Z1, Z2, Z); WriteLn('z1 - z2 = ':12, CompToStr(Z));
    CMult(Z1, Z2, Z); WriteLn('z1 * z2 = ':12, CompToStr(Z));
    CDiv(Z1, Z2, Z); WriteLn('z1 / z2 = ':12, CompToStr(Z));
    Pause;
  end;

  procedure TestFunc(Index : Integer);
  var
    K : Integer;
    C, C1, Z, Z1 : Complex;
  begin
    CSet(C, 0.5, 0.5, Rec);  { C = 0.5 + 0.5*i }
    CDiv(C_one, C, C1);      { C1 = 1/C }
    NumLength := 9;
    MaxDec := 3;
    Write('z':14);
    case Index of
      1 : WriteLn('     Ln(z)                  Exp(Ln(z))   ':62);
      2 : WriteLn('   ArcSin(z)              Sin(ArcSin(z)) ':62);
      3 : WriteLn('   ArcCos(z)              Cos(ArcCos(z)) ':62);
      4 : WriteLn('   ArcTan(z)              Tan(ArcTan(z)) ':62);
      5 : WriteLn('   ArcSinh(z)            Sinh(ArcSinh(z))':62);
      6 : WriteLn('   ArcCosh(z)            Cosh(ArcCosh(z))':62);
      7 : WriteLn('   ArcTanh(z)            Tanh(ArcTanh(z))':62);
      8 : WriteLn('z^c, c=0.5+0.5*i           (z^c)^(1/c)   ':62);
      9 : WriteLn('   Ln(Gamma(z))              Gamma(z)    ':62);
    end;
    WriteLn('  -------------------------   -----------------------   ',
            '-----------------------');
    for K := 1 to 20 do
      begin
        Write(K:2, CompToStr(A[K]));
        if ((Index = 1) and (K = 1))             { Ln(0)           }
        or ((Index = 4) and (K in [8, 12]))      { ArcTan(+/- i)   }
        or ((Index = 7) and (K in [6, 10]))      { ArcTanh(+/- 1)  }
        or ((Index = 9) and (K in [1, 10, 18]))  { (integer <= 0) }
        then
          WriteLn('undefined':20)
        else
          begin
            case Index of
              1 : begin
                    CLn(A[K], Z);
                    CExp(Z, Z1);
                  end;
              2 : begin
                    CArcSin(A[K], Z);
                    CSin(Z, Z1);
                  end;
              3 : begin
                    CArcCos(A[K], Z);
                    CCos(Z, Z1);
                  end;
              4 : begin
                    CArcTan(A[K], Z);
                    CTan(Z, Z1);
                  end;
              5 : begin
                    CArcSinh(A[K], Z);
                    CSinh(Z, Z1);
                  end;
              6 : begin
                    CArcCosh(A[K], Z);
                    CCosh(Z, Z1);
                  end;
              7 : begin
                    CArcTanh(A[K], Z);
                    CTanh(Z, Z1);
                  end;
              8 : begin
                    CPow(A[K], C, Z);  { z = a^c }
                    CPow(Z, C1, Z1);   { z1 = z^(1/c) = a }
                  end;
              9 : begin
                    CLnGamma(A[K], Z); { Ln((a)) }
                    CExp(Z, Z1);       { (a) }
                  end;
            end;
            WriteLn(' ', CompToStr(Z), ' ', CompToStr(Z1))
          end;
      end;
    Pause;
  end;

  procedure TestRoot;
  { Computes the 3 cubic roots of -1+i }
  var
    A, Z, Z1 : Complex;
    K : Integer;
  begin
    CSet(A, -1.0, 1.0, Rec);
    WriteLn('The 3 cube roots of (-1+i)', #10);
    WriteLn('z':14, 'z^(1/3)                  [z^(1/3)]^3  ':62);
    WriteLn('  -------------------------   -----------------------   ',
            '-----------------------');
    for K := 0 to 2 do
      begin
        CRoot(A, K, 3, Z);
        CIntPow(Z, 3, Z1);
        CConvert(Z, Rec);   { CRoot and CIntPow output their }
        CConvert(Z1, Rec);  { results in polar form          }
        WriteLn(K:2, CompToStr(A), ' ', CompToStr(Z), ' ', CompToStr(Z1));
      end;
    Pause;
  end;

begin
  ClrScr;

  CSet(A[1], 0.0, 0.0, Rec);
  CSet(A[2], 0.5, 0.5, Rec);
  CSet(A[3], - 0.5, 0.5, Rec);
  CSet(A[4], - 0.5, - 0.5, Rec);
  CSet(A[5], 0.5, - 0.5, Rec);
  CSet(A[6], 1.0, 0.0, Rec);
  CSet(A[7], 1.0, 1.0, Rec);
  CSet(A[8], 0.0, 1.0, Rec);
  CSet(A[9], - 1.0, 1.0, Rec);
  CSet(A[10], - 1.0, 0.0, Rec);
  CSet(A[11], - 1.0, - 1.0, Rec);
  CSet(A[12], 0.0, - 1.0, Rec);
  CSet(A[13], 1.0, - 1.0, Rec);
  CSet(A[14], 5.0, 0.0, Rec);
  CSet(A[15], 5.0, 3.0, Rec);
  CSet(A[16], 0.0, 3.0, Rec);
  CSet(A[17], - 5.0, 3.0, Rec);
  CSet(A[18], - 5.0, 0.0, Rec);
  CSet(A[19], 5.0, - 3.0, Rec);
  CSet(A[20], 0.0, - 3.0, Rec);

  TestConv;
  TestArith;
  for I := 1 to 9 do
    TestFunc(I);
  TestRoot;
end.
