{ --------------------------------------------------------------------
  Marquardt's method. Requires a procedure to compute the gradient and
  hessian of the objective function. Here we use procedure NumHessGrad
  (defined in OPTIM.PAS), which performs numerical differentiation.
  -------------------------------------------------------------------- }

  procedure Minimize;
  begin
    WriteLn('Marquardt');
    WriteLn('---------'#10);

    {$IFDEF FPK}
      ErrCode := Marquardt(@Func, @NumHessGrad, X, 1, NVAR,
                           MAXITER, TOL, F_min, H_inv);
    {$ELSE}
      ErrCode := Marquardt(Func, NumHessGrad, X, 1, NVAR,
                           MAXITER, TOL, F_min, H_inv);
    {$ENDIF}

    case ErrCode of
      MAT_OK     : WriteResult(True);
      MAT_SINGUL : WriteLn('Singular Hessian matrix.');
      BIG_LAMBDA : WriteLn('Lambda too high.');
      NON_CONV   : WriteLn('Too many iterations in Marquardt.');
    end;
  end;

