{ --------------------------------------------------------------------
  Example taken from 'Numerical Recipes'
  True minimum is at (-2.0, +/-0.89442719)
  -------------------------------------------------------------------- }

const
  NVAR       = 2;       { Number of variables }
  SA_MAXITER = 400;     { Simul. annealing: number of annealing steps }
  SA_T_RATIO = 1.0E-08; { Simul. annealing: ratio of final to initial temp. }

  {$F+}
  function Func(X : PVector) : Float;
  var
    A, AA, B, BB : Float;
  begin
    A := X^[2] * X^[2] * (3.0 - X^[1]) - X^[1] * X^[1] * (3.0 + X^[1]);
    B := 2.0 + X^[1];
    AA := Sqr(A);
    BB := Sqr(B);
    Func := 10.0 * AA + BB / (1.0 + BB);
  end;
  {$F-}

  procedure InitVar;
  begin
    X^[1] := 0.1;
    X^[2] := 4.2;
  end;

