{ --------------------------------------------------------------------
  Example taken from 'Numerical Recipes'
  True minimum is at (0, 0, 0, 0), F = 1.0
  -------------------------------------------------------------------- }

const
  NVAR       = 4;       { Number of variables }
  RAD        = 0.3;     { Used to define function }
  AUG        = 2.0;     { Used to define function }
  SA_MAXITER = 200;     { Simul. annealing: number of annealing steps }
  SA_T_RATIO = 1.0E-08; { Simul. annealing: ratio of final to initial temp. }

  {$F+}
  function Func(X : PVector) : Float;
  const
    Wid : array[1..NVAR] of Float = (1.0, 3.0, 10.0, 30.0);
  var
    J : Integer;
    Q, R, Rad2, Sumd, Sumr : Float;
  begin
    Sumd := 0.0;
    Sumr := 0.0;
    Rad2 := Sqr(RAD);
    for J := 1 to NVAR do
      begin
        Q := X^[J] * Wid[J];
        if Q >= 0 then R := Int(Q + 0.5) else R := Int(Q - 0.5);
        Sumr := Sumr + Sqr(Q);
        Sumd := Sumd + Sqr(Q - R);
      end;
    if Sumd > Rad2 then
      Func := 1.0 + Sumr * (1.0 + AUG)
    else
      Func := 1.0 + Sumr * (1.0 + AUG * Sumd / Rad2);
  end;
  {$F-}

  procedure InitVar;
  var
    I : Integer;
  begin
    for I := 1 to NVAR do
      X^[I] := I;
  end;

