{ --------------------------------------------------------------------
  Colville function (Extension of Rosenbrock function)

  True minimum is at (1, 1, 1, 1), F = 0

  Ref: R. J. Van Iwaarden, PhD Thesis, U. Denver, 1996
  -------------------------------------------------------------------- }

const
  NVAR       = 4;       { Number of variables }
  SA_MAXITER = 500;     { Simul. annealing: number of annealing steps }
  SA_T_RATIO = 1.0E-08; { Simul. annealing: ratio of final to initial temp. }

  {$F+}
  function Func(X : PVector) : Float;
  begin
    Func := 100.0 * Sqr(X^[2] - Sqr(X^[1])) + Sqr(1.0 - X^[1]) +
             90.0 * Sqr(X^[4] - Sqr(X^[3])) + Sqr(1.0 - X^[3]) +
             10.1 * ((Sqr(X^[2] - 1.0) + Sqr(X^[4] - 1.0))) +
             19.8 * (X^[2] - 1.0) * (X^[4] - 1.0);
  end;
  {$F-}

  procedure InitVar;
  begin
    X^[1] := 3.0;
    X^[2] := - 1.0;
    X^[1] := 3.0;
    X^[2] := - 1.0;
  end;

