{ --------------------------------------------------------------------
  Griewank function.

  True minimum is at (0, 0), F = 0

  Ref: R. J. Van Iwaarden, PhD Thesis, U. Denver, 1996
  -------------------------------------------------------------------- }

const
  NVAR       = 2;       { Number of variables }
  SA_MAXITER = 300;     { Simul. annealing: number of annealing steps }
  SA_T_RATIO = 1.0E-08; { Simul. annealing: ratio of final to initial temp. }

  {$F+}
  function Func(X : PVector) : Float;
  begin
    Func := (Sqr(X^[1]) + Sqr(X^[2])) / 200.0
            - Cos(X^[1]) * Cos(X^[2] / SQRT2) + 1.0;
  end;
  {$F-}

  procedure InitVar;
  begin
    X^[1] := 1.0;
    X^[2] := 1.0;
  end;

