{ --------------------------------------------------------------------
  Chichinadze function.

  True minimum is at (5.90133, 0.5), F = -43.3159

  Ref: R. J. Van Iwaarden, PhD Thesis, U. Denver, 1996
  -------------------------------------------------------------------- }

const
  NVAR       = 2;       { Number of variables }
  SA_MAXITER = 300;     { Simul. annealing: number of annealing steps }
  SA_T_RATIO = 1.0E-08; { Simul. annealing: ratio of final to initial temp. }

  {$F+}
  function Func(X : PVector) : Float;
  const
    FIVEPI   = 15.707963267948966193;   { 5 * Pi      }
    INVSQRT5 = 0.44721359549995793928;  { 1 / Sqrt(5) }
  var
    A, B, C : Float;
  begin
    A := X^[1] * (X^[1] - 12.0) + 11.0;
    B := 10.0 * Cos(PIDIV2 * X^[1]) + 8.0 * Sin(FIVEPI * X^[1]);
    C := INVSQRT5 * Exp(- 0.5 * Sqr(X^[2] - 0.5));
    Func := A + B - C;
  end;
  {$F-}

  procedure InitVar;
  begin
    X^[1] := 10.0;
    X^[2] := 1.0;
  end;

