{ **********************************************************************
  *                        File REG_PLOT.INC                           *
  *                           Version 1.5                              *
  *                    (c) J. Debord, July 1999                        *
  **********************************************************************
   Include file used by several linear or nonlinear regression programs
  ********************************************************************** }

  {$F+}
  function PlotRegFunc(X : Float) : Float;
{ ----------------------------------------------------------------------
  Defines the function to be plotted
  ---------------------------------------------------------------------- }
  begin
    PlotRegFunc := RegFunc(X, B);
  end;
  {$F-}

  procedure PlotGraph(Title : String;
                      X, Y  : PVector;
                      N     : Integer);
{ ----------------------------------------------------------------------
  Plots the regression function
  ---------------------------------------------------------------------- }
  var
    Ch : Char;
  begin
    GraphTitle.Text := Title;

    { Determine scale automatically }
    AutoScale(X, 1, N, XAxis);
    AutoScale(Y, 1, N, YAxis);

    { Plot graph }
    if GraphOk then
      begin
        WriteLegend(0);
        SetClipping(True);

        { Plot points }
        PlotCurve(X, Y, 1, N, 1, 0);

        { Plot fitted function }
        {$IFDEF FPK}
          PlotFunc(@PlotRegFunc, XAxis.Min, XAxis.Max, 1);
        {$ELSE}
          PlotFunc(PlotRegFunc, XAxis.Min, XAxis.Max, 1);
        {$ENDIF}

        { Leave graphic mode }
        Ch := ReadKey;
        CloseGraph;
      end;
  end;
