(*********************************************************************)
(* UIOFastBufferedWriter.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*********************************************************************)

{
@abstract(Unit spcialise dans l'criture rapide dans un flux : soit en mmoire, soit sur disque dur)
@author(Ricco)
@created(12/01/2004)
Attention, on ne s'occupe que d'criture ici, accs squentiel pur, pas de retour
en arrire possible. Comparer la rapidit avec un stream standard.
}
unit UIOFastBufferedWriter;

interface

USES
        Classes;

CONST
        {Taille du buffer d'criture}
        SIZE_BUF_WRITER = high(word);

TYPE
        {Buffer d'criture}
        TBufByte = array[1..SIZE_BUF_WRITER] of BYTE;
        PBufByte = ^TBufByte;

        {Classe d'criture dans un flux}
        TWriterBuffered = class(TFileStream)
                          private
                          {position courante dans le buffer}
                          FCurPos: integer;
                          {le buffer}
                          FBuf: PBufByte;
                          {vider dans le flux}
                          procedure   Flush();
                          public
                          {en paramtre le stream concern}
                          constructor Create(const FileName: string);
                          {dtruire le buffer aprs avoir flush}
                          destructor  Destroy; override;
                          {criture dans le flux}
                          function    Write(const buffer; count: integer): integer; override;
                          end;


implementation

USES
        SysUtils;

{ TWriterBuffered }

constructor TWriterBuffered.Create(const FileName: string);
begin
 inherited Create(FileName,fmCreate);
 ReAllocMem(FBuf,SIZE_BUF_WRITER);
 FCurPos:= 0;
end;

destructor TWriterBuffered.Destroy;
begin
 self.Flush();
 ReAllocMem(FBuf,0);
 inherited Destroy;
end;

procedure TWriterBuffered.Flush;
begin
 //si buffer non vide...
 If (FCurPos>0)
  Then
   Begin
    inherited Write(FBuf^,FCurPos);
    FCurPos:= 0;
   End;
end;

function TWriterBuffered.Write(const buffer; count: integer): integer;
begin
 RESULT:= Count;
 //a ne tiendra pas dans le buffer
 if (Count>SIZE_BUF_WRITER)
  then
   begin
    self.Flush();
    inherited Write(buffer,count);
   end
  else
   //ok
   begin
    //vrifier si a dborde du buffer
    if (FCurPos+count>SIZE_BUF_WRITER)
     then self.Flush();
    //crire maintenant dans le buffer
    Move(buffer,FBuf^[succ(FCurPos)],count);
    inc(FCurPos,count);
   end;
end;

end.

