(*********************************************************************)
(* UIOFastTextFileAccess.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*********************************************************************)

{
@abstract(Unit spcialis dans les accs rapides aux fichiers au format texte)
@author(Ricco)
@created(12/01/2004)
On utilise un flux buffris. A priori c'est plus rapide, il faudrait analyser plus en dtail par la suite
mais la taille du buffer joue un rle considrable ici. En tous les cas, cette procdure a t maintes fois fiabilise,
il peut y avoit doute quand mme, par exemple pour un portage dans Kylix. Attention, galement, cette classe ne permet qu'une lecture
squentielle du fichier texte, il faudrait modifier la structure pour supporter un accs direct, ou encore
partir sur une nouvelle classe et non un hriter de TFileStream.
}
unit UIOFastTextFileAccess;

interface

USES
     Classes;   

CONST
     {Taille du buffer en nmobre d'octets}
     SIZE_CHAR_BUFFER = 65535;//bien qu'un segment de mmoire de 64Ko n'ait plus de sens ici

TYPE
     {Type de buffer - tableau de caractre tout simple}
     TBufferCHAR     = Array[1..SIZE_CHAR_BUFFER] Of CHAR;
     TPtrBufferCHAR  = ^TBufferCHAR;

     {La classe de lecture de fichier texte - attention, bien qu'hritier de TFileSTream,
     la lecture est forcment squentielle ici, il n'est pas question de revenir en arrire ou de faire des
     sauts avec un SEEK !!! le dphasage buffer/fichier serait immdiat et catsatrophique.}
     TBufStreamCHAR  = Class(TFileStream)
                       private
                       {Le buffer de donnes de type caractre}
                       FBuffer: TPtrBufferCHAR;
                       {Taille du fichier}
                       FSize: LongInt;
                       {Position dans le buffer}
                       FBufPos: Longint;
                       {Position globale dans le fichier}
                       FGlobalPos: Longint;
                       {Decalage par rapport au buffer}
                       FGap: Longint;
                       {Octets lus}
                       FByteReaded: LongInt;
                       public
                       {allocation de l'objet, allocation du buffer et initialisations}
                       Constructor Create(Const FileName: String);
                       {lecture d'un octet(caractre) puis passage du pointeur de fichier sur le suivant}
                       Function ReadCharSequentiel: Char;
                       Function GetString(var prmByteRead: Integer): String;
                       Function EOF: Boolean;
                       Destructor Destroy; override;
                       END;

implementation

USES
        Sysutils;

{ TBufStreamCHAR }

constructor TBufStreamCHAR.Create(const FileName: String);
begin
 inherited Create(FileName,fmOpenRead);
 {Initialisation}
 FBuffer  := AllocMem(SIZE_CHAR_BUFFER);
 FBufPos:= 1;
 FGlobalPos:= 1;
 FGap:= 0;
 FSize:= Size;
 {Premire lecture}
 If (FSize<=SIZE_CHAR_BUFFER)
  Then FGap:= FSize
  Else FGap:= SIZE_CHAR_BUFFER;
 ReadBuffer(FBuffer^,FGap);
 FByteReaded:= FGap;
end;

destructor TBufStreamCHAR.Destroy;
begin
 ReAllocMem(FBuffer,0);
 inherited;
end;

function TBufStreamCHAR.EOF: Boolean;
begin
 result:= Not(FGlobalPos<Size);
end;

function TBufStreamCHAR.GetString(var prmByteRead: integer): String;
Var S: String;
    B: Char;
Begin
 prmByteRead:= 0;
 S:= '';
 B:= ReadCharSequentiel;
 inc(prmByteRead);
 While (B<>#13) AND (B<>#10) Do
  Begin
   S:= S+B;
   B:= ReadCharSequentiel;
   inc(prmByteRead);
  End;
 //passer au suivant en cas de fichier Windows, afin de vider le #10
 If (B=#13)
  Then
   begin
    ReadCharSequentiel;
    inc(prmByteRead);
   end;
 GetString:= S;
end;

function TBufStreamCHAR.ReadCharSequentiel: Char;
begin
 If (FBufPos<=FGap)
  Then result:= FBuffer^[FBufPos]
  Else
   Begin
    If (FSize<=(FByteReaded+SIZE_CHAR_BUFFER))
     Then FGap:= FSize-FByteReaded
     Else FGap:= SIZE_CHAR_BUFFER;
    ReadBuffer(FBuffer^,FGap);
    Inc(FByteReaded,FGap);
    FBufPos:= 1;
    Result:= FBuffer^[FBufPos];
   End;
 Inc(FBufPos);
 Inc(FGlobalPos);
end;

end.
