(*********************************************************************)
(* UDataAccessDefinition.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*********************************************************************)

{
@abstract(Classe gnrique d'accs aux donnes)
@author(Ricco)
@created(12/01/2004)
La classe de base destine  l'importation de donnes. A priori elle est quasi abstraite mis  part
les spcifications de fichiers etc., reste le pbm du paramtrage qu'il faut gnraliser sous forme d'une et une seule procdure
appele communment dans les classes hritires.
}
unit UDataAccessDefinition;

interface

USES
        Classes,
        UDatasetDefinition;

TYPE
        {Type de base pour les accs fichier
        L'objectif est de remplir un TLstAttributes}
        TAccessAbstract = class(TObject)
                          protected
                          {ensemble de donnes  remplir}
                          FLstAtt: TLstAttributes;
                          {nom du fichier source}
                          FFileName: string;
                          {liste de chanes -- infos ventuelles sur le chargement}
                          FLstInfosHTML: TStringList;
                          {fixer les paramtres par dfaut de l'importation.
                          surcharge sans inherited chez les hritiers}
                          procedure   SetDefaultParameters(); virtual;
                          {chargement effectif des donnes --  surcharger chez les hritiers}
                          function    coreDownload(prmThread: TThread): boolean; virtual; abstract;
                          public
                          constructor Create(prmLstAtt: TLstAttributes);
                          destructor  destroy(); override;
                          {connexion avec le fichier, peut tre surcharg avec inherited}
                          function    Connecting(prmFileName: string): boolean; virtual;
                          {chargement des donnes, surcharge obligatoire}
                          function    Download(prmThread: TThread): boolean;
                          {envoyer la progression en %}
                          function    GetProgression: Integer; virtual; abstract;
                          {renvoyer les infos}
                          function    getLstInfosHTML(): TStringList;
                          //
                          property    FileName: string read FFileName;
                          property    LstAtt: TLstAttributes read FLstAtt;
                          end;
                          

implementation

USES
        SysUtils, Windows, UConstConfiguration;

{ TAccessAbstract }

function TAccessAbstract.Connecting(prmFileName: string): boolean;
begin
 if FileExists(prmFileName)
  then
   begin
    result:= true;
    FFileName:= prmFileName;
   end
  else result:= false;
end;

constructor TAccessAbstract.Create(prmLstAtt: TLstAttributes);
begin
 inherited Create();
 FLstAtt:= prmLstAtt;
 FLstInfosHTML:= TStringList.Create();
 self.SetDefaultParameters();
end;

destructor TAccessAbstract.destroy;
begin
 FLstInfosHTML.Free();
 inherited;
end;

function TAccessAbstract.Download(prmThread: TThread): boolean;
var tps: cardinal;
    heap: THeapStatus;
    curMem: cardinal;
begin
 //infos...
 tps:= GetTickCount();
 heap:= GetHeapStatus();
 curMem:= heap.TotalAllocated;
 //chargement
 result:= self.coreDownload(prmThread);
 //recup. infos
 tps:= GetTickCount()-tps;
 heap:= GetHeapStatus();
 //dans la sortie HTML
 //afficher le temps de chargement des donnes et taille mmoire alloue
 self.FLstInfosHTML.add(HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>Datasource processing</TH></TR>');
 self.FLstInfosHTML.add(HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Computation time</TD><TD align="right">%d ms</TD></TR>',[tps]));
 self.FLstInfosHTML.add(HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Allocated memory</TD><TD align="right">%d KB</TD></TR>',[(heap.TotalAllocated-curMem) div 1024]));
end;

function TAccessAbstract.getLstInfosHTML: TStringList;
begin
 result:= self.FLstInfosHTML;
end;

procedure TAccessAbstract.SetDefaultParameters;
begin
 //rien ici
end;

end.
