(********************************************************************)
(* UDataAccessExcelFile.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(********************************************************************)

{
@abstract(Accs  un fichier au format EXCEL 97&2000)
@author(Ricco)
@created(27/12/2004)

Utilise la version de la bibliothque FlexCel qui est en licence Mozilla Public Licence.
La licence a t modifie depuis mais cette version est OK !

Attention, seuls les formats Excel 97 et Excel 2000 sont OK, plantage
si on essaie de lire les autres versions, y compris les vieilles versions Excel 95 et prcdent.

Par convention, on considre que les donnes sont dans la premire feuille de calcul, et qu'elles
sont bien cales en haut et gauche. Les donnes manquantes ne sont pas supportes, a fortiori les colonnes
ou lignes vides.

/!\ Le test de type est ralis sur la seconde ligne du tableau, si ce n'est pas une chane de
carcatre, c'est qu'il s'agit d'une donne numrique.

}

unit UDataAccessExcelFile;

interface

USES
        Classes,
        UDataAccessDefinition,
        UFlexCelImport, XLSAdapter;

TYPE
        TAccessXLSFile = class(TAccessAbstract)
                         private
                         //lecteur de donnes XLS
                         FXls: TFlexCelImport;
                         //driver pour la lecture des donnes
                         FXlsAdapter: TXLSAdapter;
                         //taille totale et lue
                         FSize, FCurPos: integer;
                         //Taille relle des colonnes et des lignes -- vrification des cellules vides
                         FTrueMaxCol,FTrueMaxRow: integer;
                         //dtecter les paramtres de lecture
                         procedure   readXlsInfo();
                         //lire les variables et dtercter leur type
                         procedure   readAttributesInfos();
                         //lire les donnes
                         procedure   readDataset(prmThread: TThread);
                         protected
                         function    coreDownload(prmThread: TThread): boolean; override;
                         public
                         function    GetProgression: Integer; override;
                         end;

implementation

uses
        Variants, Sysutils, Windows,
        UDatasetDefinition, UDatasetImplementation, UDlgDatasetDownload,
        ULogFile, UConstConfiguration;

CONST
        XLS_NUM_DATASHEET = 1;//les donnes sont toujours dans la premire feuille
        XLS_DELTA_ADD_EXAMPLES = 2000;//les fichiers ne seront jamais trop gros de toute manire

{ TAccessXLSFile }

function TAccessXLSFile.coreDownload(prmThread: TThread): boolean;
var tps: cardinal;
begin
 //prudence, prudence...
 result:= FALSE;
 //go...
 TRY
  FXls:= TFlexCelImport.Create(NIL);//lecteur
  FXlsAdapter:= TXLSAdapter.Create(NIL);//driver
  FXls.Adapter:= FXlsAdapter;
  //lire les donnes
  tps:= GetTickCount();
  FXls.OpenFile(self.FileName);
  //TraceLog.WriteToLogFile('[XLS import] -- ok open file');
  if (FXls.IsLoaded())
   then
    begin
      //activer la bonne feuille et rcuprer les infos
      self.readXlsInfo();
      tps:= GetTickCount()-tps;
      TraceLog.WriteToLogFile(format('[XLS import] -- open, loaded and read infos in %d ms.',[tps]));
      //TraceLog.WriteToLogFile('[XLS import] -- ok lecture info');
      tps:= GetTickCount();
      //lire les attributs
      self.readAttributesInfos();
      //TraceLog.WriteToLogFile('[XLS import] -- ok lecture attributs');
      //lire les donnes
      self.readDataset(prmThread);
      tps:= GetTickCount()-tps;
      TraceLog.WriteToLogFile(format('[XLS import] -- parsing in %d ms.',[tps]));
      //TraceLog.WriteToLogFile('[XLS import] -- ok lecture donnes');
      //si on en est l...
      result:= TRUE;
    end;
  //librer
  FXlsAdapter.Free();
  FXls.Free();
 EXCEPT
  on e: Exception do
   begin
    //rcuprer le message d'erreur dans le fichier log
    TraceLog.WriteToLogFile(format('[XLS import] -- error = %s',[e.Message]));
   end;
 END;
end;

function TAccessXLSFile.GetProgression: Integer;
begin
 //sur les gros fichiers, il y a un temps de latence possible  grer avant que readXlsInfos soit appel
 if (FSize>0)
  then result:= TRUNC((100.0*FCurPos)/(1.0*FSize))
  else result:= 0;
end;

procedure TAccessXLSFile.readAttributesInfos;
var j: integer;
    att: TAttribute;
    sName: string;
    vValue: variant;

begin
 for j:= 1 to FTrueMaxCol do
  begin
   sName:= FXls.CellValue[1,j];//premire ligne --> nom des variables
   vValue:= FXls.CellValue[2,j];//deuxime ligne --> dtection du type de donnes
   if VarIsNumeric(vValue)
    then att:= TAttContinue.Create(sName,1)
    else att:= TAttDiscrete.Create(sName,1);
   //ajouter
   self.LstAtt.Add(att);
  end;
end;

procedure TAccessXLSFile.readDataset(prmThread: TThread);
var i,j: integer;
    sValue: string;
    att: TAttribute;
    dThread: TThreadDownload;
begin
 //initalisations
 dThread:= prmThread as TThreadDownload;
 FCurPos:= FTrueMaxCol;
 //lecture ligne  ligne et contrle de l'interruption par l'utilisateur
 i:= 1;
 while (i< FTrueMaxRow) and not(assigned(dThread) and dThread.isTerminated) do
  begin
   //agrandir les vecteurs de donnes le cas chant
   if (i>self.LstAtt.Size)
    then self.LstAtt.Size:= self.LstAtt.Size+XLS_DELTA_ADD_EXAMPLES;
   //lecture de toute la ligne
   for j:= 1 to FTrueMaxCol do
    begin
     //brancher l'attribut
     att:= self.LstAtt.Attribute[pred(j)];
     //lire la valeur
     sValue:= FXls.CellValue[succ(i),j];//dcalage car premire ligne = nom des attributs
     att.sValue[i]:= sValue;
     //cellules lues
     inc(FCurPos);
    end;
   //passage  la ligne suivante
   inc(i);
  end;
 //retailler les vecteurs
 self.LstAtt.Size:= pred(i);  
end;

procedure TAccessXLSFile.readXlsInfo;
var row,col: integer;
    sValue: variant;
begin
 //accder  la dernire cellule -- tout a pour qu'il rserve la mmoire
 sValue:= FXls.CellValue[FXls.MaxRow,FXls.MaxCol];
 TraceLog.WriteToLogFile(format('[XLS import] -- last value = %s',[sValue]));
 //suite...
 FTrueMaxCol:= 0;
 FTrueMaxRow:= 0;
 //feuille des donnes
 FXls.ActiveSheet:= XLS_NUM_DATASHEET;
 //tester si les colonnes sont remplies correctement
 for col:= 1 to FXls.MaxCol do
  begin
   if NOT(VarIsClear(FXls.CellValue[1,col]))
    then FTrueMaxCol:= col
    else BREAK;
  end;
 //tester sur la dernire colonne si les lignes sont remplies correctement
 for row:= 1 to FXls.MaxRow do
  begin
   if NOT(VarIsClear(FXls.CellValue[row,FTrueMaxCol]))
    then FTrueMaxRow:= row
    else BREAK;
  end;
 //taille du tableau
 FSize:= FTrueMaxRow*FTrueMaxCol;
 
 //infos pour les sorties
 self.FLstInfosHTML.Add(HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>Workbook information</TH></TR>');
 self.FLstInfosHTML.Add(HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Number of sheets</TD><TD align="right">%d</TD></TR>',[FXls.SheetCount]));
 self.FLstInfosHTML.Add(HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Selected sheet</TD><TD align="right">%s</TD></TR>',[FXls.ActiveSheetName]));
 self.FLstInfosHTML.Add(HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Sheet size</TD><TD align="right">%d x %d</TD></TR>',[FXls.MaxRow,FXls.MaxCol]));
 self.FLstInfosHTML.Add(HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Dataset size</TD><TD align="right">%d x %d</TD></TR>',[FTrueMaxRow,FTrueMaxCol]));

end;

end.
