(***********************************************************************)
(* UDataAccessInfoDownload.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(***********************************************************************)

{
@abstract(Classe d'info sur les chargements = rendre plus explicite les chargements)
@author(Ricco)
@created(13/01/2005)

INFOS :
-------
Temps de chargements
Erreurs ventuelles
Traitement des donnes manquantes
Infos sur les classeurs, etc.
}

unit UDataAccessInfoDownload;

interface

USES
        Classes;

TYPE
        TAccessDataInfo = class(TObject)
                          private
                          FLstInfos: TStringList;
                          public
                          constructor create();
                          destructor  destroy(); override;
                          //manipulation de la liste interne
                          procedure   reInitializeInfos();
                          procedure   addInfoHTML(const prmHTML: string);
                          function    getInfosHTML(): string;
                          procedure   recupInfosHTML(prmSource: TStringList);
                          end;

implementation

{ TAccessDataInfo }

procedure TAccessDataInfo.addInfoHTML(const prmHTML: string);
begin
 FLstInfos.Add(prmHTML);
end;

constructor TAccessDataInfo.create;
begin
 inherited create();
 FLstInfos:= TStringList.Create();
end;

destructor TAccessDataInfo.destroy;
begin
 FLstInfos.Free();
 inherited;
end;

function TAccessDataInfo.getInfosHTML: string;
begin
 result:= FLstInfos.Text;
end;

procedure TAccessDataInfo.recupInfosHTML(prmSource: TStringList);
var i: integer;
begin
 for i:= 0 to pred(prmSource.Count) do
  FLstInfos.Add(prmSource.Strings[i]);
end;

procedure TAccessDataInfo.reInitializeInfos;
begin
 FLstInfos.Clear();
end;

end.
