(*******************************************************************)
(* UDataAccessWEKAFile.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*******************************************************************)

{
@abstract(Accs  un fichier au format WEKA)
@author(Ricco)
@created(24/12/2004)

Traitement  la vole des donnes manquantes :

(1) nouveau code pour les attributs discrets
(2) moyenne pour les attributs continus

Si pour un attribut continue, toute la colonne est vide, un code arbitraire est attribu aux donnes.

}

unit UDataAccessWEKAFile;

interface

USES
        Classes,
        UDataAccessDefinition;

TYPE
        TAccessWekaFile = class(TAccessAbstract)
                          private
                          //buffer temporaire pour les accs
                          FBuffer: array[0..pred(16*1024)] of char;
                          //flux d'accs aux donnes
                          FBufFile: TextFile;
                          //taille lue et totale
                          FFileSize, FFileRead: cardinal;
                          //lire une chane dans le fichier
                          procedure   lectureLigne(var sLigne: string);
                          protected
                          //rcuprer la liste des attributs et leur type
                          procedure   recupAttributes();
                          //rcuprer les donnes
                          procedure   recupDataset(prmThread: TThread);
                          function    coreDownload(prmThread: TThread): boolean; override;
                          public
                          function    GetProgression: Integer; override;
                          end;

implementation

uses
        Sysutils, UFileResources,
        UDatasetDefinition, UDatasetImplementation,
        UDlgDatasetDownload, ULogFile, UConstConfiguration;

const
        ARFF_ATTRIBUTE_IDENTIFICATION = '@ATTRIBUTE';
        ARFF_DATA_IDENTIFICATION = '@DATA';
        ARFF_ATT_DISCRETE_IDENTIFICATION = '{';

        ARFF_CHAR_QUOTE = '''';
        ARFF_CHAR_SEP_SPACE = #32;
        ARFF_CHAR_SEP_TAB = #9;
        ARFF_CHAR_COMMENTS = '%';
        ARFF_CHAR_SEP_COMMA = ',';

        {dfinit le saut pour la rallocation de mmoire lors d'ajout d'individus}
        ARFF_DELTA_ADD_EXAMPLES = 5000;

        {un code local utilis pour les donnes manquantes}
        ARFF_CONTINUOUS_MISSING_DATA_VALUE = -99999;



{ TAccessWekaFile }

function TAccessWekaFile.coreDownload(prmThread: TThread): boolean;
begin
 //initialisations
 //FFileSize:= FileSizeByName(self.FileName);
 //new -- 26/02/2005 -- IdGlobal.pas n'existe pas dans la version perso de DELPHI 6.0
 FFileSize:= tanagra_getFileSizeByName(self.FFileName);
 FFileRead:= 0;
 //zoo...
 TRY
 AssignFile(FBufFile,self.FileName);
 SetTextBuf(FBufFile,FBuffer,sizeof(FBuffer));
 Reset(FBufFile);
 //rcuprer les attributs
 self.recupAttributes();
 //rcuprer les donnes et traiter les donnes manquantes
 self.recupDataset(prmThread);
 //fermer le fichier
 //FBufFile.Free();
 CloseFile(FBufFile);
 result:= TRUE;
 EXCEPT
 result:= FALSE;
 END;
end;

function TAccessWekaFile.GetProgression: Integer;
begin
 result:= TRUNC((100.0*FFileRead)/(1.0*FFileSize));
end;

procedure TAccessWekaFile.lectureLigne(var sLigne: string);
begin
 Readln(FBufFile,sLigne);
 inc(FFileRead,length(sLigne));
end;

procedure TAccessWekaFile.recupAttributes();
var tmp,sName: string;
    att: TAttribute;
    nbCol: integer;
    p: integer;
begin
 //aller jusqu' la section des attributs
 repeat
  //tmp:= FBufFile.GetString(nbRead);
  lectureLigne(tmp);
 until (pos(ARFF_ATTRIBUTE_IDENTIFICATION,UpperCase(tmp))>0);
 //lire chaque variable  partir d'ici
 nbCol:= 0;
 while (pos(ARFF_DATA_IDENTIFICATION,UpperCase(tmp))=0) do
  begin
   //pas une ligne vide ou une ligne de commentaire ?
   if (tmp<>'') and (tmp[1]<>ARFF_CHAR_COMMENTS)
    then
     begin
      //parser
      tmp:= copy(tmp,12,length(tmp));
      if (tmp[1]=ARFF_CHAR_QUOTE)
       then
        begin
         sName:= copy(tmp,2,length(tmp));
         sName:= copy(sName,1,pos(ARFF_CHAR_QUOTE,sName)-1)
        end
       else
        begin
         p:= pos(ARFF_CHAR_SEP_TAB,tmp);
         if (p>0)
          then sName:= copy(tmp,1,p-1)
          else
           begin
            p:= pos(ARFF_CHAR_SEP_SPACE,tmp);
            if (p>0)
                then sName:= copy(tmp,1,p-1)
                else sName:= 'VAR_'+IntToStr(succ(nbCol));
           end;
        end;
      //cration de la variable selon le type dtect
      if (pos(ARFF_ATT_DISCRETE_IDENTIFICATION,tmp)>0)
       then att:= TAttDiscrete.Create(sName,1)
       else att:= TAttContinue.Create(sName,1); 
      //ajout  l'ensemble des donnes
      self.LstAtt.Add(att);
     end;
    //passer  la ligne suivante
    //tmp:= FBufFile.GetString(nbRead);
    lectureLigne(tmp);
  end;
 //synchroniser les tailles de vecteurs
 self.LstAtt.Size:= 1;
end;

//***************************************************************
//*** types locaux pour le traitement des donnes manquantes ****
//***************************************************************

TYPE
        //infos pour une variable
        TInfoMissing = record
                       nbValues, nbMissing: integer;
                       sumValues, avgValues: TTypeContinue;
                       end;

        //infos pour une srie de variables
        TTabInfoMissing = array of TInfoMissing;

//***************************************************************

procedure TAccessWekaFile.recupDataset(prmThread: TThread);
var dThread: TThreadDownload;
    sLine, tmp: string;
    numCol,numRow: integer;
    dValue: TTypeDiscrete;
    cValue: TTypeContinue;
    att: TAttribute;
    tabInfos: TTabInfoMissing;
    p,err: integer;
    nbMDCAtt: integer;//nombre de variables continues traites

    //initialiser les infos missing
    procedure initInfosMissing();
    var j: integer;
    begin
     nbMDCAtt:= 0;
     for j:= 0 to pred(self.FLstAtt.Count) do
      FillChar(tabInfos[j],sizeof(TInfoMissing),0);
    end;

    //calculer les moyennes par colonne
    procedure computeInfosMissing();
    var j: integer;
    begin
     for j:= 0 to pred(self.FLstAtt.Count) do
      begin
       if (tabInfos[j].nbValues>0)
        then tabInfos[j].avgValues:= tabInfos[j].sumValues/(1.0*tabInfos[j].nbValues)
        else tabInfos[j].avgValues:= ARFF_CONTINUOUS_MISSING_DATA_VALUE;
      end;
    end;

    //remplacer les donnes manquantes avec la valeur calcule
    procedure replaceMissingData();
    var i,j: integer;
    begin
     for j:= 0 to pred(self.FLstAtt.Count) do
      begin
       if (tabInfos[j].nbMissing>0)
        then
         begin
          inc(nbMDCAtt);
          att:= self.LstAtt.Attribute[j];
          //TraceLog.WriteToLogFile(format('[IMPORT WEKA] %d missing values for %s, assigning = %.6f',[tabInfos[j].nbMissing,att.Name,tabInfos[j].avgValues]));
          //envoyer infos dans le HTML
          self.FLstInfosHTML.Add(HTML_TABLE_COLOR_DATA_GRAY+format('<TD>%s</TD><TD align="right">%d values -- replaced with %.4f</TD>',[att.Name,tabInfos[j].nbMissing,tabInfos[j].avgValues])+'</TR>');
          //remplacement des valeurs
          for i:= 1 to self.LstAtt.Size do
           begin
            if (att.cValue[i] = ARFF_CONTINUOUS_MISSING_DATA_VALUE)
             then att.cValue[i]:= tabInfos[j].avgValues;
           end;
         end;
      end;
    end;

    //insrer une valeur dans le vecteur des donnes
    procedure set_value();
    begin
     att:= self.LstAtt.Attribute[numCol];
     if att.isCategory(caDiscrete)
      then
       begin
        //le code est rajout automatiquement s'il n'existe pas
        //y compris donc pour la donne manquante
        dValue:= att.LstValues.getValue(tmp);
        att.dValue[numRow]:= dValue;
       end
      else
       begin
        //transtyper
        val(tmp,cValue,err);
        if (err<>0)
         //si erreur, c'est forcment un code de donnes manquante
         then
          begin
           inc(tabInfos[numCol].nbMissing);
           att.cValue[numRow]:= ARFF_CONTINUOUS_MISSING_DATA_VALUE;
          end
         //pas d'erreur, on rcupre la valeur et les infos pour calcul de moyenne
         else
          begin
           inc(tabInfos[numCol].nbValues);
           tabInfos[numCol].sumValues:= tabInfos[numCol].sumValues+cValue;
           att.cValue[numRow]:= cValue;
          end;
       end;
    end;


begin
 //initaliser les infos sur les missing
 setLength(tabInfos,self.FLstAtt.Count);
 initInfosMissing();
 self.FLstInfosHTML.Add(HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>Continuous missing data handling</TH></TR>');
 //bancher le thread et zoo...
 dThread:= prmThread as TThreadDownload;
 numRow:= 0;
 while not(EOF(FBufFile)) and not(assigned(dThread) and dThread.isTerminated) do
  begin
   //sLine:= FBufFile.GetString(nbRead);
   lectureLigne(sLine);
   if  (sLine<>'') and (sLine[1]<>ARFF_CHAR_COMMENTS)
    then
     begin
      //numro d'observation courant
      inc(numRow);
      if (numRow>=self.LstAtt.Size)
       then LstAtt.Size:= LstAtt.Size+ARFF_DELTA_ADD_EXAMPLES;
      //allons-y sur la ligne courante
      numCol:= 0;
      //dtecter les sparateurs successifs
      p:= pos(ARFF_CHAR_SEP_COMMA,sLine);
      while (p>0) do
       begin
        tmp:= copy(sLine,1,pred(p));
        set_value();
        delete(sLine,1,p);
        p:= pos(ARFF_CHAR_SEP_COMMA,sLine);
        inc(numCol);
       end;
      tmp:= sLine;
      set_value();
     end;
  end;
 //aligner sur la bonne taille
 self.LstAtt.Size:= numRow;
 //compute moyenne par colonne
 computeInfosMissing();     
 //et remplace les colonnes comportant des donnes manquantes
 replaceMissingData();
 //si pas de m.d. sur att. continus
 if (nbMDCAtt=0)
  then self.FLstInfosHTML.Add(HTML_TABLE_COLOR_DATA_GRAY+'<TD colspan=2>none</TD></TH>');
 //vider les infos missing
 setLength(tabInfos,0);
end;

end.

