(***************************************************************)
(* UStringFastHash.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(***************************************************************)

{
@abstract(Recherche rapide dans la table de hachage)
@author(Ricco)
@created(09/01/2005)

Amlioration de la recherche dans la liste des modalits, deux hypothses :
(1) la liste est CASE SENSITIVE
(2) la seule manire de mettre  jour la liste est l'appel de la mthode ADD, pas de ASSIGN, etc....

}

unit UStringFastHash;

interface

USES
        Classes, IniFiles;

TYPE
        {tentative de recherche trs rapide -- la liste est toujours "CASE SENSITIVE"}
        TFastHashedStrings = class(TStringList)
                             private
                             FValueHash: TStringHash;
                             procedure UpdateValueHash();
                             protected
                             procedure Changed(); override;
                             public
                             constructor create();
                             destructor Destroy(); override;
                             function IndexOf(const S: string): Integer; override;
                             end;

implementation

USES
        Sysutils;

{ TFastHashedStrings }

procedure TFastHashedStrings.Changed;
begin
 inherited;
 self.UpdateValueHash();
end;

constructor TFastHashedStrings.create;
begin
 inherited Create();
 FValueHash := TStringHash.Create();
end;

destructor TFastHashedStrings.Destroy;
begin
 if assigned(FValueHash) then FreeAndNil(FValueHash);
 inherited;
end;

function TFastHashedStrings.IndexOf(const S: string): Integer;
begin
 Result :=  FValueHash.ValueOf(S);
end;

procedure TFastHashedStrings.UpdateValueHash;
var
  I: Integer;
begin
 //vider la liste
 FValueHash.Clear();
 //tout recharger, en gardant les numros internes...
 for I := 0 to Count - 1 do
  FValueHash.Add(Self[I], I);
end;

end.
