unit WOLE2Stream;

//  This is the windows unit for reading OLE-2 files.
// Uses IStream and IStorage

interface
uses Windows, SysUtils, Classes, ActiveX, ComObj, XlsMessages, axctrls;

const
  OptionsReadStorage = STGM_DIRECT or STGM_SHARE_EXCLUSIVE or STGM_READ; //Storages should be opened in EXCLUSIVE MODE
  OptionsReadRoot = STGM_DIRECT or STGM_SHARE_DENY_WRITE or STGM_READ;
  OptionsWrite = STGM_DIRECT or STGM_SHARE_EXCLUSIVE or STGM_WRITE;

  MsOleStreamT= STGTY_STREAM;
  MsOleStorageT= STGTY_STORAGE;

type
  TEnumOle2Open = (Ole2_Read, Ole2_Write);

  TMsOleDirInfo= record
    Name: WideString;
    OleType: integer;
    Size: integer;
  end;

  TIStorageArray= array of IStorage;

  TMsOleDirInfoArray = Array of TMsOleDirInfo;

  TOle2Storage = class
  private
    FMode: TEnumOle2Open;
    FStorage: IStorage;
    StorageList: TIStorageArray;
  public
    constructor Create(const AFileName: string; const aMode: TEnumOle2Open);
    destructor Destroy;override;

    procedure GetDirectories(var DirInfo: TMsOleDirInfoArray);
    procedure CdUp;
    procedure CdDown(const Dir: Widestring; const CreateIfNeeded: boolean);

    property Storage: IStorage read FStorage;
    property Mode: TEnumOle2Open read FMode;
  end;

  TOle2Stream = class (TOleStream)
  protected
    FStorage: TOle2Storage;
  public
    constructor Create(const AStorage: TOle2Storage; const StreamName: Widestring);
  end;

implementation

{ TOle2Storage }
procedure TOle2Storage.CdDown(const Dir: Widestring; const CreateIfNeeded: boolean);
begin
  SetLength(StorageList, Length(StorageList)+1);
  StorageList[Length(StorageList)-1]:=FStorage;
  if (FMode= Ole2_Write) then
    OleCheck(StorageList[Length(StorageList)-1].CreateStorage(PWideChar(Dir), OptionsWrite, 0, 0, FStorage))
  else
    OleCheck(StorageList[Length(StorageList)-1].OpenStorage(PWideChar(Dir), nil, OptionsReadStorage, nil, 0, FStorage));
end;
procedure TOle2Storage.CdUp;
begin
  FStorage:=StorageList[Length(StorageList)-1];
  SetLength(StorageList, Length(StorageList)-1);
end;

constructor TOle2Storage.Create(const AFileName: string; const aMode: TEnumOle2Open);
var
  WideFileName: Widestring;
begin
  inherited Create;
  WideFileName:=AFileName;
  if aMode= Ole2_Write then
    OleCheck(StgCreateDocfile(PWideChar(WideFileName), OptionsWrite, 0, FStorage))

  else if aMode= Ole2_Read then
  begin
    if StgIsStorageFile(PWideChar(WideFileName)) <> S_OK then
      raise Exception.CreateFmt(ErrFileIsNotXLS, [WideFileName]);

    OleCheck(StgOpenStorage(PWideChar(WideFileName), nil, OptionsReadRoot, nil, 0, FStorage));
  end;

  FMode:=aMode;
  SetLength(StorageList,0);
end;

destructor TOle2Storage.Destroy;
begin
  inherited;
end;

procedure TOle2Storage.GetDirectories(var DirInfo: TMsOleDirInfoArray);
var
  Enum: IEnumStatStg;
  NumFetched: integer;
  StatStg: TStatStg;
  Malloc: IMalloc;

begin
  SetLength(DirInfo, 0);
  OleCheck(CoGetMalloc(1, Malloc));
  if FStorage.EnumElements(0, nil, 0, Enum) <> S_OK then
  begin
    FStorage.Stat(StatStg, 0);
    try
      raise Exception.CreateFmt(ErrCantReadFile, [StatStg.pwcsName]);
    finally
      Malloc.Free(StatStg.pwcsName);
    end; //finally
  end;

  while Enum.Next(1, StatStg, @NumFetched) = S_OK do
  begin
    try
      SetLength(DirInfo, Length(DirInfo)+1);
      DirInfo[Length(DirInfo)-1].Name:= StatStg.pwcsName;
      DirInfo[Length(DirInfo)-1].OleType:= StatStg.dwType;
      DirInfo[Length(DirInfo)-1].Size:= StatStg.cbSize;
    finally
       Malloc.Free(StatStg.pwcsName);
    end; //finally
  end; //while
end;


{ TOle2Stream }

constructor TOle2Stream.Create(const AStorage: TOle2Storage; const StreamName: Widestring);
var
  aStream: IStream;
begin
  if AStorage.Mode=Ole2_Read then
    OleCheck(AStorage.Storage.OpenStream( PWideChar(StreamName), nil, OptionsReadStorage, 0, aStream))
  else
    OleCheck(AStorage.Storage.CreateStream( PWideChar(StreamName), OptionsWrite, 0, 0, aStream));

  inherited Create(aStream);
  FStorage:= AStorage;
end;


end.
