(********************************************************)
(* UFrmBase.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(********************************************************)

{
@abstract(Fiche de base de l'application)
@author(Ricco)
@created(12/01/2004)
Dfinir la fiche de base de toute l'application.
Deux mthodes essentiellement sont insres:
* l'une pour insrer dynamiquement des composants
* l'autre pour insrer les bons messages 
}
unit UFrmBase;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs;

type
  {Toutes les fiches doivent tre un hritier de celle-ci}
  TFrmBase = class(TForm)
  protected
    {Insertion dynamique des composants.
     Virtuelle mais non abstraite.
     Pas d'inherited}
    procedure InsertComponents(); virtual;
    {Insertion dynamique des messages.
    Virtuelle mais non abstraite.
    Pas d'inherited ici, possibilit chez les hritiers}
    procedure InsertTexts(); virtual;
  public
    {Les mthodes d'insertion dynamiques sont appels aprs la construction de la fiche}
    procedure AfterConstruction; override;
  end;

var
  FrmBase: TFrmBase;

implementation

uses UConstConfiguration;

{$R *.dfm}

{ TFrmBase }

procedure TFrmBase.AfterConstruction;
begin
 self.InsertComponents();
 self.InsertTexts();
 inherited AfterConstruction();
end;

procedure TFrmBase.InsertComponents;
begin
 self.Font.Name:= FRM_FONT_NAME;
 self.Font.Size:= FRM_FONT_SIZE;  
end;

procedure TFrmBase.InsertTexts;
begin
 //vide
end;

end.
