(********************************************************)
(* ULogFile.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(********************************************************)

{
@abstract(Ecrit dans un fichier log les informations destines  tracer l'excution)
@author(Ricco)
@created(12/01/2004)
}
unit ULogFile;

interface

Uses SysUtils;

Type
        {classe - gnration de fihcier log}
        TTraceLog = Class
                 protected
                 //FFile: TextFile;
                 FPath: String;
                 FFileName: String;
                 FTemps: Cardinal;
                 procedure   VerifierAttributFichier(sFile: TFileName);
                 public
                 Constructor Create;
                 procedure   WriteToLogFile(s: String);
                 function    EcartTemps: Cardinal;
                 function    StrEcartTemps: string; 
                 End;

Var TraceLog: TTraceLog;

implementation

//constante pour compilation conditionnelle

{$DEFINE LOGFILE}


Uses Forms, Windows;

{ TTraceLog }

constructor TTraceLog.Create;
var FFile: TextFile;
begin
 //chemin de l'excutable
 FPath:= ExtractFilePath(Application.ExeName);
 if (FPath[length(FPath)]<>'\') then FPath:= FPath+'\';
 //nom du fichier de debug
 FFileName:= FPath+'debugfile.txt';
 //MODIF220902 - non gnration du fichier LOG
 {$IFDEF LOGFILE}
 //tester puis modifier attribut du fichier
 VerifierAttributFichier(FFileName);
 //suite cration du fichier
 Assign(FFile,FFileName);
 Rewrite(FFile);
 Writeln(FFile,'dmarrage fichier log at'+DateTimeToStr(Now()));
 CloseFile(FFile);
 {$ENDIF}
 //initialisation du compteur de temps
 FTemps:= GetTickCount;
end;

function TTraceLog.EcartTemps: Cardinal;
begin
 RESULT:= GetTickCount-FTemps;
end;

function TTraceLog.StrEcartTemps: string;
begin
 RESULT:= IntToStr(self.EcartTemps)+' ms.';
end;

procedure TTraceLog.VerifierAttributFichier(sFile: TFileName);
var attr: integer;
    okDel: Boolean;
    okModif: Integer;
begin
 if FileExists(sFile)
  Then
   Begin
    okDel:= SysUtils.DeleteFile(sFile);
    If not(okDel)
     Then
      Begin
       attr:= SysUtils.FileGetAttr(sFile);
       if ((attr and SysUtils.faReadOnly)<>0)
        Then
         Begin
          okMOdif:= SysUtils.FileSetAttr(sFile,0);
          if (okModif=0)
           Then SysUtils.DeleteFile(sFile)
           Else Raise Exception.Create('Erreur criture fichier temporaire - Vrifier les droits d''accs');
         End;
      End;
   End;
end;

procedure TTraceLog.WriteToLogFile(s: String);
var FFile: TextFile;
begin
 //MODIF220902 - don't generate logfile
 {$IFDEF LOGFILE}
 Assign(FFile,FFileName);
 Append(FFile);
 writeln(FFile,s);
 Flush(FFile);
 CloseFile(FFile);
 {$ENDIF}
 //initialiser pour prochaine lecture
 FTemps:= GetTickCount;
end;

Initialization
 TraceLog:= TTraceLog.Create;
Finalization
 TraceLog.Free;
end.
