(************************************************************)
(* UFrmMainForm.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(************************************************************)


{
@abstract(Fiche principale de l'application)
@author(Ricco)
@created(12/01/2004)
Generateur de nombres alatoires, sous forme de classe instanciable. L'intrt
est de pouvoir en affecter un  un processus particulier, ainsi si on a besoin
de plusieurs gnrateurs, il suffira d'en instancier autant : l'exprience est ainsi
totalement reproductible.

Reference : la meilleure (cf. galement celui de TurboPower) celle de G. Marsaglia rpondant aux tests de DIEHARD,
il s'agit d'une traduction objet de la bibliothque de J. Debord. 
}
unit UCalcRndGenerator;

interface

USES
        FMATH;

TYPE
        {fixer les valeurs de dpart}
        {0 -> alatoire avec random de delphi,
        {1 -> utiliser les valeurs de dpart standard de la bibliothque,
        {2 -> utiliser les valeurs de dpart passs dans le constructeur}
        TStartSeed = (seedRandom,seedStandard,seedUser);

CONST
        {mode de dmarrage standard du generateur - modifiable par fichier de configuration}
        STD_SEED_START : TStartSeed = seedRandom;
        {valeurs de dpart "standard" - modifiable par fichier de configuration}
        DEFAULT_SEED_VALUE_1 : integer = 1802;
        DEFAULT_SEED_VALUE_2 : integer = 9373;

        StartSeedDescription: array[TStartSeed] of string = ('Random','Standard','User');

TYPE
        {gnrateur de nombre alatoire}
        TRndGenerator = class(TObject)
                        private
                        {valeurs d'initialisation}
                        X1, X2: LongInt;
                        {compteurs internes}
                        C1, C2: LongInt;
                        {pour la gnration de valeurs alatoires normales}
                        Gauss_Save : Float;    { Saves a random number }
                        Gauss_Set  : Boolean;  { Flags if a number has been saved }
                        {initialisateur}
                        procedure RMarIn(prmSeed1, prmSeed2 : Integer);
                        public
                        {paramtres de dpart et valeurs de dpart sont passs}
                        constructor Create(prmStart : TStartSeed; prmSeed1: integer; prmSeed2: integer);
                        {envoie une valeur entire alatoire entre [2147483648..2147483647] - loi uniforme}
                        function IRanMar() : LongInt;
                        {envoie une valeur relle entire entre [0, 1[ - loi uniforme}
                        function RanMar() : Float;
                        {envoie une valeur entire entre 0..pred(Range)}
                        function IRanMarRange(Range: LongInt): LongInt;
                        {envoie une valeur alatoire suivant une loi normale(0,1)}
                        function RanGaussStd() : Float;
                        end;

implementation

uses
        ULogFile, SysUtils;

{ TRndGenerator }

constructor TRndGenerator.Create(prmStart : TStartSeed; prmSeed1: integer; prmSeed2: integer);
begin
 inherited Create();
 //selon le type de dmarrage demand
 case prmStart of
  seedRandom: self.RMarIn(succ(Random(10000)),succ(Random(10000)));
  seedStandard: self.RMarIn(DEFAULT_SEED_VALUE_1,DEFAULT_SEED_VALUE_2);
  seedUser: self.RMarIn(prmSeed1,prmSeed2);
 end;
 //TraceLog.WriteToLogFile(Format('START RND , RND MODE : %d',[ord(prmStart)]));
end;

function TRndGenerator.IRanMar: LongInt;
var Y1, Y2 : LongInt;
begin
  Y1 := 18000 * X1 + C1;
  X1 := Y1 and 65535;
  C1 := Y1 shr 16;
  Y2 := 30903 * X2 + C2;
  X2 := Y2 and 65535;
  C2 := Y2 shr 16;
  IRanMar := (X1 shl 16) + (X2 and 65535);
end;
function TRndGenerator.IRanMarRange(Range: Integer): LongInt;
begin
 IRanMarRange:= TRUNC(1.0*self.RanMar()*Range);
end;

function TRndGenerator.RanGaussStd: Float;
{ Computes 2 random numbers from the standard normal distribution,
  returns one and saves the other for the next call }
var
  X, R, Theta : Float;
begin
  if not Gauss_Set then
    begin
      X := RanMar;
      if X = 0.0 then X := MACHEP;
      R := Sqrt(- 2.0 * Ln(X));     { Box-Muller algorithm }
      Theta := TWOPI * self.RanMar();
      RanGaussStd := R * Cos(Theta);
      Gauss_Save := R * Sin(Theta);
    end
  else
    RanGaussStd := Gauss_Save;
  Gauss_Set := not Gauss_Set;
end;

function TRndGenerator.RanMar: Float;
begin
 RanMar := (self.IRanMar() + 2147483648.0) / 4294967296.0;
end;

procedure TRndGenerator.RMarIn(prmSeed1, prmSeed2: Integer);
begin
  //gnrateur de valeur entires et uniformes
  X1 := prmSeed1;
  X2 := prmSeed2;
  C1 := 0;
  C2 := 0;
  //et pour la loi normale
  Gauss_Save:= 0.0;
  Gauss_Set:= FALSE;
end;

Initialization
 //dpart alatoire du gnrateur de donnes de DELPHI
 Randomize(); 
end.
