(********************************************************************)
(* UCalcRulesDefinition.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(********************************************************************)

{
@abstract(Dfinition des structures de rgles)
@author(Ricco)
@created(12/01/2004)
Simplifi  l'extrme compte tenu de l'exprience accumule ces dernires annes.
}
unit UCalcRulesDefinition;

interface

USES
        UDatasetDefinition;

TYPE

        {type d'oprateur}
        TTypeConditionOperator = 1..2;

        {une condition}
        TRuleCondition = class(TObject)
                         private
                         {attribut associ}
                         FAtt: TAttribute;
                         {oprateur associ - diffre selon le type rel de condtion}
                         FOp: TTypeConditionOperator;
                         public
                         {associer la variable et l'oprateur}
                         constructor Create(prmAtt: TAttribute; prmOp: TTypeConditionOperator);
                         {tester si la valeur rpond  la condition - valeur continue}
                         function    TestValue(const prmValue: TTypeContinue): boolean;  overload; virtual; abstract;
                         {tester si la valeur rpond  la condition - valeur discrte}
                         function    TestValue(const prmValue: TTypeDiscrete): boolean; overload; virtual; abstract;
                         {tester un exemple (associ  l'attribut courant donc)}
                         function    TestExample(const example: integer): boolean; virtual; abstract;
                         {fusionner deux conditions}
                         procedure   Merge(prmOther: TRuleCondition); virtual; abstract;
                         {dupliquer la condition - comma au scrabble}
                         function    Duplicate(): TRuleCondition; virtual; abstract;
                         {la description en HTML}
                         function    getHTMLDescription(): string; virtual;
                         {la description en TXT - description courte ou approfondie -- short veut dire galit simple pour les tests sur var. discrtes}
                         function    getTXTDescription(short: boolean = TRUE): string; virtual;
                         {variable en jeu}
                         property    Attribute: TAttribute read FAtt;
                         {oprateur}
                         property    Operator: TTypeConditionOperator read FOp;
                         end;

        {gestionnaire de condition discrte}
        TSetDiscreteValue = set of TTypeDiscrete;

        {une condition pour variable discrte, operateur 1 -> in}
        TRuleCondDiscrete = class(TRuleCondition)
                            private
                            FSetValues: TSetDiscreteValue;
                            public
                            constructor Create(prmAtt: TAttribute; prmOp: TTypeConditionOperator; prmValue: TTypeDiscrete);
                            function    TestValue(const prmValue: TTypeDiscrete): boolean; override;
                            function    TestValue(const prmValue: TTypeContinue): boolean; override;
                            function    TestExample(const example: integer): boolean; override;
                            {c'est une union}
                            procedure   Merge(prmOther: TRuleCondition); override;
                            function    Duplicate(): TRuleCondition; override;
                            function    getHTMLDescription(): string; override;
                            function    getTXTDescription(short: boolean = TRUE): string; override;
                            property    SetValues: TSetDiscreteValue read FSetValues;
                            end;

        {une condition pour variable continue, oprateur 1 -> '<', 2 -> '>='}
        TRuleCondContinue = class(TRuleCondition)
                            private
                            FThresoldValue: TTypeContinue;
                            public
                            constructor Create(prmAtt: TAttribute; prmOp: TTypeConditionOperator; prmValue: TTypeContinue);
                            function    TestValue(const prmValue: TTypeDiscrete): boolean; override;
                            function    TestValue(const prmValue: TTypeContinue): boolean; override;
                            function    TestExample(const example: integer): boolean; override;
                            {simple mise  jour du seuil}
                            procedure   Merge(prmOther: TRuleCondition); override;
                            function    Duplicate(): TRuleCondition; override;
                            procedure   SetNewThresold(prmValue: TTypeContinue);
                            function    getHTMLDescription(): string; override;
                            function    getTXTDescription(short: boolean = TRUE): string; override;
                            property    ThresoldValue: TTypeContinue read FThresoldValue;
                            end;

implementation

uses
        Sysutils, UConstConfiguration;

{ TRuleCondition }

constructor TRuleCondition.Create(prmAtt: TAttribute; prmOp: TTypeConditionOperator);
begin
 inherited Create();
 FAtt:= prmAtt;
 FOp:= prmOp;
end;

function TRuleCondition.getHTMLDescription: string;
begin
 result:= FAtt.Name;
end;

function TRuleCondition.getTXTDescription(short: boolean = TRUE): string;
begin
 result:= FAtt.Name;
end;

{ TRuleCondDiscrete }

constructor TRuleCondDiscrete.Create(prmAtt: TAttribute;
  prmOp: TTypeConditionOperator; prmValue: TTypeDiscrete);
begin
 inherited Create(prmAtt,prmOp);
 //singleton au dpart
 FSetValues:= [prmValue];
end;

function TRuleCondDiscrete.TestValue(const prmValue: TTypeDiscrete): boolean;
begin
 result:= prmValue in FSetValues;
end;

procedure TRuleCondDiscrete.Merge(prmOther: TRuleCondition);
begin
 //c'est bien une union
 FSetValues:= FSetValues + (prmOther as TRuleCondDiscrete).SetValues;
end;

function TRuleCondDiscrete.TestValue(const prmValue: TTypeContinue): boolean;
var tmp: TTypeDiscrete;
begin
 tmp:= trunc(prmValue);
 //bon typage donc pas de risque d'appel rcursif
 result:= self.TestValue(tmp);
end;

function TRuleCondDiscrete.Duplicate: TRuleCondition;
var r: TRuleCondDiscrete;
begin
 r:= TRuleCondDiscrete.Create(Attribute,Operator,1);//le "1" c'est pour la forme, il est vir aprs
 r.FSetValues:= self.FSetValues;
 result:= r;
end;

function TRuleCondDiscrete.getHTMLDescription: string;
var s: string;
    i: TTypeDiscrete;
begin
 s:= inherited getHTMLDescription();
 s:= s+' in [';
 for i:= 1 to Attribute.nbValues do
  if (i in FSetValues)
   then s:= s+Attribute.LstValues.getDescription(i)+',';
 s:= copy(s,1,pred(length(s)));
 s:= s+']';
 result:= s;
end;

function TRuleCondDiscrete.getTXTDescription(short: boolean = TRUE): string;
var s: string;
    i: TTypeDiscrete;
begin
 //WARNING -- si description courte, on considre que le cardinal est gal  1 toujours, a peut ne pas tre le cas dans certaines versions de l'arbre de dcision
 s:= inherited getTXTDescription(short);
 if short
  then
   begin
    s:= s+' = ';
    for i:= 1 to Attribute.nbValues do
     if (i in FSetValues)
      then
       begin
        s:= s+Attribute.LstValues.getDescription(i)+',';
        break;
       end;
   end
  else
   begin
    s:= s+' in [';
    for i:= 1 to Attribute.nbValues do
     if (i in FSetValues)
      then s:= s+Attribute.LstValues.getDescription(i)+',';
    s:= s+']';
   end;
 result:= s;
end;

function TRuleCondDiscrete.TestExample(const example: integer): boolean;
begin
 result:= self.TestValue(self.FAtt.dValue[example]);
end;

{ TRuleCondContinue }

constructor TRuleCondContinue.Create(prmAtt: TAttribute;
  prmOp: TTypeConditionOperator; prmValue: TTypeContinue);
begin
 inherited Create(prmAtt,prmOp);
 FThresoldValue:= prmValue;
end;

function TRuleCondContinue.TestValue(const prmValue: TTypeDiscrete): boolean;
var tmp: TTypeContinue;
begin
 tmp:= prmValue;
 //bon typage
 result:= self.TestValue(tmp);
end;

procedure TRuleCondContinue.Merge(prmOther: TRuleCondition);
var other: TRuleCondContinue;
begin
 other:= prmOther as TRuleCondContinue;
 //<, on prend le min
 if (self.Operator = 1) and (other.Operator = 1) and (other.ThresoldValue<self.ThresoldValue)
  then self.FThresoldValue:= other.ThresoldValue;
 //>=, on prend le max
 if (self.Operator = 2) and (other.Operator = 2) and (other.ThresoldValue>self.ThresoldValue)
  then self.FThresoldValue:= other.ThresoldValue;
end;

function TRuleCondContinue.TestValue(const prmValue: TTypeContinue): boolean;
begin
 case Operator of
  1: result:= (prmValue<FThresoldValue)
  else result:= (prmValue>=FThresoldValue);
 end;
end;

function TRuleCondContinue.Duplicate: TRuleCondition;
begin
 result:= TRuleCondContinue.Create(Attribute,Operator,FThresoldValue);
end;

procedure TRuleCondContinue.SetNewThresold(prmValue: TTypeContinue);
begin
 FThresoldValue:= prmValue;
end;

function TRuleCondContinue.getHTMLDescription: string;
var s: string;
begin
 s:= inherited getHTMLDescription();
 case Operator of
  1: s:= s+'<'
  else s:= s+'>=';
 end;
 s:= s+format(STR_FORMAT_VIEW_STAT_ACCURACY,[FThresoldValue]);
 result:= s;
end;

function TRuleCondContinue.getTXTDescription(short: boolean): string;
var s: string;
begin
 s:= inherited getTXTDescription(short);
 case Operator of
  1: s:= s+' < '
  else s:= s+' >= ';
 end;
 s:= s+format(STR_FORMAT_VIEW_STAT_ACCURACY,[FThresoldValue]);
 result:= s;
end;

function TRuleCondContinue.TestExample(const example: integer): boolean;
begin
 result:= self.TestValue(self.FAtt.cValue[example]);
end;

end.
