(************************************************************************)
(* UCalcRulesImplementation.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(************************************************************************)

{
@abstract(Dfinition des structures de rgles)
@author(Ricco)
@created(21/04/2005)

L'ide est de pouvoir dfinir des structures de rgles de production

}


unit UCalcRulesImplementation;

interface

USES
   Contnrs,
   UCalcRulesDefinition,
   UDatasetDefinition,
   UCalcDistribution;

TYPE

   //une prmisse -- qui reprsente en fait une liste de condition "attribut-valeur"
   TRulePremisse = class
                   private
                   //liste des propositions
                   FLstCond: TObjectList;
                   public
                   //cration et dfinir si la liste est-elle propritaire des propositions
                   constructor create(prmOwner: boolean);
                   //destructeur
                   destructor  destroy(); override;
                   //ajouter une condition
                   procedure   addCondition(prmCond: TRuleCondition);
                   //tester si un individu est couvert
                   function    testExample(example: integer): boolean;
                   //tester si un descripteur est prsent dans la premiss
                   function    isPresent(att: TAttribute): boolean;
                   //afficher
                   function    getHTMLDescription(): string;
                   end;

   //rgle de production -- la conclusion est quelconque
   TRuleProductionRule = class
                         private
                         //owner des condition ou pas
                         FOwner: boolean;
                         //prmisse
                         FPremisse: TRulePremisse;
                         //conclusion
                         FConclusion: TRuleCondition;
                         //distribution associe  la rgle
                         FDistribution: TTabFrequence;
                         public
                         //la conclusion est dfinie au dpart
                         constructor create(prmOwner: boolean; conclusion: TRuleCondition);
                         //dtruire...snif...
                         destructor  destroy(); override;
                         //ajout d'une condition dans la prmisse
                         procedure   addCondition(prmCond: TRuleCondition);
                         //fixer aprs coup la conclusion
                         procedure   setConclusion(conclusion: TRuleCondition);
                         //tester si un exemple est couvert
                         function    testExample(example: integer): boolean;
                         //tester si le descripteur est prsent dans la rgle
                         function    isDescriptorPresent(att: TAttribute): boolean;
                         //tester si la premisse contient des conditions
                         function    isEmptyPremisse(): boolean;
                         //assigner une distribution
                         procedure   setDistribution(dist: TTabFrequence);
                         //la prmisse
                         property    Premisse: TRulePremisse read FPremisse;
                         property    Conclusion: TRuleCondition read FConclusion;
                         property    Distribution: TTabFrequence read FDistribution;
                         end;

   //une suite de rgles -- la liste peut tre propritaire ou pas
   TRuleKBSProductionRule = class
                            private
                            //liste des rgles
                            FLstRule: TObjectList;
                            public
                            //constructeur -- par dfaut la liste est propritaire
                            constructor Create();
                            //
                            destructor  Destroy(); override;
                            //ajouter une rgle
                            procedure   addRule(prmRule: TRuleProductionRule);
                            //nombre de rgles dans la base de rgles
                            function    count(): integer;
                            //rcuprer une rgle
                            function    getRule(index: integer): TRuleProductionRule;
                            end;

implementation

{ TRulePremisse }

procedure TRulePremisse.addCondition(prmCond: TRuleCondition);
begin
 if not(FLstCond.OwnsObjects)
  //ajout simple de la rfrence
  then FLstCond.Add(prmCond)
  //cration d'une copie et insertion
  else FLstCond.Add(prmCond.Duplicate());
end;

constructor TRulePremisse.create(prmOwner: boolean);
begin
 inherited Create();
 FLstCond:= TObjectList.Create(prmOwner);
end;

destructor TRulePremisse.destroy;
begin
 FLstCond.Free();
 inherited destroy();
end;

function TRulePremisse.getHTMLDescription: string;
var s: string;
    i: integer;
begin
 s:= '';
 for i:= 0 to pred(FLstCond.Count) do
  s:= s+(FLstCond.Items[i] as TRuleCondition).getHTMLDescription()+' -- ';
 //and then..
 if (Length(s) > 0)
  then result:= copy(s,1,Length(s)-4)
  else result:= '';
end;

function TRulePremisse.isPresent(att: TAttribute): boolean;
var ok: boolean;
    i: integer;
begin
 ok:= false;
 for i:= 0 to pred(self.FLstCond.Count) do
  begin
   if ((self.FLstCond.Items[i] as TRuleCondition).Attribute = att)
    then
     begin
      ok:= true;
      BREAK;
     end;
  end;
 result:= ok;
end;

function TRulePremisse.testExample(example: integer): boolean;
var ok: boolean;
    i: integer;
begin
 ok:= true;
 for i:= 0 to pred(self.FLstCond.Count) do
  ok:= ok AND (self.FLstCond.Items[i] as TRuleCondition).TestExample(example);
 result:= ok;
end;

{ TRuleProductionRule }

procedure TRuleProductionRule.addCondition(prmCond: TRuleCondition);
begin
 FPremisse.addCondition(prmCond);
end;

constructor TRuleProductionRule.create(prmOwner: boolean;
  conclusion: TRuleCondition);
begin
 inherited Create();
 FOwner:= prmOwner;
 //prmisse
 FPremisse:= TRulePremisse.create(prmOwner);
 if assigned(conclusion)
  then
   begin
     if prmOwner
      then FConclusion:= conclusion.Duplicate()
      else FConclusion:= conclusion;
   end;
end;

destructor TRuleProductionRule.destroy;
begin
 FPremisse.Free();
 if FOwner then FConclusion.Free();
 if (FOWner and assigned(FDistribution)) then FDistribution.Free();
 inherited;
end;

function TRuleProductionRule.isDescriptorPresent(att: TAttribute): boolean;
begin
 result:= FPremisse.isPresent(att);
end;

function TRuleProductionRule.isEmptyPremisse: boolean;
begin
 result:= (FPremisse.FLstCond.Count = 0);
end;

procedure TRuleProductionRule.setConclusion(conclusion: TRuleCondition);
begin
 if FOwner
  then FConclusion:= conclusion
  else FConclusion:= conclusion.Duplicate();
end;

procedure TRuleProductionRule.setDistribution(dist: TTabFrequence);
begin
 FDistribution:= dist;
end;

function TRuleProductionRule.testExample(example: integer): boolean;
begin
 result:= FPremisse.testExample(example);
end;

{ TRuleKBSProductionRule }

procedure TRuleKBSProductionRule.addRule(prmRule: TRuleProductionRule);
begin
 FLstRule.Add(prmRule);
end;

function TRuleKBSProductionRule.count: integer;
begin
 result:= FLstRule.Count;
end;

constructor TRuleKBSProductionRule.Create;
begin
 inherited Create();
 FLstRule:= TObjectList.Create(TRUE);
end;

destructor TRuleKBSProductionRule.Destroy;
begin
 FLstRule.Free();
 inherited;
end;

function TRuleKBSProductionRule.getRule(
  index: integer): TRuleProductionRule;
begin
 if (index < 0) or (index >= self.count())
  then result:= nil
  else result:= FLstRule.Items[index] as TRuleProductionRule;
end;

end.
