(************************************************************)
(* UCalcStatDes.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(************************************************************)

{
@abstract(Unit de dfinition de l'oprateur de statistique descriptive)
@author(Ricco)
@created(12/01/2004)

}
unit UCalcStatDes;

interface

USES
        Classes, Contnrs,
        UDatasetDefinition,
        UDatasetExamples,
        UCalcDistribution;

CONST
        {pour annoncer qu'aucun rsultat n'a pu tre trouv}
        STAT_DES_MISSING_RESULT = -99999;

TYPE
        {type abstrait pour les stat descriptives}
        TCalcStatDes = class(TObject)
                       private
                       {Attribut concern}
                       FAtt: TAttribute;
                       protected
                       {Nombre d'individus utiliss pour les calculs}
                       FNbExamples: Integer;
                       {connecter la variable, a peut tre l'occasion d'initialisations}
                       procedure ConnectAtt(prmAtt: TAttribute); virtual;
                       {initialization des valeurs internes pour les ajouts -  surcharger absolument,
                       c'est un peu comme un BeginUpdate}
                       procedure   BeginUpdate(); virtual;
                       {procedure  ajouter une valeur pour les stats sur la base d'un individu}
                       procedure   AddValue(prmExample: integer); virtual;
                       {finalise les ajouts, permet de calculer les indicateurs qui ne sont calculables qu' la fin}
                       procedure   EndUpdate(); virtual;
                       public
                       {construire et connecter aux donnes}
                       constructor Create(prmAtt: TAttribute; prmExamples: TExamples = nil);
                       {lancer les calculs sur les individus, un calcul par dfaut est effectu sur chaque individu
                       cette procdure peut tre surcharge pour une optimisation des calculs}
                       procedure   RefreshStat(prmExamples: TExamples); virtual;
                       {envoyer la description des rsultats}
                       function    getHTMLResult(prmOption: integer = -1): string; virtual; abstract;
                       {dupliquer l'objet}
                       function    duplicate(): TCalcStatDes; virtual;
                       {attribut}
                       property Attribute: TAttribute read FAtt;
                       {nombre d'observations utilis}
                       property NbExamples: integer read FNbExamples;
                       end;

        {stat desc pour les attributs discrets}
        TCalcStatDesDiscrete = class(TCalcStatDes)
                               private
                               {tableau de frquence}
                               FTabFreq: TTabFrequence;
                               {indice de gini}
                               FGini: double;
                               {calcul de l'indice de gini}
                               procedure CalcGini();
                               protected
                               procedure ConnectAtt(prmAtt: TAttribute); override;
                               public
                               procedure   BeginUpdate(); override;
                               procedure   AddValue(prmExample: integer); override;
                               procedure   RemoveValue(prmExample: integer);
                               procedure   EndUpdate(); override;
                               procedure   RefreshStat(prmExamples: TExamples); override;
                               destructor  Destroy; override;
                               function    getHTMLResult(prmOption: integer = -1): string; override;
                               {fusionner avec une autre stat}
                               procedure   Merge(prmSource: TCalcStatDesDiscrete);
                               function    duplicate(): TCalcStatDes; override;
                               {envoyer la stat de Shannon}
                               function    Shannon(): double;
                               {envoyer la stat de Gini -- Sauce Breiman et al.}
                               function    GiniIndex(): double;
                               {indice de gini}
                               property    Gini: double read FGini;
                               {le tableau de frquence}
                               property    TabFreq: TTabFrequence read FTabFreq;
                               end;

        {stat des pour les attributs continus}
        TCalcStatDesContinuous = class(TCalcStatDes)
                                 private
                                 FMin, FMax: TTYpeContinue;
                                 FSum, FSumSquare: double;
                                 //new -- 09/09/2005 -- nouveau Somme des cubes et des puissances 4
                                 FSumP3, FSumP4: double;
                                 function    funcAverage: double;
                                 function    funcVariance: double;
                                 function    funcStdDev: double;
                                 function    funcCoefVar: double;
                                 function    funcTSS: double;
                                 public
                                 procedure   SetValues(min,max: TTypeContinue; s,sqs: double; nb: integer);
                                 procedure   BeginUpdate(); override;
                                 procedure   AddValue(prmExample: integer); override;
                                 procedure   EndUpdate(); override;
                                 procedure   RefreshStat(prmExamples: TExamples); override;
                                 function    getHTMLResult(prmOption: integer = -1): string; override;
                                 function    duplicate(): TCalcStatDes; override;
                                 procedure   merge(other: TCalcStatDesContinuous);
                                 //new - 09/09/2005 -- moment centr d'ordre 4, non pondr --> [Somme(x_i-x_barre^4)]
                                 function    TMC4(): double;
                                 //moment centr d'ordre 4 --> 1/n * [Somme(x_i-x_barre^4)]
                                 function    MC4(): double;
                                 //proprits
                                 property    Min: TTypeContinue read FMin;
                                 property    Max: TTypeContinue read FMax;
                                 property    Sum: double read FSum;
                                 property    SumSquare: double read FSumSquare;
                                 property    Average: double read funcAverage;
                                 property    Variance: double read funcVariance;
                                 property    StdDev: double read funcStdDev;
                                 property    CoefVar: double read funcCoefVar;
                                 property    TSS: double read funcTSS;
                                 end;

        {liste de rsultats de stat. descriptives}
        TLstCalcStatDes = class(TObject)
                          private
                          {mode de comparaison lors du tri
                                    -1 -> pas de comparaison
                                    0 -> le nom de l'attribut,
                                    *** les classes descendantes ajouteront d'autres modes}
                          FCompareMode: integer;
                          {compter le nombre d'exemples couverts par les stats}
                          function    GetNbExamples(): integer;
                          protected
                          {liste de stat descriptives - propritaire !!!}
                          FLstStat: TObjectList;
                          {ajouter une stat des dans la liste}
                          procedure   AddStatFromAtt(prmAtt: TAttribute); virtual;
                          {rcuprer la liste}
                          function    getEachStatHTMLResults(prmOption: integer = -1): string;
                          public
                          {passage des attributs slectionns pour le calcul}
                          constructor Create(prmLstAtt: TLstAttributes; prmExamples: TExamples);
                          {R.R. -- new -- 04/03/05 -- pas de destroy ici ??? -- bizarre, bizarre... -- on ajoute en tous cas}
                          destructor  Destroy(); override;
                          {reconstruire la liste des stats}
                          procedure   RebuildStatDes(prmLstAtt: TLstAttributes; prmExamples: TExamples); overload; virtual;
                          procedure   RebuildStatDes(prmStrList: TStrings; prmExamples: TExamples); overload; virtual;
                          {ajouter une stat descriptive qq soit son type}
                          procedure   AddStat(prmStat: TCalcStatDes);
                          {rafraichir la liste de stats}
                          procedure   RefreshStat(prmExamples: TExamples);
                          {vider la liste}
                          procedure   FreeAll();
                          {nombre de stat dispo}
                          function    Count(): integer;
                          {la statistique n i}
                          function    Stat(i: integer): TCalcStatDes;
                          {rinitialisation de tous les rsultats}
                          procedure   BeginUpdate();
                          {ajouter un exemple}
                          procedure   AddValue(prmExample: integer);
                          {finaliser les ajouts}
                          procedure   EndUpdate();
                          {trier les rsultats - inactif ici}
                          procedure   SortStats(); virtual ;
                          {rcuprer l'en-tte de tableau de rsultats, surcharge obligatoire, rien ici}
                          function    getHeaderHTML(): string; virtual;
                          {rcuprer la description statistiques des lmnts}
                          function    getHTMLResults(prmOption: Integer = -1): string;
                          {liste de stats}
                          property    LstStat: TObjectList read FLstStat;
                          {mode de comparaison}
                          property    CompareMode: integer read FCompareMode write FCompareMode;
                          {exemples couverts}
                          property    NbExamples: integer read GetNbExamples;
                          end;

        {liste de rsultats de stat des continues - nouveaux critres de tri:
                                    1 -> le min,
                                    2 -> le max,
                                    3 -> la moyenne,
                                    4 -> le coef de variation}
        TLstCalcStatDesContinuous = class(TLstCalcStatDes)
                                    public
                                    function    getHeaderHTML(): string; override;
                                    {comparaison pour les stats continues}
                                    procedure SortStats(); override;
                                    end;

        {liste de rsultats de stat des discrtes - autres critres de tri:
        1 -> le nombre de valeurs,
        2 -> l'indice de gini}
        TLstCalcStatDesDiscrete = class(TLstCalcStatDes)
                                  public
                                  function    getHeaderHTML(): string; override;
                                  {comparaison pour les stats discrtes}
                                  procedure SortStats(); override;
                                  end;

{fonction de comparaison de rsultats de stats fiond sur le nom du principal attribut}
function ListSortCompareName(item1,item2: pointer): integer;

implementation

uses
        Sysutils,
        Math,
        UConstConfiguration;

{****************** FONCTIONS DE COMPARAISONS POUR LES TRIS *******************}

{trier selon les noms d'attributs}
function ListSortCompareName(item1,item2: pointer): integer;
var st1,st2: TCalcStatDes;
begin
 st1:= TCalcStatDes(item1);
 st2:= TCalcStatDes(item2);
 if (st1.Attribute.Name<st2.Attribute.Name)
  then result:= -1
  else
   if (st1.Attribute.Name>st2.Attribute.Name)
    then result:= +1
    else result:= 0;
end;

{trier selon le min de la stat continue}
function ListSortCompareMin(item1,item2: pointer): integer;
var st1,st2: TCalcStatDesContinuous;
begin
 st1:= TCalcStatDesContinuous(item1);
 st2:= TCalcStatDesContinuous(item2);
 if (st1.Min<st2.Min)
  then result:= -1
  else
   if (st1.Min>st2.Min)
    then result:= +1
    else result:= 0;
end;

{trier selon le max de la stat continue}
function ListSortCompareMax(item1,item2: pointer): integer;
var st1,st2: TCalcStatDesContinuous;
begin
 st1:= TCalcStatDesContinuous(item1);
 st2:= TCalcStatDesContinuous(item2);
 if (st1.Max<st2.Max)
  then result:= -1
  else
   if (st1.Max>st2.Max)
    then result:= +1
    else result:= 0;
end;

{trier selon la moyenne de la stat cond}
function ListSortCompareAvg(item1,item2: pointer): integer;
var st1,st2: TCalcStatDesContinuous;
begin
 st1:= TCalcStatDesContinuous(item1);
 st2:= TCalcStatDesContinuous(item2);
 if (st1.Average<st2.Average)
  then result:= -1
  else
   if (st1.Average>st2.Average)
    then result:= +1
    else result:= 0;
end;

{trier selon le coef var de la stat cond}
function ListSortCompareCoefVar(item1,item2: pointer): integer;
var st1,st2: TCalcStatDesContinuous;
begin
 st1:= TCalcStatDesContinuous(item1);
 st2:= TCalcStatDesContinuous(item2);
 if (st1.CoefVar<st2.CoefVar)
  then result:= -1
  else
   if (st1.CoefVar>st2.CoefVar)
    then result:= +1
    else result:= 0;
end;

{trier selon le nombre de valeurs de l'attribut forcment discret}
function ListSortCompareNbValues(item1,item2: pointer): integer;
var st1,st2: TCalcStatDesDiscrete;
begin
 st1:= TCalcStatDesDiscrete(item1);
 st2:= TCalcStatDesDiscrete(item2);
 if (st1.Attribute.nbValues<st2.Attribute.nbValues)
  then result:= -1
  else
   if (st1.Attribute.nbValues>st2.Attribute.nbValues)
    then result:= +1
    else result:= 0;
end;

{trier selon l'indice de gini}
function ListSortCompareGini(item1,item2: pointer): integer;
var st1,st2: TCalcStatDesDiscrete;
begin
 st1:= TCalcStatDesDiscrete(item1);
 st2:= TCalcStatDesDiscrete(item2);
 if (st1.Gini<st2.Gini)
  then result:= -1
  else
   if (st1.Gini>st2.Gini)
    then result:= +1
    else result:= 0;
end;

{******************************************************************************}

{ TCalcStatDes }

procedure TCalcStatDes.AddValue(prmExample: integer);
begin
 //rien
end;

procedure TCalcStatDes.BeginUpdate;
begin
 //rien
end;

procedure TCalcStatDes.ConnectAtt(prmAtt: TAttribute);
begin
 FAtt:= prmAtt;
end;

constructor TCalcStatDes.Create(prmAtt: TAttribute;
  prmExamples: TExamples);
begin
 inherited Create();
 self.ConnectAtt(prmAtt);
 //self.BeginUpdate();
 if assigned(prmExamples)
  then self.RefreshStat(prmExamples);
end;

function TCalcStatDes.duplicate: TCalcStatDes;
begin
 result:= NIL;
end;

procedure TCalcStatDes.EndUpdate;
begin
 //rien  priori, sauf pour les discrets
end;

procedure TCalcStatDes.RefreshStat(prmExamples: TExamples);
var i: integer;
begin
 self.BeginUpdate();
 for i:= 1 to prmExamples.Size do
  self.AddValue(prmExamples.Number[i]);
 self.EndUpdate();
end;

{ TLstCalcStatDes }

procedure TLstCalcStatDes.AddStatFromAtt(prmAtt: TAttribute);
var stat: TCalcStatDes;
begin
 //case prmAtt.Category of
 if prmAtt.isCategory(caDiscrete)
  then stat:= TCalcStatDesDiscrete.Create(prmAtt)
  else stat:= TCalcStatDesContinuous.Create(prmAtt);
 FLstStat.Add(stat);
end;

constructor TLstCalcStatDes.Create(prmLstAtt: TLstAttributes;
  prmExamples: TExamples);
begin
 inherited Create();
 FCompareMode:= -1;
 FLstStat:= TObjectList.Create(TRUE);
 if assigned(prmLstAtt)
  then self.RebuildStatDes(prmLstAtt,prmExamples);
end;

procedure TLstCalcStatDes.RebuildStatDes(prmLstAtt: TLstAttributes;
  prmExamples: TExamples);
var i: integer;
begin
 FLstStat.Clear;
 if assigned(prmLstAtt)
  then
   begin
     //reconstruire la liste interne
     for i:= 0 to pred(prmLstAtt.Count) do
      self.AddStatFromAtt(prmLstAtt.Attribute[i]);
   end;
 //puis si individus prsents, calculer
 if assigned(prmExamples)
  then self.RefreshStat(prmExamples);
end;

procedure TLstCalcStatDes.FreeAll;
begin
 FLstStat.Clear;
end;

procedure TLstCalcStatDes.RebuildStatDes(prmStrList: TStrings;
  prmExamples: TExamples);
var i: integer;
begin
 FLstStat.Clear;
 //reconstruire la liste interne
 for i:= 0 to pred(prmStrList.Count) do
   self.AddStatFromAtt(prmStrList.Objects[i] as TAttribute);
 //puis si individus prsents, calculer
 if assigned(prmExamples)
  then self.RefreshStat(prmExamples);
end;

procedure TLstCalcStatDes.RefreshStat(prmExamples: TExamples);
var i: Integer;
begin
 for i:= 0 to pred(FLstStat.Count) do
  (FLstStat.Items[i] as TCalcStatDes).RefreshStat(prmExamples);
end;

function TLstCalcStatDes.Count: integer;
begin
 result:= FLstStat.Count;
end;

function TLstCalcStatDes.Stat(i: integer): TCalcStatDes;
begin
 result:= FLstStat.Items[i] as TCalcStatDes;
end;


procedure TLstCalcStatDes.BeginUpdate;
var i: Integer;
begin
 for i:= 0 to pred(FLstStat.Count) do
  self.Stat(i).BeginUpdate();
end;

procedure TLstCalcStatDes.AddValue(prmExample: integer);
var i: Integer;
begin
 for i:= 0 to pred(FLstStat.Count) do
  self.Stat(i).AddValue(prmExample);
end;

procedure TLstCalcStatDes.EndUpdate;
var i: Integer;
begin
 for i:= 0 to pred(FLstStat.Count) do
  self.Stat(i).EndUpdate();
end;

procedure TLstCalcStatDes.AddStat(prmStat: TCalcStatDes);
begin
 FLstStat.Add(prmStat)
end;

function TLstCalcStatDes.getHTMLResults(prmOption: Integer): string;
var s: string;
begin
 //les rsultats apparaissent toujours sous forme de tableaux
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+ self.getHeaderHTML();
 s:= s+ self.getEachStatHTMLResults(prmOption);
 s:= s+ '</TABLE>';
 result:= s;
end;

function TLstCalcStatDes.getEachStatHTMLResults(prmOption: integer): string;
var i: integer;
    stat: TCalcStatDes;
    s: string;
begin
 s:= '';
 for i:= 0 to pred(self.Count) do
  begin
   //chaque ligne de rsultat du tableau
   stat:= self.Stat(i);
   s:= s+HTML_TABLE_COLOR_DATA_GRAY;
   s:= s+stat.getHTMLResult(prmOption);
   s:= s+'</TR>';
  end;
 result:= s;
end;

procedure TLstCalcStatDes.SortStats;
begin
 //nothing
end;

function TLstCalcStatDes.getHeaderHTML: string;
begin
 result:= '';
end;

function TLstCalcStatDes.GetNbExamples: integer;
begin
 result:= 0;
 //il suffit de prendre le premier
 if (self.Count()>0)
  then result:= self.Stat(0).NbExamples;
end;

destructor TLstCalcStatDes.Destroy;
begin
 FLstStat.Free();
 inherited;
end;

{ TCalcStatDesContinuous }

procedure TCalcStatDesContinuous.AddValue(prmExample: integer);
var tmpValue: TTypeContinue;
begin
 tmpValue:= FAtt.cValue[prmExample];
 If (tmpValue<FMin) Then FMin:= tmpValue;
 if (tmpValue>FMax) Then FMax:= tmpValue;
 FSum := FSum + tmpValue;
 FSumSquare:= FSumSquare + tmpValue * tmpValue;
 FSumP3:= FSumP3 + tmpValue * tmpValue * tmpValue;
 FSumP4:= FSumP4 + tmpValue * tmpValue * tmpValue * tmpValue;
 inc(FNbExamples);
end;

procedure TCalcStatDesContinuous.BeginUpdate;
begin
 FSum:= 0;
 FSumSquare:= 0;
 FSumP3:= 0.0;
 FSumP4:= 0.0;
 FNbExamples:= 0;
 FMin:= 1e38;
 FMax:= -1e38;
end;

function TCalcStatDesContinuous.duplicate: TCalcStatDes;
var output: TCalcStatDesContinuous;
begin
 output:= TCalcStatDesContinuous.Create(self.Attribute,NIL);
 output.FMin:= self.Min;
 output.FMax:= self.Max;
 output.FSum:= self.Sum;
 output.FSumSquare:= self.SumSquare;
 output.FNbExamples:= self.NbExamples;
 result:= output;
end;

procedure TCalcStatDesContinuous.EndUpdate;
begin
 //nothing
end;

function TCalcStatDesContinuous.funcAverage: double;
begin
 if (FNbExamples>0)
  then result:= FSum/(1.0*FNbExamples)
  else result:= STAT_DES_MISSING_RESULT;
end;

function TCalcStatDesContinuous.funcCoefVar: double;
var avg: double;
begin
 //coefficient de variation = std-dev / avg (!)
 avg:= self.Average;
 if (avg<>STAT_DES_MISSING_RESULT) and (abs(avg)>EPSILON_VALUE)
  then result:= self.StdDev/avg
  else result:= STAT_DES_MISSING_RESULT;
end;

function TCalcStatDesContinuous.funcStdDev: double;
var v:double;
begin
 v:= self.funcVariance();
 if (v>=0)
  then result:= SQRT(v)
  else result:= STAT_DES_MISSING_RESULT;
end;

function TCalcStatDesContinuous.funcTSS: double;
var m: double;
begin
 if (FNbExamples>0)
  then
   begin
    m:= self.Average;
    //new -- 22/07/2005 -- au pire elle doit tre gale  zro
    result:= MATH.MAX(FSumSquare-(1.0*FNbExamples)*m*m , 0.0);
   end
  else RESULT:= STAT_DES_MISSING_RESULT;
end;

function TCalcStatDesContinuous.funcVariance: double;
begin
 if (FNbExamples>1)
  then result:= funcTSS/(-1.0+FNbExamples)//sur chantillon -- new -- 05/07/2004
  else RESULT:= STAT_DES_MISSING_RESULT;
end;

function TCalcStatDesContinuous.getHTMLResult(prmOption: integer): string;
begin
 result:= format('<TD>%s</TD>'+
              '<TD align=right>'+VIEW_ATTRIBUTE_ACCURACY_CONTINUE+'</TD>'+
              '<TD align=right>'+VIEW_ATTRIBUTE_ACCURACY_CONTINUE+'</TD>'+
              '<TD align=right>'+STR_FORMAT_VIEW_STAT_ACCURACY+'</TD>'+
              '<TD align=right>'+STR_FORMAT_VIEW_STAT_ACCURACY+'</TD>'+
              '<TD align=right>'+STR_FORMAT_VIEW_STAT_ACCURACY+'</TD>',
              [self.Attribute.name,self.Min,self.Max,self.Average,self.StdDev,self.CoefVar]);
end;

function TCalcStatDesContinuous.MC4: double;
begin
 if (self.NbExamples > 0)
  then result:= self.TMC4() / (1.0 * self.NbExamples)
  else result:= 0.0;
end;

procedure TCalcStatDesContinuous.merge(other: TCalcStatDesContinuous);
begin
 if (self.Min > other.Min)
  then self.FMin:= other.Min;
 if (self.Max < other.Max)
  then self.FMax:= other.Max;
 self.FSum:= self.Sum + other.Sum;
 self.FSumSquare:= self.SumSquare + other.SumSquare;
 self.FSumP3:= self.FSumP3 + other.FSumP3;
 self.FSumP4:= self.FSumP4 + other.FSumP4;
 self.FNbExamples:= self.NbExamples + other.NbExamples;
end;

procedure TCalcStatDesContinuous.RefreshStat(prmExamples: TExamples);
var i: integer;
    tmpValue: TTYpeContinue;
begin
 self.BeginUpdate();
 //go...
 For i:= 1 To prmExamples.Size Do
  Begin
   tmpValue:= FAtt.cValue[prmExamples.Number[i]];
   If (tmpValue<FMin) Then FMin:= tmpValue;
   if (tmpValue>FMax) Then FMax:= tmpValue;
   FSum := FSum + tmpValue;
   FSumSquare:= FSumSquare+ tmpValue*tmpValue;
   FSumP3:= FSumP3 + tmpValue * tmpValue * tmpValue;
   FSumP4:= FSumP4 + tmpValue * tmpValue * tmpValue * tmpValue;
   inc(FNbExamples);
  End;
 //ne pas oublier
 self.EndUpdate();
end;


procedure TCalcStatDesContinuous.SetValues(min,max: TTypeContinue; s,sqs: double; nb: integer);
begin
 FMin:= min;
 FMax:= max;
 FSum:= s;
 FSumSquare:= sqs;
 FNbExamples:= nb;
end;

function TCalcStatDesContinuous.TMC4: double;
var m,s: double;
begin
 m:= self.Average;
 //dcomposition de Somme(x_i - x_barre^4)
 s:= FSumP4;
 s:= s - 4.0 * m * FSumP3;
 s:= s + 6.0 * m * m * FSumSquare;
 s:= s - 3.0 * self.NbExamples * power(m,4.0); 
 //
 result:= s;
end;

{ TCalcStatDesDiscrete }

procedure TCalcStatDesDiscrete.AddValue(prmExample: integer);
begin
 inc(FNbExamples);
 FTabFreq.IncrementCell(FAtt.dValue[prmExample]);
end;

procedure TCalcStatDesDiscrete.BeginUpdate;
begin
 FNbExamples:= 0;
 FGini:= 0.0;
 FTabFreq.ReInitialization();
end;

procedure TCalcStatDesDiscrete.CalcGini;
var i: integer;
    value: double;
begin
 FGini:= 0.0;
 if (FTabFreq.Value[0]>0)
  then
   begin
    for i:= 1 to FTabFreq.Size do
     begin
      value:= FTabFreq.Frequence[i];
      FGini:= FGini+value*(1.0-value);
     end;
   end;
end;

procedure TCalcStatDesDiscrete.ConnectAtt(prmAtt: TAttribute);
begin
 inherited ConnectAtt(prmAtt);
 FTabFreq:= TTabFrequence.CreateFromAtt(prmAtt,NIL);
end;

destructor TCalcStatDesDiscrete.Destroy;
begin
 FTabFreq.Free;
 inherited Destroy;
end;

function TCalcStatDesDiscrete.duplicate: TCalcStatDes;
var stat: TCalcStatDesDiscrete;
begin
 stat:= TCalcStatDesDiscrete.Create(Attribute,nil);
 stat.FNbExamples:= self.NbExamples;
 stat.TabFreq.ReInitialization();
 stat.TabFreq.Merge(self.TabFreq);
 stat.FGini:= self.Gini;
 result:= stat;
end;

procedure TCalcStatDesDiscrete.EndUpdate;
begin
 self.CalcGini();
end;

function TCalcStatDesDiscrete.getHTMLResult(prmOption: integer): string;
var s: string;
begin
   s:= format('<TD>%s</TD>'+
              '<TD>'+STR_FORMAT_VIEW_STAT_ACCURACY+'</TD>',[self.Attribute.Name,self.Gini]);

   s:= s+'<TD>';
   s:= s+self.TabFreq.getHTMLResult();
   s:= s+'</TD>';

   result:= s;
end;

function TCalcStatDesDiscrete.GiniIndex: double;
begin
 self.CalcGini();
 result:= FGini;
end;

procedure TCalcStatDesDiscrete.Merge(prmSource: TCalcStatDesDiscrete);
begin
 FTabFreq.Merge(prmSource.TabFreq);
 self.CalcGini();
end;

procedure TCalcStatDesDiscrete.RefreshStat(prmExamples: TExamples);
begin
 FTabFreq.Refresh(prmExamples);
 FNbExamples:= prmExamples.Size;
 //calcul des stats
 self.CalcGini();
end;

procedure TCalcStatDesDiscrete.RemoveValue(prmExample: integer);
begin
 dec(FNbExamples);
 FTabFreq.DecrementCell(FAtt.dValue[prmExample]);
end;

function TCalcStatDesDiscrete.Shannon: double;
var i: integer;
    value: double;
    sum: double;
begin
 sum:= 0.0;
 if (FTabFreq.Value[0]>0)
  then
   begin
    for i:= 1 to FTabFreq.Size do
     begin
      value:= FTabFreq.Frequence[i];
      if (value>0)
       then sum:= sum+value*log2(value);
     end;
   end;
 result:= sum;
end;

{ TLstCalcStatDesContinuous }

function TLstCalcStatDesContinuous.getHeaderHTML: string;
begin
 result:= HTML_TABLE_COLOR_HEADER_GRAY+'<TH>Attribute</TH><TH>Min</TH><TH>Max</TH><TH>Average</TH><TH>Std-dev</TH><TH>Std-dev/avg</TH></TR>';
end;

procedure TLstCalcStatDesContinuous.SortStats;
var funcCompare: TListSortCompare;
begin
 if (FCompareMode>=0)
  then
   begin
    case FCompareMode of
     0: funcCompare:= ListSortCompareName;
     1: funcCompare:= ListSortCompareMin;
     2: funcCompare:= ListSortCompareMax;
     3: funcCompare:= ListSortCompareAvg;
     4: funcCompare:= ListSortCompareCoefVar;
     else
      funcCompare:= NIL;
    end;

    if assigned(funcCompare)
     then FLstStat.Sort(funcCompare);
   end;
end;

{ TLstCalcStatDesDiscrete }

function TLstCalcStatDesDiscrete.getHeaderHTML: string;
begin
 result:= HTML_TABLE_COLOR_HEADER_GRAY+'<TH>Attribute</TH><TH>Gini</TH><TH>Distribution</TH></TR>';
end;

procedure TLstCalcStatDesDiscrete.SortStats;
var funcCompare: TListSortCompare;
begin
 if (FCompareMode>=0)
  then
   begin
    case FCompareMode of
     0: funcCompare:= ListSortCompareName;
     1: funcCompare:= ListSortCompareNbValues;
     2: funcCompare:= ListSortCompareGini;
     else
      funcCompare:= NIL;
    end;

    if assigned(funcCompare)
     then FLstStat.Sort(funcCompare);
   end;
end;

end.
