(************************************************************************************)
(* UCalcStatDesNormalityTestFromFORTRAN.pas - Copyright (c) 2005 Ricco RAKOTOMALALA *)
(************************************************************************************)

{
@abstract(Procdures de base pour les tests de normalit)
@author(Ricco)
@created(29/07/2005)

Principale rfrence :
----------------------

Le code DELPHI est une retranscription du code FORTRAN dispo sur le site http://lib.stat.cmu.edu/apstat/
Les rfrences du code FORTRAN sont indiqus dans l'en-tte des procdures et fonctions DELPHI

Tous les calculs sont raliss en Extended, cette bibliothque est totalement indpendante et portable.
}

unit UCalcStatDesNormalityTestFromFORTRAN;

interface

TYPE
        //type de valeurs manipules pour les calculs
        //on peut le modifier si on le dsire par la suite (gros effectifs par exemple)
        TYPE_FLOAT_NOMALITY_TEST = EXTENDED;

//***************************************************************************************************
//SHAPIRO-WILK -- ALGORITHM AS R94 APPL. STATIST. (1995) VOL.44, NO.4 --> valable (3 <= n <= 5000) !
//attention, les donnes passes en paramtres doivent tre tries  l'avance par la procdure appellante !
//attention (bis), l'indice 0 ne contient pas d'observations -- on travaille bien sur [1..N]
PROCEDURE SWILK(var X: array of TYPE_FLOAT_NOMALITY_TEST; N: integer; var W,PW: TYPE_FLOAT_NOMALITY_TEST; var IFAULT: integer);

TYPE
        //grille de rsultats pour KS-Lilliefors -- cf. Table 11.4 -- Avazian et al. (p.309)
        TGRID_RESULTS_KS_LILLIEFORS = (sup_KSL_20,sup_KSL_15,sup_KSL_10,sup_KSL_05,sup_KSL_01,inf_KSL_01);
CONST
        //texte associ  ces rsultats
        TXT_KS_LILLIEFORS : array[TGRID_RESULTS_KS_LILLIEFORS] of string =
        ('p >= 0.20','0.15 =< p < 0.20','0.10 =< p < 0.15','0.05 =< p < 0.10','0.01 =< p < 0.05','p < 0.01');

//*******************************************
//Kolmogorov & Smirnov -- Proba de Lilliefors
//idem, le tableau est trie  l'avance
//l'indice 0 ne sert  rien, on travaille sur [1..N]
//les donnes ont t centres-rduites et tries  l'avance par la procdure appellante
//renvoie le D-, D+, DKS = max(D-,D+) et le palier de p-value
PROCEDURE KSLILLIEFORS(var X: array of TYPE_FLOAT_NOMALITY_TEST; N: integer; var DMoins, DPlus, DKS: TYPE_FLOAT_NOMALITY_TEST; var idProba: TGRID_RESULTS_KS_LILLIEFORS);

TYPE
        //grille de rsultats pour le test d'Anderson-Darling
        TGRID_RESULTS_KS_ANDERSON_DARLING = (sup_AD_10, sup_AD_05, sup_AD_025, sup_AD_01, inf_AD_01);

CONST
        //tableau des chanes de caractres
        TXT_ANDERSON_DARLING : array[TGRID_RESULTS_KS_ANDERSON_DARLING] of string =
        (' p >= 0.10','0.05 =< p < 0.10','0.025 =< p < 0.05','0.01 =< p < 0.025','p < 0.01'); 
        

//*******************************************
//Kolomogorov-Smirnov -- Test d'Anderson-Darling avec seuils critiques spcifiques pour la loi normale
//l'indice 0 ne sert  rien, on travaille sur [1..N]
//les donnes ont t centres-rduites et tries  l'avance par la procdure appellante
//renvoie la statistique A^2 et le palier de p-value
PROCEDURE KS_ANDERSON_DARLING(var X: array of TYPE_FLOAT_NOMALITY_TEST; integerN: integer; var A2: TYPE_FLOAT_NOMALITY_TEST; var idProba: TGRID_RESULTS_KS_ANDERSON_DARLING);

//*******************************************************************************************************************
//d'Agostino -- Test fond sur le Skweness et le Kurtosis = la statistique K2 qui suit un CHI-2  2 degrs de libert
//l'indice 0 ne sert  rien, on travaille sur [1..N]
//les donnes arrivent centres-rduites mais a ne sert  rien dans ce cas
//cf. http://calamar.univ-ag.fr/uag/staps/cours/stat/stat.htm#zg1
//en sortie les zG, la stat. K2 et la p-value pK2
PROCEDURE D_AGOSTINO(var X: array of TYPE_FLOAT_NOMALITY_TEST; integerN: integer; var zG1, zG2, K2, pK2: TYPE_FLOAT_NOMALITY_TEST);

implementation

USES
        Sysutils,
        MATH, ULogFile,
        FMath;

        
CONST
        NORMP_P : array[0..6] of TYPE_FLOAT_NOMALITY_TEST =
        (220.2068679123761E0,221.2135961699311E0,112.0792914978709E0,
        33.91286607838300E0,6.373962203531650E0,
        0.7003830644436881E0,0.3526249659989109E-01);

        NORMP_Q : array[0..7] of TYPE_FLOAT_NOMALITY_TEST =
        (440.4137358247522E0,793.8265125199484E0,637.3336333788311E0,
        296.5642487796737E0,86.78073220294608E0,
        16.06417757920695E0,1.755667163182642E0,
        0.8838834764831844E-1);

        NORMP_CUTOFF : TYPE_FLOAT_NOMALITY_TEST = 7.071E0;

        NORMP_ROOT2PI : TYPE_FLOAT_NOMALITY_TEST = 2.506628274631001E0;

//       Based upon algorithm 5666 for the error function, from:
//       Hart, J.F. et al, 'Computer Approximations', Wiley 1968
//
//       Programmer: Alan Miller
//
//	Latest revision - 30 March 1986

procedure NORMP(Z: TYPE_FLOAT_NOMALITY_TEST; var p,q: TYPE_FLOAT_NOMALITY_TEST; var pdf: TYPE_FLOAT_NOMALITY_TEST);
var ZABS, EXPNTL: TYPE_FLOAT_NOMALITY_TEST;
begin
 ZABS := ABS(Z);
 //grer les cas extrmes
 IF (ZABS > 37.0)
  then
   begin
    pdf:= 0.0;
    if (Z > 0.0)
     then
      begin
       p:= 1.0;
       q:= 0.0;
      end
     else
      begin
       p:= 0.0;
       q:= 1.0;
      end;
   end
  else
   begin
    EXPNTL:= EXP(-0.5*power(ZABS,2.0));
    PDF:= EXPNTL/NORMP_ROOT2PI;
    //
    if (ZABS < NORMP_CUTOFF)
     then
      begin
	  P := EXPNTL*((((((NORMP_P[6]*ZABS + NORMP_P[5])*ZABS + NORMP_P[4])*ZABS + NORMP_P[3])*ZABS +
          NORMP_P[2])*ZABS + NORMP_P[1])*ZABS + NORMP_P[0])/(((((((NORMP_Q[7]*ZABS + NORMP_Q[6])*ZABS +
          NORMP_Q[5])*ZABS + NORMP_Q[4])*ZABS + NORMP_Q[3])*ZABS + NORMP_Q[2])*ZABS + NORMP_Q[1])*ZABS +
          NORMP_Q[0]);
      end
     else
      begin
	  P := PDF/(ZABS + 1.E0/(ZABS + 2.E0/(ZABS + 3.E0/(ZABS + 4.E0/
              (ZABS + 0.65E0)))));
      end;
    //
    if (Z < 0.0)
     then q:= 1.0 - p
     else
      begin
       q:= p;
       p:= 1.0 - q;
      end;
   end;
end;


//*******************************************************
//appel de la fonction de Miller selon la valeur de Upper
//*******************************************************
function AS66ALNORM(Z: TYPE_FLOAT_NOMALITY_TEST; Upper: boolean): TYPE_FLOAT_NOMALITY_TEST;
var p,q, pdf: TYPE_FLOAT_NOMALITY_TEST;
begin
 //rcupration
 NORMP(Z,p,q,pdf);
 //renvoi des valeurs adquates -- pdf n'est pas utilis
 if Upper
  then result:= q
  else result:= p;
end;

//**********************************************//
//***************** PPND ***********************//
//**********************************************//
CONST
        PPND_A : array[0..7] of TYPE_FLOAT_NOMALITY_TEST =
        (3.3871328727963666080E0,
        1.3314166789178437745E+2,
        1.9715909503065514427E+3,
        1.3731693765509461125E+4,
        4.5921953931549871457E+4,
        6.7265770927008700853E+4,
        3.3430575583588128105E+4,
        2.5090809287301226727E+3);

        PPND_B : array[1..7] of TYPE_FLOAT_NOMALITY_TEST =
        (4.2313330701600911252E+1,
        6.8718700749205790830E+2,
        5.3941960214247511077E+3,
        2.1213794301586595867E+4,
        3.9307895800092710610E+4,
        2.8729085735721942674E+4,
        5.2264952788528545610E+3);

        PPND_C : array[0..7] of TYPE_FLOAT_NOMALITY_TEST =
        (1.42343711074968357734E0,
        4.63033784615654529590E0,
        5.76949722146069140550E0,
        3.64784832476320460504E0,
        1.27045825245236838258E0,
        2.41780725177450611770E-1,
        2.27238449892691845833E-2,
        7.74545014278341407640E-4);

        PPND_D : array[1..7] of TYPE_FLOAT_NOMALITY_TEST =
        (
        2.05319162663775882187E0,
        1.67638483018380384940E0,
        6.89767334985100004550E-1,
        1.48103976427480074590E-1,
        1.51986665636164571966E-2,
        5.47593808499534494600E-4,
        1.05075007164441684324E-9
        );

        PPND_E : array[0..7] of TYPE_FLOAT_NOMALITY_TEST =
        (
        6.65790464350110377720E0,
        5.46378491116411436990E0,
        1.78482653991729133580E0,
        2.96560571828504891230E-1,
        2.65321895265761230930E-2,
        1.24266094738807843860E-3,
        2.71155556874348757815E-5,
        2.01033439929228813265E-7
        );

        PPND_F : array[1..7] of TYPE_FLOAT_NOMALITY_TEST =
        (
        5.99832206555887937690E-1,
        1.36929880922735805310E-1,
        1.48753612908506148525E-2,
        7.86869131145613259100E-4,
        1.84631831751005468180E-5,
        1.42151175831644588870E-7,
        2.04426310338993978564E-15
        );

	PPND_ZERO : TYPE_FLOAT_NOMALITY_TEST = 0.E0;
        PPND_ONE : TYPE_FLOAT_NOMALITY_TEST = 1.E0;
        PPND_HALF : TYPE_FLOAT_NOMALITY_TEST = 0.5E0;
        PPND_SPLIT1 : TYPE_FLOAT_NOMALITY_TEST = 0.425E0;
        PPND_SPLIT2 : TYPE_FLOAT_NOMALITY_TEST = 5.E0;
        PPND_CONST1 : TYPE_FLOAT_NOMALITY_TEST = 0.180625E0;
        PPND_CONST2 : TYPE_FLOAT_NOMALITY_TEST = 1.6E0;

function AS241PPND16(p: TYPE_FLOAT_NOMALITY_TEST; var iFault: integer): TYPE_FLOAT_NOMALITY_TEST;
var q,r: TYPE_FLOAT_NOMALITY_TEST;
begin
  IFAULT := 0;
  Q := P - PPND_HALF;
  
  IF (ABS(Q) <= PPND_SPLIT1)
   THEN
   BEGIN
     R := PPND_CONST1 - Q * Q;
     RESULT := Q * (((((((PPND_A[7] * R + PPND_A[6]) * R + PPND_A[5]) * R + PPND_A[4]) * R + PPND_A[3])
               * R + PPND_A[2]) * R + PPND_A[1]) * R + PPND_A[0]) /
               (((((((PPND_B[7] * R + PPND_B[6]) * R + PPND_B[5]) * R + PPND_B[4]) * R + PPND_B[3])
               * R + PPND_B[2]) * R + PPND_B[1]) * R + PPND_ONE);
   END
  ELSE
   BEGIN

    IF (Q < PPND_ZERO) THEN
      R := P
    ELSE
      R := PPND_ONE - P;

    IF (R <= PPND_ZERO) THEN
     BEGIN
      IFAULT := 1;
      RESULT := PPND_ZERO;
      //
      EXIT;
     END;

    R := SQRT(-LN(R));//R := SQRT(-LOG(R));????
          
    IF (R <= PPND_SPLIT2) THEN
     BEGIN
      R := R - PPND_CONST2;
      RESULT := (((((((PPND_C[7] * R + PPND_C[6]) * R + PPND_C[5]) * R + PPND_C[4]) * R + PPND_C[3])
                * R + PPND_C[2]) * R + PPND_C[1]) * R + PPND_C[0]) /
                (((((((PPND_D[7] * R + PPND_D[6]) * R + PPND_D[5]) * R + PPND_D[4]) * R + PPND_D[3])
                * R + PPND_D[2]) * R + PPND_D[1]) * R + PPND_ONE);
     END
    ELSE
     BEGIN
      R := R - PPND_SPLIT2;
      RESULT := (((((((PPND_E[7] * R + PPND_E[6]) * R + PPND_E[5]) * R + PPND_E[4]) * R + PPND_E[3])
               * R + PPND_E[2]) * R + PPND_E[1]) * R + PPND_E[0]) /
               (((((((PPND_F[7] * R + PPND_F[6]) * R + PPND_F[5]) * R + PPND_F[4]) * R + PPND_F[3])
               * R + PPND_F[2]) * R + PPND_F[1]) * R + PPND_ONE);
     END;

    IF (Q < PPND_ZERO) THEN RESULT := - RESULT;

  END;
END;

//
//        Algorithm AS 181.2   Appl. Statist.  (1982) Vol. 31, No. 2
//
//        Calculates the algebraic polynomial of order nored-1 with
//        array of coefficients c.  Zero order coefficient is c(1)
//
//!\      attention, mme si mon tableau est un [1..xxx], ici il est quand mme pass en "zro based", c'est incroyable
function AS181POLY(const c: array of TYPE_FLOAT_NOMALITY_TEST; nord: integer; x: TYPE_FLOAT_NOMALITY_TEST): TYPE_FLOAT_NOMALITY_TEST;
Label 20;
var p: TYPE_FLOAT_NOMALITY_TEST;
    n2,j,i: integer;
begin
 RESULT:= c[pred(1)];
 if (nord > 1)
  then
   begin
    p:= x * c[pred(nord)];
    //
    if (nord = 2)
     then GOTO 20;
    //
    n2:= nord - 2;
    j:= n2+1;
    for i:= 1 to n2 do
     begin
      p:= (p + c[pred(j)]) * x;
      j:= j - 1;
     end;
    //
    20:
    RESULT:= RESULT + p; 
   end;
end;

//*****************************************************************************//
//      SUBROUTINE SWILK (INIT, X, N, N1, N2, A, W, PW, IFAULT)                //
//                                                                             //
//        ALGORITHM AS R94 APPL. STATIST. (1995) VOL.44, NO.4                  //
//                                                                             //
//        Calculates the Shapiro-Wilk W test and its significance level        //
//*****************************************************************************//

CONST
        //tableaux de coefs.
        C1 : array[1..6] of TYPE_FLOAT_NOMALITY_TEST = (0.0E0, 0.221157E0, -0.147981E0, -0.207119E1, 0.4434685E1, -0.2706056E1);
        C2 : array[1..6] of TYPE_FLOAT_NOMALITY_TEST = (0.0E0, 0.42981E-1, -0.293762E0, -0.1752461E1,0.5682633E1, -0.3582633E1);
        C3 : array[1..4] of TYPE_FLOAT_NOMALITY_TEST = (0.5440E0, -0.39978E0, 0.25054E-1, -0.6714E-3);
        C4 : array[1..4] of TYPE_FLOAT_NOMALITY_TEST = (0.13822E1, -0.77857E0, 0.62767E-1, -0.20322E-2);
        C5 : array[1..4] of TYPE_FLOAT_NOMALITY_TEST = (-0.15861E1, -0.31082E0, -0.83751E-1, 0.38915E-2);
        C6 : array[1..3] of TYPE_FLOAT_NOMALITY_TEST = (-0.4803E0, -0.82676E-1, 0.30302E-2);
        C7 : array[1..2] of TYPE_FLOAT_NOMALITY_TEST = (0.164E0, 0.533E0);
        C8 : array[1..2] of TYPE_FLOAT_NOMALITY_TEST = (0.1736E0, 0.315E0);
        C9 : array[1..2] of TYPE_FLOAT_NOMALITY_TEST = (0.256E0, -0.635E-2);
        G : array[1..2] of TYPE_FLOAT_NOMALITY_TEST = (-0.2273E1, 0.459E0);
        //constantes
        Z90 : TYPE_FLOAT_NOMALITY_TEST = 0.12816E1;
        Z95 : TYPE_FLOAT_NOMALITY_TEST = 0.16449E1;
        Z99 : TYPE_FLOAT_NOMALITY_TEST =  0.23263E1;
        ZM  : TYPE_FLOAT_NOMALITY_TEST = 0.17509E1;
        ZSS : TYPE_FLOAT_NOMALITY_TEST = 0.56268E0;
        BF1 : TYPE_FLOAT_NOMALITY_TEST = 0.8378E0;
        XX90 : TYPE_FLOAT_NOMALITY_TEST = 0.556E0;
        XX95 : TYPE_FLOAT_NOMALITY_TEST =  0.622E0;
        ZERO : TYPE_FLOAT_NOMALITY_TEST = 0.0E0;
        ONE : TYPE_FLOAT_NOMALITY_TEST = 1.0E0;
        TWO : TYPE_FLOAT_NOMALITY_TEST = 2.0E0;
        THREE : TYPE_FLOAT_NOMALITY_TEST = 3.0E0;
        SQRTH : TYPE_FLOAT_NOMALITY_TEST = 0.70711E0;
        QTR : TYPE_FLOAT_NOMALITY_TEST = 0.25E0;
        TH : TYPE_FLOAT_NOMALITY_TEST = 0.375E0;
        SMALL : TYPE_FLOAT_NOMALITY_TEST = 1E-19;
        PI6 : TYPE_FLOAT_NOMALITY_TEST = 0.1909859E1;
        STQR : TYPE_FLOAT_NOMALITY_TEST = 0.1047198E1;
        UPPER: boolean = TRUE;

//      SUBROUTINE SWILK (INIT, X, N, N1, N2, A, W, PW, IFAULT)
//
//        ALGORITHM AS R94 APPL. STATIST. (1995) VOL.44, NO.4
//
//        Calculates the Shapiro-Wilk W test and its significance level
//*********************************************************************
//*** interprtation R.R. -- 29/07/2005
//-> N1 = N2 = N
//-> INIT = FALSE
PROCEDURE SWILK(var X: array of TYPE_FLOAT_NOMALITY_TEST; N: integer; var W,PW: TYPE_FLOAT_NOMALITY_TEST; var IFAULT: integer);
Label 70;
LABEL FIN;
      
var SUMM2, SSUMM2, FAC, RSN, AN, AN25, A1, A2, DELTA, RANGE : TYPE_FLOAT_NOMALITY_TEST;
    SA, SX, SSX, SSA, SAX, ASA, XSX, SSASSX, W1, Y, XX, XI : TYPE_FLOAT_NOMALITY_TEST;
    GAMMA, M, S, LD, BF, Z90F, Z95F, Z99F, ZFM, ZSD, ZBAR: TYPE_FLOAT_NOMALITY_TEST;

    NCENS, NN2, I, I1, J: INTEGER;

    INIT: BOOLEAN;
    N2, N1: INTEGER;

    //
    A: array of TYPE_FLOAT_NOMALITY_TEST;
BEGIN
 //par dfaut chez moi
 INIT:= FALSE;
 //pas trs clair ces paramtres
 N1:= N;
 N2:= N div 2;

 //cration du tableau des A
 SETLENGTH(A,succ(N));

 //dbut normal
 PW  :=  ONE;
 //pourquoi ce test ? le W est  calculer justement
 //IF (W >= ZERO) THEN W := ONE;
 W:= ONE;
 //
 AN := 1.0*N;
 IFAULT := 3;
 NN2 := N div 2;
 IF (N2 < NN2) THEN GOTO FIN;
 IFAULT := 1;
 IF (N < 3) THEN GOTO FIN;
 //
 //If INIT is false, calculates coefficients for the test
 //
 IF NOT(INIT) THEN
 BEGIN
  IF (N = 3) THEN
        A[1] := SQRTH
     ELSE
      BEGIN
        AN25 := AN + QTR;
        SUMM2 := ZERO;
        
        for I:= 1 to N2 do
        begin
           A[I] := AS241PPND16((I - TH)/AN25, IFAULT);
           SUMM2 := SUMM2 + POWER(A[I],2.0);
        end;

        SUMM2 := SUMM2 * TWO;
        SSUMM2 := SQRT(SUMM2);
        RSN := ONE / SQRT(AN);
        A1 := AS181POLY(C1, 6, RSN) - A[1] / SSUMM2;
//
//      Normalize coefficients
//
        IF (N > 5) THEN
        BEGIN
           I1 := 3;
           A2 := -A[2]/SSUMM2 + AS181POLY(C2,6,RSN);
           //FAC = SQRT((SUMM2 - TWO * A(1) ** 2 - TWO * A(2) ** 2)/(ONE - TWO * A1 ** 2 - TWO * A2 ** 2))
           FAC := SQRT((SUMM2 - TWO * POWER(A[1],2.0) - TWO * POWER(A[2],2.0))
                        /(ONE - TWO * POWER(A1,2.0) - TWO * POWER(A2,2.0)));
           A[1] := A1;
           A[2] := A2;
        END
        ELSE
        BEGIN
           I1 := 2;
	   //FAC = SQRT((SUMM2 - TWO * A(1) ** 2)/(ONE - TWO * A1 ** 2))
           FAC := SQRT((SUMM2 - TWO * POWER(A[1],2.0))/(ONE - TWO * POWER(A1,2.0)));
           A[1] := A1;
        END;
        
        FOR I := I1 To NN2 Do
           A[I] := -A[I]/FAC;

      END;
      //INIT := TRUE;
 END;

 IF (N1 < 3) THEN GOTO FIN;
 NCENS := N - N1;
 IFAULT := 4;
 IF (NCENS < 0) OR ((NCENS > 0) AND (N < 20)) THEN GOTO FIN;
 IFAULT := 5;
 DELTA := 1.0*NCENS/AN;
 IF (DELTA > 0.8) THEN GOTO FIN;

//
// If W input as negative, calculate significance level of -W
//
 IF (W < ZERO) THEN
 BEGIN
  W1:= ONE + W;
  IFAULT := 0;
  GOTO 70;
 END;

//
// Check for zero range
//
 IFAULT := 6;
 RANGE := X[N1] - X[1];
 IF (RANGE < SMALL) THEN GOTO FIN;

//
// Check for correct sort order on range - scaled X
//
 IFAULT := 7;
 XX := X[1]/RANGE;
 SX := XX;
 SA := -A[1];
 J := N - 1;
 //DO 50 I = 2, N1
 for I:= 2 to N1 do
 BEGIN
  XI := X[I]/RANGE;
  
  IF (XX-XI > SMALL) THEN
   BEGIN
    TRACELOG.WriteToLogFile('[SWILKS] Problme dans le test de prcision (XX- XI > SMALL)');
    GOTO FIN;
   END;
   
  SX := SX + XI;
  IF (I <> J) THEN SA := SA + 1.0 * SIGN(I - J) * A[MIN(I, J)];
  XX := XI;
  J := J - 1;
 END;

 IFAULT := 0;
 IF (N > 5000) THEN IFAULT := 2;

//
// Calculate W statistic as squared correlation
// between data and coefficients
//

 SA := SA/N1;
 SX := SX/N1;
 SSA := ZERO;
 SSX := ZERO;
 SAX := ZERO;
 J := N;
 //DO 60 I = 1, N1
 FOR I:= 1 TO N1 DO
 BEGIN
   IF (I <> J) THEN
      ASA := SIGN(I - J) * A[MIN(I, J)] - SA
   ELSE
      ASA := -SA;

   XSX := X[I]/RANGE - SX;
   SSA := SSA + ASA * ASA;
   SSX := SSX + XSX * XSX;
   SAX := SAX + ASA * XSX;
   J := J - 1;
 END;

//
// W1 equals (1-W) claculated to avoid excessive rounding error
// for W very near 1 (a potential problem in very large samples)
//

 SSASSX := SQRT(SSA * SSX);
 W1 := (SSASSX - SAX) * (SSASSX + SAX)/(SSA * SSX);
 
 70: W := ONE - W1;

//
// Calculate significance level for W (exact for N=3)
//

 IF (N = 3) THEN
 BEGIN
  PW := PI6 * (ARCSIN(SQRT(W)) - STQR);
  GOTO FIN;
 END;
 
 Y := LN(W1);
 XX := LN(AN);
 
 //M := ZERO;
 //S := ONE;

 IF (N <= 11) THEN
  BEGIN
   GAMMA := AS181POLY(G, 2, AN);
   IF (Y >= GAMMA) THEN
      BEGIN
        PW := SMALL;
        GOTO FIN;
      END;
   Y := -LN(GAMMA - Y);
   M := AS181POLY(C3, 4, AN);
   S := EXP(AS181POLY(C4, 4, AN));
  END
  ELSE
  BEGIN
     M := AS181POLY(C5, 4, XX);
     S := EXP(AS181POLY(C6, 3, XX));
  END;


 IF (NCENS > 0) THEN
  BEGIN
   //Censoring by proportion NCENS/N.  Calculate mean and sd
   //of normal equivalent deviate of W.

   LD := -LN(DELTA);
   BF := ONE + XX * BF1;
   Z90F := Z90 + BF * POWER(AS181POLY(C7, 2, POWER(XX90,XX)),LD);
   Z95F := Z95 + BF * POWER(AS181POLY(C8, 2, POWER(XX95,XX)), LD);
   Z99F := Z99 + BF * POWER(AS181POLY(C9, 2, XX),LD);
   //
   //Regress Z90F,...,Z99F on normal deviates Z90,...,Z99 to get
   //pseudo-mean and pseudo-sd of z as the slope and intercept
   //
   ZFM := (Z90F + Z95F + Z99F)/THREE;
   ZSD := (Z90*(Z90F-ZFM)+Z95*(Z95F-ZFM)+Z99*(Z99F-ZFM))/ZSS;
   ZBAR := ZFM - ZSD * ZM;
   M := M + ZBAR * S;
   S := S * ZSD;

 END;

 //and last...
 PW := AS66ALNORM((Y - M)/S, UPPER);

FIN:
 //librer la mmoire avant de sortir
 FINALIZE(A);
END;

//**************************************************************************************************************
//******************* LILLIEFORS TEST  partir de KOLMOGOROV-SMIRNOV *******************************************
//**************************************************************************************************************

TYPE
        //id de proba pour le test de Lilliefors
        TENUM_KS_LILLIEFORS_ID_PROBA = (KSL_20,KSL_15,KSL_10,KSL_05,KSL_01);

CONST
        //table de Lilliefors, rcupr sur le site (4 =< n =< 20) -- http://courses.wcupa.edu/rbove/eco252/252suppkey.htm
        //(21 <= n <= 30) : ce sera calcul par interpolation  partir du mme tableau
        TABLE_LILLIEFORS_N_BETWEEN_4_20 : array[4..20,TENUM_KS_LILLIEFORS_ID_PROBA] of TYPE_FLOAT_NOMALITY_TEST =
        ((0.3,0.319,0.352,0.381,0.417),
        (0.285,0.299,0.315,0.337,0.405),
        (0.265,0.277,0.294,0.319,0.364),
        (0.247,0.258,0.276,0.3,0.348),
        (0.233,0.244,0.261,0.285,0.331),
        (0.223,0.233,0.249,0.271,0.311),
        (0.215,0.224,0.239,0.258,0.294),
        (0.206,0.217,0.23,0.249,0.284),
        (0.199,0.212,0.223,0.242,0.275),
        (0.19,0.202,0.214,0.234,0.268),
        (0.183,0.194,0.207,0.227,0.261),
        (0.177,0.187,0.201,0.22,0.257),
        (0.173,0.182,0.195,0.213,0.25),
        (0.169,0.177,0.189,0.206,0.245),
        (0.166,0.173,0.184,0.2,0.239),
        (0.163,0.169,0.179,0.195,0.235),
        (0.16,0.166,0.174,0.19,0.231));

        //pour n = 25
        SEUIL_PROBA_LILLIEFORS_N_25 : array[TENUM_KS_LILLIEFORS_ID_PROBA] of TYPE_FLOAT_NOMALITY_TEST = (0.149,0.153,0.165,0.18,0.203);

        //pour n = 30
        SEUIL_PROBA_LILLIEFORS_N_30 : array[TENUM_KS_LILLIEFORS_ID_PROBA] of TYPE_FLOAT_NOMALITY_TEST = (0.131,0.136,0.144,0.161,0.187);

        //tableau des valeurs seuils pour les proba de Lilliefors (n > 30)
        SEUIL_PROBA_LILLIEFORS_N_SUP_30 : array[TENUM_KS_LILLIEFORS_ID_PROBA] of TYPE_FLOAT_NOMALITY_TEST = (0.736, 0.768, 0.805, 0.886, 1.031);

//fonction de calcul du seuil de Lilliefors (cut-point)  partir de n
function cutOffLilliefors(n: integer; niveau: TENUM_KS_LILLIEFORS_ID_PROBA): TYPE_FLOAT_NOMALITY_TEST;
begin
 if (n < 4)
  //arbitrairement !
  then result:= 0.4
  else
   begin
    //n compris en 4 et 20
    if (n >= 4) and (n <= 20)
     then result:= TABLE_LILLIEFORS_N_BETWEEN_4_20[n,niveau]
     else
      begin
       if (n > 30)
        then result:= SEUIL_PROBA_LILLIEFORS_N_SUP_30[niveau] / SQRT(1.0 * n)
        else
         //on dtermine par interpolation pour 21 =< n =< 30
         begin
          case n of
           25: result:= SEUIL_PROBA_LILLIEFORS_N_25[niveau];
           30: result:= SEUIL_PROBA_LILLIEFORS_N_30[niveau]
           else
            begin
             //interpolation linaire pour 20 < n < 25
             if (n < 25)
              then result:= TABLE_LILLIEFORS_N_BETWEEN_4_20[20,niveau] + (1.0 * n - 20.0) * (SEUIL_PROBA_LILLIEFORS_N_25[niveau] - TABLE_LILLIEFORS_N_BETWEEN_4_20[20,niveau]) / (25.0 - 20.0)
              //ncessairement, on est dans l'intervalle 25 < n <30
              else result:= SEUIL_PROBA_LILLIEFORS_N_25[niveau] + (1.0 * n - 25.0) * (SEUIL_PROBA_LILLIEFORS_N_30[niveau] - SEUIL_PROBA_LILLIEFORS_N_25[niveau]) / (30.0 - 25.0);
            end
          end;
         end;
      end;
   end;
end;

//les donnes sont censes tre centres et rduites dj, ce n'est pas vrifi ici
PROCEDURE KSLILLIEFORS(var X: array of TYPE_FLOAT_NOMALITY_TEST; N: integer; var DMoins, DPlus, DKS: TYPE_FLOAT_NOMALITY_TEST; var idProba: TGRID_RESULTS_KS_LILLIEFORS);
var i: integer;
    D: TYPE_FLOAT_NOMALITY_TEST;
    thFreq: TYPE_FLOAT_NOMALITY_TEST;
    seuil: TYPE_FLOAT_NOMALITY_TEST;
    niveauProba: TENUM_KS_LILLIEFORS_ID_PROBA;
    ok: boolean;
BEGIN
 DPlus:= -1.0*MATH.MaxExtended;
 DMoins:= -1.0*MATH.MaxExtended;
 //construire la fonction de rpartition de la loi normale et comparer
 for i:= 1 to n do
  begin
   //frquence cumule thorique fournie par la loi de rpartition normale
   thFreq:= AS66ALNORM(X[i],FALSE);
   //calcul pratique en deux temps extrait de eq. 11.7, page 304 dans Avazian et al.
   //calculer l'cart D+
   D:= (1.0*i)/(1.0*n) - thFreq;
   DPlus:= MAX(DPlus,D);
   //calculer l'cart D-
   D:= thFreq - (-1.0+i)/(1.0*n);
   DMoins:= MAX(DMoins,D);
  end;
 //log.file.
 TraceLog.WriteToLogFile(format('[KS-LILLIEFORS] D+ = %.4f , D- = %.4f',[DPlus,DMoins]));
 //dduire la statistique de KS -- eq. 11.7, page 304 dans Avazian et al.
 DKS:= MAX(DPlus,DMoins);
 //dterminer le seuil
 idProba:= inf_KSL_01;
 ok:= false;
 for niveauProba:= high(TENUM_KS_LILLIEFORS_ID_PROBA) downto low(TENUM_KS_LILLIEFORS_ID_PROBA) do
  begin
   //dterminer la valeur du seuil -- cf. Avazian et al. page 309 Tableau 11.4 pour le principe
   seuil:= cutOffLilliefors(n,niveauProba);
   if (DKS > seuil)
    then
     begin
      ok:= true;
      BREAK;
     end;
   dec(idProba);
  end;
 //si on n'a pas trouv
 if not(ok) then idProba:= sup_KSL_20; 
END;

//**************************************************************
//http://www.mathworks.com/matlabcentral/files/3954/DagosPtest.m
//**************************************************************
(*
x = c(:,1);
f = c(:,2);
s1 = f'*x;
s2 = f'*x.^2;
s3 = f'*x.^3;
s4 = f'*x.^4;
SS = s2-(s1^2/n);
v = SS/(n-1);
k3 = ((n*s3)-(3*s1*s2)+((2*(s1^3))/n))/((n-1)*(n-2));
g1 = k3/sqrt(v^3);
k4 = ((n+1)*((n*s4)-(4*s1*s3)+(6*(s1^2)*(s2/n))-((3*(s1^4))/(n^2)))/((n-1)*(n-2)*(n-3)))-((3*(SS^2))/((n-2)*(n-3)));
g2 = k4/v^2;
eg1 = ((n-2)*g1)/sqrt(n*(n-1));  %measure of skewness
eg2 = ((n-2)*(n-3)*g2)/((n+1)*(n-1))+((3*(n-1))/(n+1));  %measure of kurtosis

A = eg1*sqrt(((n+1)*(n+3))/(6*(n-2)));
B = (3*((n^2)+(27*n)-70)*((n+1)*(n+3)))/((n-2)*(n+5)*(n+7)*(n+9));
C = sqrt(2*(B-1))-1;
D = sqrt(C);
E = 1/sqrt(log(D));
F = A/sqrt(2/(C-1));
Zg1 = E*log(F+sqrt(F^2+1));

G = (24*n*(n-2)*(n-3))/((n+1)^2*(n+3)*(n+5));
H = ((n-2)*(n-3)*abs(g2))/((n+1)*(n-1)*sqrt(G));
J = ((6*(n^2-(5*n)+2))/((n+7)*(n+9)))*sqrt((6*(n+3)*(n+5))/((n*(n-2)*(n-3))));
K = 6+((8/J)*((2/J)+sqrt(1+(4/J^2))));
L = (1-(2/K))/(1+H*sqrt(2/(K-4)));
Zg2 = (1-(2/(9*K))-L^(1/3))/sqrt(2/(9*K));

K2 = Zg1^2 + Zg2^2;  %D'Agostino-Pearson statistic
X2 = K2;  %approximation to chi-distribution
df = 2;  %degrees of freedom
*)

PROCEDURE D_AGOSTINO(var X: array of TYPE_FLOAT_NOMALITY_TEST; integerN: integer; var zG1, zG2, K2, pK2: TYPE_FLOAT_NOMALITY_TEST);
var id: integer;
    value: TYPE_FLOAT_NOMALITY_TEST;
    s1,s2,s3,s4: TYPE_FLOAT_NOMALITY_TEST;
    n,SS,v,k3,g1,k4,g2,eg1,eg2: TYPE_FLOAT_NOMALITY_TEST;
    A,B,C,D,E,F: TYPE_FLOAT_NOMALITY_TEST;
    G,H,I,J,K,L: TYPE_FLOAT_NOMALITY_TEST;
begin
 //rcuprer le n dans un format plus sympathique
 n:= 1.0 * integerN;
 //calculs
 s1:= 0.0;
 s2:= 0.0;
 s3:= 0.0;
 s4:= 0.0;
 for id:= 1 to integerN do
  begin
   value:= X[id];
   s1:= s1 + value;
   s2:= s2 + value * value;
   s3:= s3 + value * value * value;
   s4:= s4 + value * value * value * value;
  end;
 //calcul du Skewness
 SS:= s2-(power(s1,2.0)/n);
 v:= SS/(n-1);
 k3:= ((n*s3)-(3*s1*s2)+((2*(power(s1,3)))/n))/((n-1)*(n-2));
 g1:= k3/sqrt(power(v,3));//skewness  la sauce Fisher gamma_1 -- celui de STATISTICA et EXCEL
 eg1:= ((n-2)*g1)/sqrt(n*(n-1));  //measure of skewness -- racine carre de beta_1 -- Skewness  la sauce Pearson
 //calcul de zG1
 A:= eg1*sqrt(((n+1)*(n+3))/(6*(n-2)));
 B:= (3.0*((power(n,2))+(27.0*n)-70.0)*((n+1)*(n+3)))/((n-2)*(n+5)*(n+7)*(n+9));
 C:= sqrt(2.0*(B-1))-1.0;
 D:= sqrt(C);
 E:= 1.0/sqrt(ln(D));
 F:= A/sqrt(2.0/(C-1));
 zG1:= E*ln(F+sqrt(power(F,2)+1));
 //calcul du Kurtosis
 k4:= ((n+1)*((n*s4)-(4*s1*s3)+(6*(power(s1,2))*(s2/n))-((3*(power(s1,4)))/(power(n,2))))/((n-1)*(n-2)*(n-3)))-((3*(power(SS,2)))/((n-2)*(n-3)));
 g2:= k4/power(v,2); //Kurtosis -- celui de STATISTICA et EXCEL
 eg2:= ((n-2)*(n-3)*g2)/((n+1)*(n-1))+((3*(n-1))/(n+1));  //measure of kurtosis -- l'autre (qui ne sert pas dans les calculs par la suite)
 G:= (24.0*n*(n-2)*(n-3))/(power((n+1),2)*(n+3)*(n+5));
 H:= ((n-2)*(n-3)*abs(g2))/((n+1)*(n-1)*sqrt(G));
 J:= ((6.0*(power(n,2)-(5*n)+2))/((n+7)*(n+9)))*sqrt((6*(n+3)*(n+5))/((n*(n-2)*(n-3))));
 K:= 6.0+((8/J)*((2/J)+sqrt(1+(4/power(J,2)))));
 L:= (1.0-(2.0/K))/(1.0+H*sqrt(2.0/(K-4)));
 zG2:= (1.0-(2.0/(9*K))-power(L,(1.0/3.0)))/sqrt(2.0/(9.0*K));
 //calcul de la stat
 K2:= zG1 * zG1 + zG2 * zG2;
 //la p-value
 pK2:= PKhi2(2,K2);
 //petit contrle
 TraceLog.WriteToLogFile(format('[d''AGOSTINO -- Fisher(Pearson)] skewness = %.6f (%.6f) , kurtosis = %.6f (%.6f) ::: K2 = %.6f',[g1,eg1,g2,eg2,K2]));
end;

//**************************************************************************************************************
//*************************** TEST DE NORMALITE d'ANDERSON-DARLING *********************************************
//**************************************************************************************************************

TYPE
        //id de proba pour le test de Lilliefors
        TENUM_ANDERSON_DARLING_ID_PROBA = (AD_10,AD_05,AD_025,AD_01);

CONST
        //tableau des seuils pour Anderson-Darling -- cf.http://www.statisticalengineering.com/goodness.htm
        TABLE_ANDERSON_DARLING : array[TENUM_ANDERSON_DARLING_ID_PROBA] of TYPE_FLOAT_NOMALITY_TEST
                                 = (0.631, 0.752, 0.873, 1.035);

PROCEDURE KS_ANDERSON_DARLING(var X: array of TYPE_FLOAT_NOMALITY_TEST; integerN: integer; var A2: TYPE_FLOAT_NOMALITY_TEST; var idProba: TGRID_RESULTS_KS_ANDERSON_DARLING);
var n: TYPE_FLOAT_NOMALITY_TEST;
    i: integer;
    ok: boolean;
    seuil: TENUM_ANDERSON_DARLING_ID_PROBA;
    v1,v2: TYPE_FLOAT_NOMALITY_TEST; 
begin
 //init.
 n:= 1.0*integerN;
 //calculs de A2
 A2:= 0.0;
 for i:= 1 to integerN do
  begin
   v1:= AS66ALNORM(X[i],FALSE);
   v2:= AS66ALNORM(X[integerN - i + 1],FALSE);
   if (v1 > 0.0) and (v2 < 1.0)
    then A2:= A2 + (2.0 * i - 1.0) * (LN(v1) + LN(1.0 - v2))
    //ne faudrait-il pas rduire n dans le ELSE ??? doute, doute...a parat logique de le faire !
    else n:= n - 1.0;
  end;
 A2:= - n - (1.0 / n) * A2;
 //trouver le palier de proba
 ok:= false;
 for seuil:= low(TENUM_ANDERSON_DARLING_ID_PROBA) to high(TENUM_ANDERSON_DARLING_ID_PROBA) do
  begin
   if (A2 < TABLE_ANDERSON_DARLING[seuil])
    then
     begin
      ok:= true;
      BREAK;
     end;
  end;
 //affecter la valeur de la grille
 if ok
  then idProba:= TGRID_RESULTS_KS_ANDERSON_DARLING(ord(seuil))
  else idProba:= inf_AD_01;  
end;

END.


