(******************************************************************************)
(* UCalcMatrixAdditionalFunctions.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(******************************************************************************)

{
@abstract(Ajout de nouvelles fonctions dans la bibliothque de matrice de J. Debord)
@author(Ricco)
@created(12/01/2004)
L'ide est de rajouter qqs fonctions issues de Numerical Recipes, notamment tout ce qui touche
 la recherche de vecteurs et valeurs propres.
}
unit UCalcMatrixAdditionalFunctions;

interface

USES
        FMath, Matrices;

{la procdure qui encapsule le tout, la matrice M doit tre symtrique,
EVal et EVec sont cres dans la procdure}
procedure GetEigensFromSymetricMatrix(M: PMatrix; n: integer; var EVal: PVector; var EVec: PMatrix);

implementation

uses
        SysUtils;

{rduire une matrice symtrique (!!!) en une forme tri-diagonale, prparation de la recherche de valeurs propres:
-> A est matrice originelle qui est manipule et devient la matrice orthogonale Q,
-> n est la dimension de la matrice A,
-> D renvoie les lments diagonaux de la matrice tri-diagonale,
-> E reprsente les lments non-diagonaux}        
procedure TRED2(var A: PMatrix; n: integer; var D,E: PVector);

VAR
   l,k,j,i: integer;
   scale,hh,h,g,f: float;

   FUNCTION sign(a,b: float): float;
   BEGIN
      IF (b < 0) THEN sign := -abs(a) ELSE sign := abs(a)
   END;

BEGIN
   IF (n > 1) THEN BEGIN
      FOR i := n DOWNTO 2 DO BEGIN
         l := i-1;
         h := 0.0;
         scale := 0.0;
         IF (l > 1) THEN BEGIN
            FOR k := 1 TO l DO BEGIN
               scale := scale+abs(a^[i]^[k])
            END;
            IF (scale = 0.0) THEN BEGIN
               e^[i] := a^[i]^[l]
            END ELSE BEGIN
               FOR k := 1 TO l DO BEGIN
                  a^[i]^[k] := a^[i]^[k]/scale;
                  h := h+sqr(a^[i]^[k])
               END;
               f := a^[i]^[l];
               g := -sign(sqrt(h),f);
               e^[i] := scale*g;
               h := h-f*g;
               a^[i]^[l] := f-g;
               f := 0.0;
               FOR j := 1 TO l DO BEGIN
            (* Next statement can be omitted if eigenvectors not wanted *)
                  a^[j]^[i] := a^[i]^[j]/h;
                  g := 0.0;
                  FOR k := 1 TO j DO BEGIN
                     g := g+a^[j]^[k]*a^[i]^[k]
                  END;
                  IF (l > j) THEN FOR k := j+1 TO l DO g := g+a^[k]^[j]*a^[i]^[k];
                  e^[j] := g/h;
                  f := f+e^[j]*a^[i]^[j]
               END;
               hh := f/(h+h);
               FOR j := 1 TO l DO BEGIN
                  f := a^[i]^[j];
                  g := e^[j]-hh*f;
                  e^[j] := g;
                  FOR k := 1 TO j DO a^[j]^[k] := a^[j]^[k]-f*e^[k]-g*a^[i]^[k]
               END
            END
         END ELSE BEGIN
            e^[i] := a^[i]^[l]
         END;
         d^[i] := h
      END
   END;
   (* Next statement can be omitted if eigenvectors not wanted *)
   d^[1] := 0.0;
   e^[1] := 0.0;
   FOR i := 1 TO n DO BEGIN
   (* Contents of this loop can be omitted if eigenvectors not wanted,
      except for statement d[i] := a[i,i]; *)
      l := i-1;
      IF (d^[i] <> 0.0) THEN BEGIN
         FOR j := 1 TO l DO BEGIN
            g := 0.0;
            FOR k := 1 TO l DO BEGIN
               g := g+a^[i]^[k]*a^[k]^[j]
            END;
            FOR k := 1 TO l DO BEGIN
               a^[k]^[j] := a^[k]^[j]-g*a^[k]^[i]
            END
         END
      END;
      d^[i] := a^[i]^[i];
      a^[i]^[i] := 1.0;
      IF (l >= 1) THEN BEGIN
         FOR j := 1 TO l DO BEGIN
            a^[i]^[j] := 0.0;
            a^[j]^[i] := 0.0
         END
      END
   END
END;


{calcule les valeurs et vecteurs propres d'une matrice tri-diagonale, c'est le complment idal des deux procdures ci-dessus:
-> D est le vecteur renvoy par TRED2, il est transform et contient en sortie les valeurs propres,
-> E est un vecteur renvoy par TRED2, il ne veut plus rien dire en sortie
-> n est la dimension de la matrice,
-> Z est la matrice orthogonale A renvoye par TRED2, il contient en sortie les vecteurs propres dans l'ordre des valeurs propres}
PROCEDURE TQLI(VAR D,E: PVector; n: integer; VAR Z: PMatrix);
LABEL 1,2;
VAR
   m,l,iter,i,k: integer;
   s,r,p,g,f,dd,c,b: float;

   FUNCTION sign(a,b: float): float;
   BEGIN
      IF (b < 0) THEN sign := -abs(a) ELSE sign := abs(a)
   END;
   
BEGIN
   IF  (n > 1)  THEN BEGIN
      FOR i := 2 TO n DO BEGIN
         e^[i-1] := e^[i]
      END;
      e^[n] := 0.0;
      FOR l := 1 TO n DO BEGIN
         iter := 0;
1:         FOR m := l TO n-1 DO BEGIN
            dd := abs(d^[m])+abs(d^[m+1]);
            IF  (abs(e^[m])+dd = dd) THEN  GOTO 2
         END;
         m := n;
2:         IF (m <> l) THEN BEGIN
            IF (iter = 30) THEN BEGIN
               //writeln('pause in routine TQLI');
               //writeln('too many iterations'); readln
               raise Exception.Create('TQLI --> Too many iterations');
            END;
            iter := iter+1;
            g := (d^[l+1]-d^[l])/(2.0*e^[l]);
            r := sqrt(sqr(g)+1.0);
            g := d^[m]-d^[l]+e^[l]/(g+sign(r,g));
            s := 1.0;
            c := 1.0;
            p := 0.0;
            FOR i := m-1 DOWNTO l DO BEGIN
               f := s*e^[i];
               b := c*e^[i];
               IF (abs(f) >= abs(g)) THEN BEGIN
                  c := g/f;
                  r := sqrt(sqr(c)+1.0);
                  e^[i+1] := f*r;
                  s := 1.0/r;
                  c := c*s
               END ELSE BEGIN
                  s := f/g;
                  r := sqrt(sqr(s)+1.0);
                  e^[i+1] := g*r;
                  c := 1.0/r;
                  s := s*c
               END;
               g := d^[i+1]-p;
               r := (d^[i]-g)*s+2.0*c*b;
               p := s*r;
               d^[i+1] := g+p;
               g := c*r-b;
            (* Next loop can be omitted if eigenvectors not wanted *)
               FOR k := 1 TO n DO BEGIN
                  f := z^[k]^[i+1];
                  z^[k]^[i+1] := s*z^[k]^[i]+c*f;
                  z^[k]^[i] := c*z^[k]^[i]-s*f
               END
            END;
            d^[l] := d^[l]-p;
            e^[l] := g;
            e^[m] := 0.0;
            GOTO 1
         END
      END
   END
END;

{trier la matrice de vecteurs propres selon les valeurs dcroissantes des valeurs propres}
PROCEDURE EIGSRT(VAR D: PVector; VAR V: PMatrix; n: integer);
VAR
   k,j,i: integer;
   p: float;
BEGIN
   FOR i := 1 TO n-1 DO BEGIN
      k := i;
      p := d^[i];
      FOR j := i+1 TO n DO BEGIN
         IF (d^[j] >= p) THEN BEGIN
            k := j;
            p := d^[j]
         END
      END;
      IF (k <> i) THEN BEGIN
         d^[k] := d^[i];
         d^[i] := p;
         FOR j := 1 TO n DO BEGIN
            p := v^[j]^[i];
            v^[j]^[i] := v^[j]^[k];
            v^[j]^[k] := p
         END
      END
   END
END;

{multiplication par un scalaire d'une matrice symtrique}
procedure SCALARMULT(scal: float; var M: PMatrix; n: integer);
var i,j: integer;
begin
 for i:= 1 to n do
  for j:= 1 to n do
   M^[i]^[j]:= scal*M^[i]^[j];
end;

{construire le tout}
procedure GetEigensFromSymetricMatrix(M: PMatrix; n: integer; var EVal: PVector; var EVec: PMatrix);
var A: PMatrix;
    D,E: PVector;
begin
 //allocations et copie
 DimMatrix(A,n,n);
 CopyMatrix(A,M,1,1,n,n);
 DimVector(D,n);
 DimVector(E,n);
 //first step
 TRED2(A,n,D,E);
 //second step
 TQLI(D,E,n,A);
 //destructions
 DelVector(E,n);
 //trier les rsultats selon les valeurs dcroissantes des Val. Propres
 EIGSRT(D,A,n);
 //multiplier toutes les valeurs des vecteurs propres par (-1)
 //je ne sais pas pourquoi la mthode ici oblige  cette correction
 SCALARMULT(-1.0,A,n);
 //restitutions
 EVal:= D;
 EVec:= A;
end;

end.
