(*************************************************************)
(* UCalcCrossTab.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*************************************************************)

{
@abstract(Tableaux croiss  la nouvelle sauce, extension du vecteur de distribution)
@author(Ricco)
@created(12/01/2004)
}
unit UCalcCrossTab;

interface

USES
        Classes,
        UCalcDistribution,
        UDatasetDefinition,
        UDatasetExamples;

TYPE
        {Tableau de vecteurs}
        TTabCrossTab = array[0..MAX_NB_VALUES_CATEGORICAL] of PTabFreqStruc;

        {pointeur sur la structure complte}
        PTabCrossTab = ^TTabCrossTab;

CONST
        {taille du pointeur de taille de vecteur, donc 4}
        SIZE_PTR_TAB_FREQ_STRUC = sizeof(PTabFreqStruc);

TYPE

        {profil de visualisation du tableau de contigence}
        TEnumViewCrossTab = (vctAbsolute,vctRow,vctCol,vctFull);

        {tableau de contingence, les lignes et colonnes 0 sont les marges}
        TCrossTab = class(TObject)
                    private
                    {structure interne}
                    FTab: PTabCrossTab;
                    {dimensions}
                    FRowCount, FColCount: integer;
                    {attributs}
                    FRowAtt,FColAtt: TAttribute;
                    {initialiser la structure}
                    procedure   AllocStructure(prmRC,prmCC: integer);
                    {dsallouer la structure}
                    procedure   FreeStructure();
                    {accs au tableau}
                    function    GetValue(i,j: integer): TFreqCountType;
                    {mettre des valeurs dans le tableau}
                    procedure   SetValue(i,j: integer; prmValue: TFreqCountType);
                    {lecture sur les profils lignes}
                    function    GetRowFreq(i,j: integer): double;
                    {lecture sur les profils colonnes}
                    function    GetColFreq(i,j: integer): double;
                    {lecture de la frquence totale}
                    function    GetFullFreq(i,j: integer): double;
                    public
                    {construire et brancher sur les attributs}
                    constructor create(prmRA,prmCA: TAttribute);
                    {connecter d'autres attributs -- new -- 14/02/2005}
                    function    connectNewAttributes(attRow,attColumn: TAttribute): boolean;
                    {destructor}
                    destructor  destroy; override;
                    {vider le tableau}
                    procedure   ReInitialization();
                    {ajouter une valeur}
                    procedure   AddValue(example: integer);
                    {rafrachir  partir d'une srie d'exemples}
                    procedure   Refresh(prmExamples: TExamples);
                    {obtenir une description HTML du tableau crois}
                    function    getHTMLResult(prmOption: integer; prmCaption: string): string;
                    {calculer l'information mutuelle}
                    function    MutualInformation(): double;
                    {nombre de lignes}
                    property    RowCount: integer read FRowCount;
                    {nombre de colonnes}
                    property    ColCount: integer read FColCount;
                    {accs  la cellule i,j}
                    property    Value[i,j: integer]: TFreqCountType read GetValue write setValue;
                    {profil ligne}
                    property    RowFreq[i,j: integer]: double read GetRowFreq;
                    {profil colonne}
                    property    ColFreq[i,j: integer]: double read GetColFreq;
                    {full profil}
                    property    FullFreq[i,j: integer]: double read GetFullFreq;
                    end;


implementation

uses
        Math,
        SysUtils, UConstConfiguration;

{ TCrossTab }

procedure TCrossTab.AddValue(example: integer);
var i,j: TTypeDiscrete;
begin
 i:= FRowAtt.dValue[example];
 j:= FColAtt.dValue[example];
 inc(FTab^[i]^[j]);
 //ne pas oublier les marges
 inc(FTab^[i]^[0]);
 inc(FTab^[0]^[j]);
 inc(FTab^[0]^[0]);
end;

procedure TCrossTab.AllocStructure(prmRC, prmCC: integer);
var i: integer;
begin
 FRowCount:= prmRC;
 FColCount:= prmCC;
 FTab:= AllocMem(succ(FRowCount)*SIZE_PTR_TAB_FREQ_STRUC);
 for i:= 0 to FRowCount do
  FTab^[i]:= AllocMem(succ(FColCount)*SIZE_FREQ_COUNT_TYPE);
 self.ReInitialization();
end;

function TCrossTab.connectNewAttributes(attRow,
  attColumn: TAttribute): boolean;
begin
 if (attRow.nbValues=self.RowCount) and (attColumn.nbValues=self.ColCount)
  then
   begin
    FRowAtt:= attRow;
    FColAtt:= attColumn;
    result:= TRUE;
   end
  else result:= FALSE;
end;

constructor TCrossTab.create(prmRA, prmCA: TAttribute);
begin
 inherited Create();
 FRowAtt:= prmRA;
 FColAtt:= prmCA;
 self.AllocStructure(prmRA.nbValues,prmCA.nbValues);
end;

destructor TCrossTab.destroy;
begin
 self.FreeStructure();
 inherited;
end;

procedure TCrossTab.FreeStructure;
var i: integer;
begin
 //***********************************************
 //big erreur ??? --- dcouverte le 14/05/2004 ???
 //>>> for i:= 0 to FColCount do <<<
 //***********************************************
 //le bon code...
 //***********************************************
 for i:= 0 to FRowCount do
  ReAllocMem(FTab^[i],0);
 ReAllocMem(FTab,0);
end;

function TCrossTab.GetColFreq(i, j: integer): double;
begin
 if (self.Value[0,j]>0)
  then result:= 1.0*self.Value[i,j]/(1.0*self.Value[0,j])
  else result:= 0.0;
end;

function TCrossTab.GetFullFreq(i, j: integer): double;
begin
 if (self.Value[0,0]>0)
  then result:= 1.0*self.Value[i,j]/(1.0*self.Value[0,0])
  else result:= 0.0;
end;

function TCrossTab.getHTMLResult(prmOption: integer; prmCaption: string): string;
var i,j: integer;
    s: string;
begin
 s:= '<P>'+HTML_HEADER_TABLE_RESULT;
 if (prmCaption<>'')
  then s:= s+format('<caption><B>%s</B></caption>',[prmCaption]);
 s:= s+HTML_TABLE_COLOR_HEADER_BLUE+'<TH></TH>';
 //la liste des modalits sur la premire ligne
 for j:= 1 to FColAtt.nbValues do
  s:= s +'<TH width=60>'+FColAtt.LstValues.getDescription(j)+'</TH>';
 //et la marge pour finir
 s:= s+format('<TH width=60 %s>Sum</TH></TR>',[HTML_BGCOLOR_HEADER_GREEN]);
 //pour chaque ligne du tableau
 for i:= 1 to FRowAtt.nbValues do
  begin
   s:= s+format('<TR><TH %s>%s</TH>',[HTML_BGCOLOR_HEADER_BLUE,FRowAtt.LstValues.getDescription(i)]);
   case prmOption of
   1: //profil ligne
    begin
     for j:= 1 to FColAtt.nbValues do
      s:= s+format('<TD %s align=right>%.4f</TD>',[HTML_BGCOLOR_DATA_BLUE,self.RowFreq[i,j]]);
     //la marge
     s:= s+format('<TD %s align=right>%.4f</TD></TR>',[HTML_BGCOLOR_DATA_GREEN,self.RowFreq[i,0]]);
    end;
   2: //profil colonne
    begin
     for j:= 1 to FColAtt.nbValues do
      s:= s+format('<TD %s align=right>%.4f</TD>',[HTML_BGCOLOR_DATA_BLUE,self.ColFreq[i,j]]);
     //la marge
     s:= s+format('<TD %s align=right>%.4f</TD></TR>',[HTML_BGCOLOR_DATA_GREEN,self.ColFreq[i,0]]);
    end;
   3: //proportions totales
    begin
     for j:= 1 to FColAtt.nbValues do
      s:= s+format('<TD %s align=right>%.4f</TD>',[HTML_BGCOLOR_DATA_BLUE,self.FullFreq[i,j]]);
     //la marge
     s:= s+format('<TD %s align=right>%.4f</TD></TR>',[HTML_BGCOLOR_DATA_GREEN,self.FullFreq[i,0]]);
    end
   else
    //les valeurs absolues
    begin
     for j:= 1 to FColAtt.nbValues do
      s:= s+format('<TD %s align=right>%d</TD>',[HTML_BGCOLOR_DATA_BLUE,self.Value[i,j]]);
     //la marge
     s:= s+format('<TD %s align=right>%d</TD></TR>',[HTML_BGCOLOR_DATA_GREEN,self.Value[i,0]]);
    end;
   end;
  end;
 //la dernire ligne, la somme en colonne
 s:= s+format('<TR><TH %s>Sum</TH>',[HTML_BGCOLOR_HEADER_GREEN]);
 case prmOption of
  1: //profil ligne
   begin
     //la dernire ligne, la somme en colonne
     for j:= 1 to FColAtt.nbValues do
      s:= s+format('<TD %s align=right>%.4f</TD>',[HTML_BGCOLOR_DATA_GREEN,self.RowFreq[0,j]]);
     //la marge totale
     s:= s+format('<TD %s align=right>%.4f</TD></TR>',[HTML_BGCOLOR_DATA_GREEN,self.RowFreq[0,0]]);
   end;
  2: //profil colonne
   begin
     //la dernire ligne, la somme en colonne
     for j:= 1 to FColAtt.nbValues do
      s:= s+format('<TD %s align=right>%.4f</TD>',[HTML_BGCOLOR_DATA_GREEN,self.ColFreq[0,j]]);
     //la marge totale
     s:= s+format('<TD %s align=right>%.4f</TD></TR>',[HTML_BGCOLOR_DATA_GREEN,self.ColFreq[0,0]]);
   end;
  3: //proportions totales
   begin
     //la dernire ligne, la somme en colonne
     for j:= 1 to FColAtt.nbValues do
      s:= s+format('<TD %s align=right>%.4f</TD>',[HTML_BGCOLOR_DATA_GREEN,self.FullFreq[0,j]]);
     //la marge totale
     s:= s+format('<TD %s align=right>%.4f</TD></TR>',[HTML_BGCOLOR_DATA_GREEN,self.FullFreq[0,0]]);
   end;
 else
  begin
   for j:= 1 to FColAtt.nbValues do
    s:= s+format('<TD %s align=right>%d</TD>',[HTML_BGCOLOR_DATA_GREEN,self.Value[0,j]]);
   //la marge totale
   s:= s+format('<TD %s align=right>%d</TD></TR>',[HTML_BGCOLOR_DATA_GREEN,self.Value[0,0]]);
  end;
 end;
 s:= s+'</table>';
 result:= s;
end;

function TCrossTab.GetRowFreq(i, j: integer): double;
begin
 if (self.Value[i,0]>0)
  then result:= 1.0*self.Value[i,j]/(1.0*self.Value[i,0])
  else result:= 0.0;
end;

function TCrossTab.GetValue(i, j: integer): TFreqCountType;
begin
 result:= FTab^[i]^[j];
end;

function TCrossTab.MutualInformation: double;
Var i,j: Integer;
    ICT,Value: Double;
Begin
 //test sur les tailles du tableau
 If (self.RowCount<2) AND (self.ColCount<2)
  Then
   Begin
    RESULT:= 0;
    EXIT;
   End;
 //calcul du numrateur
 ICT:= 0;
 For i:= 1 To RowCount Do
  For j:= 1 To ColCount Do
   Begin
     If (FTab^[0]^[0]>0)
      Then
       Begin
        Value:= FTab^[i]^[j]/FTab^[0]^[0];
        If (Value>0) and (FTab^[i]^[0]>0) and (FTab^[0]^[j]>0)
         Then ICT:= ICT+Value*log2((FTab^[i]^[0]/FTab^[0]^[0])*(FTab^[0]^[j]/FTab^[0]^[0])/value);
       End;
   End;
 RESULT:= -1.0*ICT;
END;

procedure TCrossTab.Refresh(prmExamples: TExamples);
var i: integer;
begin
 self.ReInitialization();
 for i:= 1 to prmExamples.Size do
  self.AddValue(prmExamples.Number[i]);
end;

procedure TCrossTab.ReInitialization;
var i,j: integer;
begin
 for i:= 0 to FRowCount do
  for j:= 0 to FColCount do
   FTab^[i]^[j]:= 0;
end;

procedure TCrossTab.SetValue(i, j: integer; prmValue: TFreqCountType);
begin
 FTab^[i]^[j]:= prmValue;
end;

end.
