(***************************************************************************)
(* UCalcDistributionEvaluation.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(***************************************************************************)

{
@abstract(Fonctions pour valuer des distributions)
@author(Ricco)
@created(21/04/2005)

Le tout est de standardiser au possible la prsentation afin de maximiser
la rutilisabilit sans rentrer dans des trucs trop complexes ou contraignants...

}

unit UCalcDistributionEvaluation;

interface

USES
   UCalcDistribution,
   UDatasetDefinition;

TYPE
   //type abstrait de paramtrage des fonctions d'valuation
   TPrmFuncDistEval = class
                      end;

   //type de fonction d'valuation d'une distribution -- avec ventuellement des paramtres
   TFuncEvalDistribution = function (Root,Current: TTabFrequence; parameters: TPrmFuncDistEval): double;

   //type de fonction pour valuer une rgle,  laquelle on a attribu une conclusion donc
   TFuncEvalRule = function(Root,Current: TTabFrequence; idConculsion: TTypeDiscrete; parameters: TPrmFuncDistEval): double; 

   //*************************************************************
   //* mesures de qualit, fonctions de type TFuncEvalDistribution
   //*************************************************************

   //Shannon -- entropie d'un noeud courant
   Function Shannon(Root,Current: TTabFrequence; parameters: TPrmFuncDistEval): double;
   //J-Measure -- comparaison de la racine et du noeud courant
   Function JMeasure(Root,Current: TTabFrequence; parameters: TPrmFuncDistEval): double;
   //calcule en p-value la diffrence entre 2 profils de distributions -- pour CN2 (rf. Kalbfleish -- 1979)
   Function CompareDistribCHI2(Root,Current: TTabFrequence; parameters: TPrmFuncDistEval): double;

implementation

uses
   Math, FMATH;

//Shannon -- entropie d'un noeud courant
Function Shannon(Root,Current: TTabFrequence; parameters: TPrmFuncDistEval): double;
var i: integer;
    value: double;
    sum: double;
begin
 sum:= 0.0;
 if (Current.Value[0]>0)
  then
   begin
    for i:= 1 to Current.Size do
     begin
      value:= Current.Frequence[i];
      if (value>0)
       then sum:= sum+value*Math.log2(value);
     end;
   end;
 result:= -1.0*sum;
end;

//J-Measure -- comparaison de la racine et du noeud courant
Function JMeasure(Root,Current: TTabFrequence; parameters: TPrmFuncDistEval): double;
Var Somme: Double;
    Rc,Rr: Double;
    i: Integer;
Begin
 If (Root.Value[0]>0)
  then
   begin
     Somme:= 0;
     For i:= 1 To Current.Size Do
      If (Current.Value[0]>0)
       Then
        Begin
         Rc:= Current.Frequence[i];
         Rr:= Root.Frequence[i];
         Somme:= Somme+Rc*Math.log2(Rc/Rr);
        End;
     //ngatif parce qu'on part dans la minimisation
     result:= -1.0*(Current.Value[0]/Root.Value[0])*Somme;
   end
  //aucun calcul  faire...
  else result:= 0.0;
End;

//calcule en p-value la diffrence entre 2 profils de distributions -- pour CN2
Function CompareDistribCHI2(Root,Current: TTabFrequence; parameters: TPrmFuncDistEval): double;
Var Chi2: Double;
    i: Integer;
    Value: Double;
Begin
  //tableaux vides ?
  If (Root.Value[0]=0) OR (Current.Value[0]=0)
   Then result:= 1.0 //pas de comparaison possible
   Else
    Begin
     Chi2:= 0;
     For i:= 1 To Root.Size Do
      Begin
       Value:= Root.Value[i]+Current.Value[i];
       If (Value>0)
        Then Chi2:= Chi2+Power(Root.Value[i]/Root.Value[0]-Current.Value[i]/Current.Value[0],2)/Value;
      End;
     Chi2:= Root.Value[0]*Current.Value[0]*Chi2;
     //calcul du risque critique
     Result:= PKHI2(pred(Root.Size),CHI2);
    End;
End;


end.

