(*****************************************************************)
(* UCompAssocTreeSpv.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*****************************************************************)

{
@abstract(Gnration de rgles d'association - Recherche en arbre supervis)
@author(Ricco)
@created(29/11/2004)

Treillis de recherche -- Algorithme supervis trs simplifi
Growing + Post-lagage.

Mme si les noms sont proches, il ne s'agit pas d'un hritier des ASSOC_APRIORI
}


unit UCompAssocTreeSpv;

interface

USES
        Contnrs,
        Forms,Classes,IniFiles,
        UCompDefinition,
        UOperatorDefinition,
        UCompAssociationRuleDefinition,
        UDatasetExamples,
        UCalcAssocStructure,
        UCompManageDataset,
        UDatasetDefinition,
        UDatasetImplementation,
        UCalcAssocTreeSpv,
        UCompAssocRuleSupervised;

TYPE
        {gnrateur de composant}
        TGenCompAssocTreeSpv = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

        {composant}
        TMLCompAssocTreeSpv = class(TMLCompLocalData)
                              protected
                              function    getClassOperator: TClassOperator; override;
                              end;

        {oprateur}
        TOpAssocTreeSpv = class(TOpLocalData)
                          private
                          {Variable classe}
                          FTarget: TAttribute;
                          {Les inputs}
                          FInputs: TLstAttributes;
                          {Valeur  prdire de l'attribut Target}
                          FTargetValue: TTypeDiscrete;                          
                          {structure arborescente}
                          FTree: TAssocTreeStructure;
                          protected
                          function    getClassParameter: TClassOperatorParameter; override;
                          function    CheckAttributes(): boolean; override;
                          function    CoreExecute(): boolean; override;
                          public
                          function    getHTMLResultsSummary(): string; override;
                          property    Target: TAttribute read FTarget;
                          property    Inputs: TLstAttributes read FInputs;
                          property    TargetValue: TTypeDiscrete read FTargetValue;
                          end;

        {paramtre de l'oprateur est un "TOpPrmAssocRuleSpv"}
        TOpPrmAssocTreeSpv = class(TOpPrmAssocRuleSpv)
                             private
                             {critre de tri}
                             FSortCriteria: integer;
                             protected
                             function    CreateDlgParameters(): TForm; override;
                             function    getCoreHTMLParameters(): string; override;
                             public
                             procedure   SetDefaultParameters(); override;
                             procedure   LoadFromStream(prmStream: TStream); override;
                             procedure   SaveToStream(prmStream: TStream); override;
                             procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                             procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                             property    SortCriteria: integer read FSortCriteria write FSortCriteria;
                             end;   

        

implementation

uses
        Sysutils,
        UDlgOpPrmAssocTreeSpv, UDlgBaseOperatorParameter, UConstConfiguration;

const
        SORT_CRITERIA_DESCRIPTION : array[0..3] of String = ('no sort','rule length','rule confidence','rule lift');

{ TGenCompAssocTreeSpv }

procedure TGenCompAssocTreeSpv.GenCompInitializations;
begin
 FMLComp:= mlcAssociation;
end;

function TGenCompAssocTreeSpv.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompAssocTreeSpv;
end;

{ TMLCompAssocTreeSpv }

function TMLCompAssocTreeSpv.getClassOperator: TClassOperator;
begin
 result:= TOpAssocTreeSpv;
end;

{ TOpAssocTreeSpv }

function TOpAssocTreeSpv.CheckAttributes: boolean;
begin
 result:= FALSE;
 if ((self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caDiscrete)))
  then
   begin
    //tester le target
    if (self.WorkData.LstAtts[asTarget].Count=1) and (self.WorkData.LstAtts[asTarget].isAllCategory(caDiscrete))
     then
      Begin
       //les inputs
       FInputs:= self.WorkData.LstAtts[asInput];
       //le target
       FTarget:= self.WorkData.LstAtts[asTarget].Attribute[0];
       //reprer la modalit de l'attribut  prdire
       FTargetValue:= FTarget.LstValues.isValueAvailable((self.PrmOp as TOpPrmAssocRuleSpv).ValueToPredict);
       //TRUE si ok il y a qq chose  faire
       result:= (FTargetValue>0);
      End;
   end;
end;

function TOpAssocTreeSpv.CoreExecute: boolean;
begin
 if assigned(FTree) then FTree.Free();
 TRY
  //prparer et passer les paramtres
  FTree:= TAssocTreeStructure.create(self);
  //lancer....
  FTree.buildTree(self.WorkData.Examples);
  //ok.
  result:= TRUE;
 EXCEPT
  result:= FALSE;
 END;
end;

function TOpAssocTreeSpv.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmAssocTreeSpv;
end;

function TOpAssocTreeSpv.getHTMLResultsSummary: string;
begin
 result:= FTree.getHTMLDescription();
end;

{ TOpPrmAssocTreeSpv }

function TOpPrmAssocTreeSpv.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmAssocTreeSpv.CreateFromOpPrm(self);
end;

function TOpPrmAssocTreeSpv.getCoreHTMLParameters: string;
begin
 result:= inherited getCoreHTMLParameters()+
          HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Sort criteria</TD><TD align="right">%s</TD></TR>',[SORT_CRITERIA_DESCRIPTION[FSortCriteria]]);      
end;

procedure TOpPrmAssocTreeSpv.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
  inherited;
  FSortCriteria:= prmINI.ReadInteger(prmSection,'sort_criteria',FSortCriteria);
end;

procedure TOpPrmAssocTreeSpv.LoadFromStream(prmStream: TStream);
begin
  inherited;
  prmStream.ReadBuffer(FSortCriteria,sizeof(FSortCriteria));
end;

procedure TOpPrmAssocTreeSpv.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
  inherited;
  prmINI.WriteInteger(prmSection,'sort_criteria',FSortCriteria);
end;

procedure TOpPrmAssocTreeSpv.SaveToStream(prmStream: TStream);
begin
  inherited;
  prmStream.WriteBuffer(FSortCriteria,sizeof(FSortCriteria));
end;

procedure TOpPrmAssocTreeSpv.SetDefaultParameters;
begin
 inherited SetDefaultParameters();
 FSortCriteria:= 0;
end;

initialization
 RegisterClass(TGenCompAssocTreeSpv);
end.
