(*******************************************************************)
(* UCalcAssocStructure.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*******************************************************************)

{
@abstract(Structure de calcul pour les rgles d'association)
@author(Ricco)
@created(12/01/2004)
}
unit UCalcAssocStructure;

interface

USES
        EZDSLBar,
        Contnrs, Inifiles, Classes,
        UDatasetDefinition,
        UDatasetExamples;

CONST
        {max d'individus grs par les structures pour les rgles d'association}
        //MAX_EXAMPLES_ASSOC_RULE = 250000;//- que 32767*8 en tous les cas
        MAX_EXAMPLES_ASSOC_RULE = 350000;//new -- 20/04/2006 -- dpasser la limitation pour tests...

        {valeur "faux" pour les attributs continus}
        ASSOC_RULE_FALSE_VALUE_FOR_CONTINUOUS_ATT : TTypeContinue = 0.0;

TYPE
        {un item}
        TAssocItem = class(TObject)
                     private
                     {attribut}
                     FAtt: TAttribute;
                     {valeur associe  l'item}
                     FValue: TTypeDiscrete;
                     {nombre d'individus couverts}
                     FSupport: integer;
                     {description de l'item}
                     FDescription: string;
                     {Tableau boolen des couverts}
                     FBoolArray: TBooleanArray;
                     {numro de l'item dans la liste}
                     FNumero: integer;
                     public
                     {constructeur pour les attributs discrets}
                     constructor Create(prmAtt: TAttribute; prmValue: TTypeDiscrete; prmExamples: TExamples); overload;
                     {constructeur pour les attributs continus}
                     constructor Create(prmAtt: TAttribute; prmExamples: TExamples); overload;
                     destructor  Destroy; override;
                     procedure   IncSupport();
                     function    isCovered(example: integer): boolean;
                     property    Support: integer read FSupport write FSupport;
                     property    Description: string read FDescription;
                     property    BoolArray: TBooleanArray read FBoolArray;
                     property    Numero: integer read FNumero write FNumero;
                     property    Attribute: TAttribute read FAtt;
                     property    Value: TTypeDiscrete read FValue;
                     end;

        {liste des items}
        TLstAssocItem = class(TObject)
                        private
                        {liste interne des items}
                        FLstItems: TObjectList;
                        {tableau temporaire des items}
                        FTmpTabItems: array of TAssocItem;
                        {nombre initial d'items}
                        FCountFirstItems: integer;
                        {nombre courant d'items}
                        function    CountItems(): integer;
                        {rcuprer l'item ni}
                        function    getItem(i: integer): TAssocItem;
                        {construire les items pour un attribut discret}
                        procedure   buildItemsDiscrete(prmAtt: TAttribute; prmExamples: TExamples);
                        {construire les items pour un attribut continu :: new :: 05/11/2004 -- hyp. 0 = false, otherwise (1 par ex.) = true}
                        procedure   buildItemsContinuous(prmAtt: TAttribute; prmExamples: TExamples);
                        public
                        constructor Create();
                        destructor  Destroy; override;
                        {construire les items d'un attribut discret}
                        procedure   buildItems(prmAtt: TAttribute; prmExamples: TExamples);
                        {construire l'item associ  une valeur d'un attribut discret}
                        procedure   buildValueItem(prmAtt: TAttribute; prmValue: TTypeDiscrete; prmExamples: TExamples);
                        {trier les items selon un critre}
                        procedure   SortItems(funcSort: TListSortCompare);
                        {filtrer les items selon leur support}
                        procedure   FilterItemsOnSupport(prmSupportThresold: integer);
                        {filtrer les items selon le support, sans procder  un tri -- utile quand certains items jouent un rle particulier}
                        procedure   FilterItemsOnSupportNoSort(prmSupportThresold: integer);
                        {proprits}
                        property    Count: integer read CountItems;
                        property    Item[i: Integer]: TAssocItem read getItem;
                        property    CountFirstItems: integer read FCountFirstItems;
                        end;

        {un itemset}
        TAssocItemSet = class(TObject)
                        private
                        {liste des items associs}
                        FLstItems: TObjectList;
                        {support de l'itemset}
                        FSupport: integer;
                        {description de l'itemset}
                        FDescription: string;
                        {tableau des boolens}
                        FBoolArray: TBooleanArray;
                        public
                        constructor Create(prmItemSet: TAssocItemSet; prmItem: TAssocItem); overload;
                        constructor Create(prmItem1,prmItem2: TAssocItem); overload;
                        function    isItemNotIncluded(prmItem: TAssocItem): boolean;
                        destructor  Destroy(); override;
                        function    Last(): TAssocItem;
                        function    card(): integer;
                        function    getItem(i: integer): TAssocItem;
                        {vider  la vole le tableau de bits}
                        procedure   freeBoolArray();
                        //function    isCovered(example: integer): boolean;
                        //function    computeSupport(prmExamples: TExamples): integer;
                        property    Description: string read FDescription;
                        property    Support: integer read FSupport;
                        //property    BoolArray: TBooleanArray read FBoolArray;
                        end;

        {liste d'itemset}
        TLstAssocItemSet = class(TObject)
                           private
                           {liste des itemsets}
                           FLstItemset: THashedStringList;
                           public
                           constructor  Create();
                           destructor   Destroy(); override;
                           procedure    AddItemSet(prmItemset: TAssocItemset);
                           function     Count(): integer;
                           function     getItemset(i: integer): TAssocItemset;
                           {supprimer les boolarray des itemsets de la liste - prserver la mmoire en gros}
                           procedure    freeBoolArray();
                           end;

        {tableau des itemsets -  2 items, 3 items, etc.}
        TStructureItemsets = class(TObject)
                             private
                             {liste de liste d'itemsets}
                             FTabLstItemset: TObjectList;
                             public
                             constructor Create();
                             destructor  Destroy; override;
                             function    AddLstAssocItemset(): TLstAssocItemset;
                             function    Count(): integer;
                             function    getLstItemsets(j: integer): TLstAssocItemset;
                             procedure   FreeLast();
                             end;

        {Tableau de boolen correspondant  un itemset}
        TAssocBoolItemset = class(TObject)
                            private
                            FItemsetCard: integer;
                            FExamplesSize: integer;
                            FBoolConsequent: Array of boolean;
                            function    getValue(i: integer): boolean;
                            procedure   setValue(i: integer; value: boolean);
                            public
                            constructor Create(prmExamplesSize: integer);
                            destructor  Destroy; override;
                            procedure   Initialize(prmAssoc: TAssocItemset);
                            property    Value[i: integer]: boolean read getValue write setValue;
                            end;

        TCalcRuleFromItemset = class;

        {structure de rgle d'association}
        TAssocRuleStructure = class(TObject)
                              protected
                              //liste de associtem pour l'antcdent
                              FAnte: TObjectList;
                              //liste de associtem pour le consquent
                              FCons: TObjectList;
                              FSupport: double;
                              FConfiance: double;
                              FLift: double;
                              //rcuprer les infos
                              procedure   RecupInfos(calcRule: TCalcRuleFromItemset); virtual;
                              public
                              constructor Create(calcRule: TCalcRuleFromItemset); virtual;
                              destructor  Destroy; override;
                              function    Description(): string;
                              function    ShortDescriptionHTML(): string;
                              function    ShortDescriptionTXT(): string;
                              function    DescriptionHTML(): string; virtual;
                              //new -- 10/03/2006 -- renvoie l'item nk de l'antcdent
                              function    getAntecedentItem(k: integer): TAssocItem;
                              //nombre d'items dans l'antcdent
                              function    getCountAntecedent(): integer;  
                              // 
                              property    Lift: double read FLift;
                              property    Support: double read FSupport;
                              property    Confiance: double read FConfiance;
                              property    Consequent: TObjectList read FCons;
                              end;

        {classe de rgles d'association}
        TClassAssocRuleStructure = class of TAssocRuleStructure; 

        {liste de rgles}
        TLstAssocRules = class(TObject)
                         private
                         FLstRules: TObjectList;
                         public
                         constructor create(prmOwner: boolean); virtual;
                         destructor  destroy; override;
                         procedure   addRule(rule: TAssocRuleStructure);
                         function    count(): integer;
                         function    getRule(i: integer): TAssocRuleStructure;
                         function    DescriptionHTML(): string; virtual;
                         procedure   sortRulesOn(funcSort: TListSortCompare);
                         procedure   deleteRule(i: integer);
                         procedure   copy(source: TLstAssocRules);
                         procedure   setOwner(prmOwner: boolean);
                         procedure   clear();
                         end;

        {classe de TLstAssocRules}
        TClassLstAssocRules = class of TLstAssocRules;

        {classe de recherche des rgles  partir d'un itemset}
        TCalcRuleFromItemset = class(TObject)
                               protected
                               FCalcAssoc: TObject;
                               FItemInConsequent: TAssocBoolItemset;
                               FBitAnte,FBitCons: TBooleanArray;
                               FCurItemset: TAssocItemSet;
                               FLstRules: TObjectList;
                               FMinConfiance: double;
                               FBaseSize: double;
                               procedure    Initialize(prmItemset: TAssocItemSet);
                               procedure    GenerateRules(i: integer; prmClassARStructre: TClassAssocRuleStructure);
                               public
                               constructor  Create(exSize: integer; prmMinConfiance: double; calcAssoc: TObject); virtual;
                               destructor   Destroy; override;
                               {construire les rgles  partir d'un itemset donn}
                               procedure    BuildRules(prmItemset: TAssocItemset; prmClassARStructre: TClassAssocRuleStructure); virtual;
                               {proprits}
                               property     curItemset: TAssocItemset read FCurItemset;
                               property     lstRules: TObjectList read FLstRules;
                               property     ItemInConsequent: TAssocBoolItemset read FItemInConsequent;
                               property     BitAnte: TBooleanArray read FBitAnte;
                               property     BitCons: TBooleanArray read FBitCons;
                               property     BaseSize: double read FBaseSize;
                               end;

        {classe de CalcRuleFromItemset}
        TClassCalcRuleFromItemset = class of TCalcRuleFromItemset;

{**** fonction globale de comparaison des rgles pour les tris ****}

{comparaison sur les lifts}
function RuleCompareOnLift(item1, item2: Pointer): integer;
{comparaison sur les nombred d'items et les lifts}
function RuleCompareOnNbAnteItemsAndLift(item1, item2: Pointer): integer;


implementation

uses
        Math,
        Sysutils, UStringAddBuffered, UConstConfiguration, ULogFile;

{ TAssocItem }

constructor TAssocItem.Create(prmAtt: TAttribute; prmValue: TTypeDiscrete;
  prmExamples: TExamples);
begin
 inherited Create();
 FSupport:= 0;
 FAtt:= prmAtt;
 FValue:= prmValue;
 FDescription:= format('%s=%s',[FAtt.Name,FAtt.LstValues.getDescription(prmValue)]);
 FBoolArray:= TBooleanArray.Create(prmExamples.Size);
 //tout est dj false par dfaut
 //FBoolArray.SetAllFalse;
end;

constructor TAssocItem.Create(prmAtt: TAttribute; prmExamples: TExamples);
begin
 inherited Create();
 FSupport:= 0;
 FAtt:= prmAtt;
 FValue:= 1;
 FDescription:= format('%s=%s',[FAtt.Name,'true']);
 FBoolArray:= TBooleanArray.Create(prmExamples.Size);
 //tout est dj false par dfaut
 //FBoolArray.SetAllFalse;
end;

destructor TAssocItem.Destroy;
begin
 FBoolArray.Free;
 inherited Destroy;
end;

procedure TAssocItem.IncSupport;
begin
 inc(FSupport);
end;

function TAssocItem.isCovered(example: integer): boolean;
begin
 {new -- 05/11/2004 -- terrible ralentissement mais l c'est difficile de faire autrement sans tout refaire !!!}
 if FAtt.isCategory(caDiscrete)
  then result:= (FAtt.dValue[example] = FValue)
  else result:= (FAtt.cValue[example] > ASSOC_RULE_FALSE_VALUE_FOR_CONTINUOUS_ATT);
end;

{ TLstAssocItem }

procedure TLstAssocItem.buildItems(prmAtt: TAttribute;
  prmExamples: TExamples);
begin
 if prmAtt.isCategory(caDiscrete)
  //att. discrets
  then self.buildItemsDiscrete(prmAtt,prmExamples)
  //att continus, hyp. 0 = faux --- 1 et + = true
  else self.buildItemsContinuous(prmAtt,prmExamples);
end;

procedure TLstAssocItem.buildItemsContinuous(prmAtt: TAttribute;
  prmExamples: TExamples);
var item: TAssocItem;
    i: integer; 
begin
 //cration d'un item
 item:= TAssocItem.Create(prmAtt,prmExamples);
 //scanner les individus
 for i:= 1 to prmExamples.Size do
  begin
   if (prmAtt.cValue[prmExamples.Number[i]]>ASSOC_RULE_FALSE_VALUE_FOR_CONTINUOUS_ATT)
    then item.BoolArray.Flag[pred(i)]:= TRUE;
  end;
 //recompter pour tre sr
 item.Support:= item.BoolArray.Count;
 //ajouter dans la liste
 FLstItems.Add(item);
end;

procedure TLstAssocItem.buildItemsDiscrete(prmAtt: TAttribute;
  prmExamples: TExamples);
var item: TAssocItem;
    i,k: integer;
begin
 //ajouter les items
 setLength(FTmpTabItems,succ(prmAtt.nbValues));
 for k:= 1 to prmAtt.nbValues do
  begin
   item:= TAssocItem.Create(prmAtt,k,prmExamples);
   FTmpTabItems[k]:= item;
   FLstItems.Add(item);
  end;
 //scanner les individus
 for i:= 1 to prmExamples.Size do
  begin
   k:= prmAtt.dValue[prmExamples.Number[i]];
   FTmpTabItems[k].BoolArray.Flag[pred(i)]:= TRUE;
  end;
 //recompter les individus -- affectation  l'indicateur de support
 for k:= 1 to prmAtt.nbValues do
  begin
   FTmpTabItems[k].Support:= FTmpTabItems[k].BoolArray.Count;
   //TraceLog.WriteToLogFile(format('%s -> %d',[FTmpTabItems[k].Description,FTmpTabItems[k].Support]));
  end;
end;

procedure TLstAssocItem.buildValueItem(prmAtt: TAttribute;
  prmValue: TTypeDiscrete; prmExamples: TExamples);
var item: TAssocItem;
    i: integer;
begin
 //crer et ajouter dans la liste des items...
 item:= TAssocItem.Create(prmAtt,prmValue,prmExamples);
 FLstItems.Add(item);
 //scanner les individus
 for i:= 1 to prmExamples.Size do
  begin
   if (prmAtt.dValue[prmExamples.Number[i]] = prmValue)
    then item.BoolArray.Flag[pred(i)]:= TRUE;
  end;
 //comptage et affectation du support
 item.Support:= item.BoolArray.Count;
end;

function TLstAssocItem.CountItems: integer;
begin
 result:= FLstItems.Count;
end;

constructor TLstAssocItem.Create;
begin
 inherited Create();
 FLstItems:= TObjectList.Create(TRUE);
end;

destructor TLstAssocItem.Destroy;
begin
 setLength(FTmpTabItems,0);
 FLstItems.Free;
 inherited;
end;

function CompareItemsOnSupport(item1,item2: Pointer): integer; forward;

procedure TLstAssocItem.FilterItemsOnSupport(prmSupportThresold: integer);
var i: integer;
begin
 FCountFirstItems:= self.Count;
 //trier pour gagner du temps par la suite
 self.SortItems(CompareItemsOnSupport);
 //puis virer ceux qui sont en dernier est inf. au thresold
 for i:= pred(self.Count) downto 0 do
  begin
   if (self.Item[i].Support<prmSupportThresold)
    then FLstItems.Delete(i)
    //on arrte puisque la liste est trie
    else BREAK;
  end;
end;

procedure TLstAssocItem.FilterItemsOnSupportNoSort(
  prmSupportThresold: integer);
var tmpLst: TObjectList;
    item: TAssocItem;
    i: integer;
begin
 //liste propritaire, non propritaire
 tmpLst:= TObjectList.Create(FALSE);
 //compter au dpart les items
 FCountFirstItems:= self.Count;
 //vider la liste actuelle en la copiant sur la liste temporaire
 tmpLst.Assign(self.FLstItems);
 //not propertary temporairement
 self.FLstItems.OwnsObjects:= FALSE;
 self.FLstItems.Clear();
 //pour chaque item candidat
 for i:= 0 to pred(tmpLst.Count) do
  begin
   item:= tmpLst.Items[i] as TAssocItem;
   //frquent ?
   if (item.Support<prmSupportThresold)
    then
     begin
      item.Free();
      tmpLst.Items[i]:= NIL;//oui, la rf. n'est plus valable
     end
    else
     begin
      //ne pas oublier le numrotage de l'item !!! -- 26/07/2004
      item.Numero:= self.FLstItems.Add(item);
     end;
  end;
 //propertary now...
 self.FLstItems.OwnsObjects:= TRUE;
 //vider la liste temporaire
 tmpLst.Free();
end;

function TLstAssocItem.getItem(i: integer): TAssocItem;
begin
 result:= FLstItems.Items[i] as TAssocItem;
end;

{critre de tri des items, de manire dcroissante, no problemo sur les ex-aequo}
//TListSortCompare = function (Item1, Item2: Pointer): Integer;
function CompareItemsOnSupport(item1,item2: Pointer): integer;
begin
 if (TAssocItem(item1).Support<TAssocItem(item2).Support)
  then result:= +1
  else
   if (TAssocItem(item1).Support>TAssocItem(item2).Support)
    then result:= -1
    else result:= 0;
end;

procedure TLstAssocItem.SortItems(funcSort: TListSortCompare);
var i: integer;
begin
 FLstItems.Sort(funcSort);
 //numroter les items
 for i:= 0 to pred(FLstItems.Count) do
  (FLstItems.Items[i] as TAssocItem).Numero:= i;
end;

{ TAssocItemSet }

constructor TAssocItemSet.Create(prmItemSet: TAssocItemSet; prmItem: TAssocItem);
begin
 inherited Create();
 FSupport:= 0;
 FLstItems:= TObjectList.Create(FALSE);
 FLstItems.Assign(prmItemSet.FLstItems);
 //la description
 FDescription:= prmItemSet.Description;
 //ajouter le dernier
 FLstItems.Add(prmItem);
 FDescription:= FDescription+'$'+prmItem.Description;
 //tableau de booleen - new and very fast
 FBoolArray:= TBooleanArray.CreateFrom(prmItemSet.FBoolArray);
 FBoolArray.AndArray(prmItem.BoolArray);
 FBoolArray.RefreshCount();
 FSupport:= FBoolArray.Count;
end;

function TAssocItemSet.card: integer;
begin
 result:= FLstItems.Count;
end;

constructor TAssocItemSet.Create(prmItem1, prmItem2: TAssocItem);
begin
 inherited Create();
 FSupport:= 0;
 FLstItems:= TObjectList.Create(FALSE);
 FLstItems.Add(prmItem1);
 FLstItems.Add(prmItem2);
 FDescription:= prmItem1.Description+'$'+prmItem2.Description;
 //boolean array
 FBoolArray:= TBooleanArray.CreateFrom(prmItem1.BoolArray);
 FBoolArray.AndArray(prmItem2.BoolArray);
 FBoolArray.RefreshCount();
 FSupport:= FBoolArray.Count;
end;

destructor TAssocItemSet.Destroy;
begin
 FBoolArray.Free;
 FLstItems.Free;
 inherited;
end;

(*
function TAssocItemSet.computeSupport(prmExamples: TExamples): integer;
var i: integer;
begin
 FSupport:= 0;
 for i:= 1 to prmExamples.Size do
  if self.isCovered(prmExamples.Number[i])
   then inc(FSupport);
 result:= FSupport;
end;

function TAssocItemSet.isCovered(example: integer): boolean;
var i,nb: integer;
    ok: boolean;
begin
 nb:= self.Count;
 i:= 0;
 ok:= true;
 while ok and (i<nb) do
  begin
   ok:= ok and self.getItem(i).isCovered(example);
   inc(i);
  end;
 result:= ok;
end;
*)

function TAssocItemSet.isItemNotIncluded(prmItem: TAssocItem): boolean;
begin
 result:= (FLstItems.IndexOf(prmItem)<0);
end;

function TAssocItemSet.Last: TAssocItem;
begin
 result:= FLstItems.Last as TAssocItem;
end;

function TAssocItemSet.getItem(i: integer): TAssocItem;
begin
 result:= FLstItems[i] as TAssocItem;
end;

procedure TAssocItemSet.freeBoolArray;
begin
 if assigned(FBoolArray)
  then FreeAndNil(FBoolArray);
end;

{ TLstAssocItemSet }

procedure TLstAssocItemSet.AddItemSet(prmItemset: TAssocItemset);
begin
 FLstItemset.AddObject(prmItemset.Description,prmItemset);
end;

function TLstAssocItemSet.Count: integer;
begin
 result:= FLstItemset.Count;
end;

constructor TLstAssocItemSet.Create;
begin
 inherited Create();
 FLstItemset:= THashedStringList.Create();
end;

destructor TLstAssocItemSet.Destroy;
var i: integer;
    itemset: TAssocItemset;
begin
 for i:= pred(FLstItemset.Count) downto 0 do
  begin
   //supprimer l'objet
   itemset:= FLstItemset.Objects[i] as TAssocItemset;
   itemset.Free;
   //supprimer la rfrence
   FLstItemset.Delete(i);
  end;
 inherited Destroy();
end;

procedure TLstAssocItemSet.freeBoolArray;
var i: integer;
begin
 for i:= 0 to pred(self.Count) do
  self.getItemset(i).freeBoolArray;
end;

function TLstAssocItemSet.getItemset(i: integer): TAssocItemset;
begin
 result:= FLstItemset.Objects[i] as TAssocItemset;
end;

{ TStructureItemsets }

function TStructureItemsets.AddLstAssocItemset: TLstAssocItemset;
var lstItemsets: TLstAssocItemSet;
begin
 lstItemsets:= TLstAssocItemSet.Create();
 FTabLstItemset.Add(lstItemsets);
 result:= lstItemsets;
end;

function TStructureItemsets.Count: integer;
begin
 result:= FTabLstItemset.Count;
end;

constructor TStructureItemsets.Create;
begin
 inherited Create();
 FTabLstItemset:= TObjectList.Create(TRUE);
end;

destructor TStructureItemsets.Destroy;
begin
 FTabLstItemset.Free;
 inherited;
end;

procedure TStructureItemsets.FreeLast;
var last: TLstAssocItemset;
begin
 last:= FTabLstItemset.Last as TLstAssocItemset;
 if (last.Count>0)
  then raise Exception.Create('itemset frquent valable supprim  tort')
  else FTabLstItemset.Delete(pred(FTabLstItemset.Count));
end;

function TStructureItemsets.getLstItemsets(j: integer): TLstAssocItemset;
begin
 result:= FTabLstItemset.Items[j] as TLstAssocItemset;
end;

{ TAssocBoolItemset }

constructor TAssocBoolItemset.Create(prmExamplesSize: integer);
begin
 inherited Create();
 FExamplesSize:= prmExamplesSize;
end;

destructor TAssocBoolItemset.Destroy;
begin
 setLength(FBoolConsequent,0);
 inherited;
end;

function TAssocBoolItemset.getValue(i: integer): boolean;
begin
 result:= FBoolConsequent[i];
end;

procedure TAssocBoolItemset.Initialize(prmAssoc: TAssocItemset);
var i: integer;
begin
 FItemsetCard:= prmAssoc.card;
 setLength(FBoolConsequent,FItemsetCard);
 for i:= 0 to pred(FItemsetCard) do
  FBoolConsequent[i]:= FALSE;
end;

procedure TAssocBoolItemset.setValue(i: integer; value: boolean);
begin
 FBoolConsequent[i]:= value;
end;

{ TCalcRuleFromItemset }

procedure TCalcRuleFromItemset.BuildRules(prmItemset: TAssocItemset; prmClassARStructre: TClassAssocRuleStructure);
var i: integer;
begin
 self.Initialize(prmItemset);
 for i:= 0 to pred(FCurItemset.card) do
  self.GenerateRules(i,prmClassARStructre);
end;

constructor TCalcRuleFromItemset.Create(exSize: integer; prmMinConfiance: double; calcAssoc: TObject);
begin
 inherited Create;
 FLstRules:= TObjectList.Create(FALSE);
 FMinConfiance:= prmMinConfiance;
 FCurItemset:= NIL;
 FItemInConsequent:= TAssocBoolItemset.Create(exSize);
 FBitAnte:= TBooleanArray.Create(exSize);
 FBitCons:= TBooleanArray.Create(exSize);
 FBaseSize:= 1.0*exSize;
 FCalcAssoc:= calcAssoc;
end;

destructor TCalcRuleFromItemset.Destroy;
begin
 FBitAnte.Free;
 FBitCons.Free;
 FItemInConsequent.Free;
 FLstRules.Free;
 inherited;
end;

procedure TCalcRuleFromItemset.GenerateRules(i: integer; prmClassARStructre: TClassAssocRuleStructure);
var item: TAssocItem;
    k,j: integer;
    curConf: double;
    rule: TAssocRuleStructure;
    nbAnte,nbCons: integer;
begin
 //enlever i de l'antcdent pour l'ajouter dans le consquent
 FItemInConsequent.Value[i]:= TRUE;
 //#ToDo1 - trs lent mais seule solution sre pour l'instant -  revoir absolument
 //l'autre solution serait de rechercher les itemsets corresp  l'antcdent et au consquent
 //pour rcuprer les distributions -> dans ce cas la table de hachage est trs importante
 //c'est  voir, dj ici c'est pas mal en termes de temps de calcul, bravo EZDSL !!!
 FBitCons.SetAllTrue;
 FBitAnte.SetAllTrue;
 nbAnte:= 0;
 nbCons:= 0;
 for k:= 0 to pred(FCurItemset.card) do
  begin
   item:= FCurItemset.getItem(k);
   if FItemInConsequent.Value[k]
    then
     begin
      FBitCons.AndArray(item.BoolArray);
      inc(nbAnte);
     end
    else
     begin
      FBitAnte.AndArray(item.BoolArray);
      inc(nbCons);
     end;
  end;
 //si la rgle est valable
 if (nbAnte>0) and (nbCons>0)
  then
   begin
     //valuer la confiance de la rgle forme
     FBitCons.RefreshCount;
     FBitAnte.RefreshCount;
     curConf:= 1.0*FCurItemset.Support/(1.0*FBitAnte.Count);
     //tester si ok
     if (curConf>=FMinConfiance)
      then
       //on valide la rgle et on explore en profondeur
       begin
        //rule:= TAssocRuleStructure.Create(self);
        //rendre la chose paramtrable -- 23/05/2004
        rule:= prmClassARStructre.Create(self);
        ///suite std.
        FLstRules.Add(rule);
        for j:= succ(i) to pred(FCurItemset.card) do
         GenerateRules(j,prmClassARStructre);
       end;
   end;
 //on remonte vers le haut  la sortie
 FItemInConsequent.Value[i]:= FALSE;
end;

procedure TCalcRuleFromItemset.Initialize(prmItemset: TAssocItemSet);
begin
 FLstRules.Clear();
 FCurItemset:= prmItemset;
 FItemInConsequent.Initialize(prmItemset);
 (*
 FBitAnte.CopyFrom(prmItemset.BoolArray);
 FBitCons.SetAllTrue;
 *)
end;

{ TAssocRuleStructure }

constructor TAssocRuleStructure.Create(calcRule: TCalcRuleFromItemset);
begin
 inherited Create();
 FAnte:= TObjectList.Create(FALSE);
 FCons:= TObjectList.Create(FALSE);
 self.RecupInfos(calcRule);
end;

function TAssocRuleStructure.Description: string;
var i: integer;
    s: string;
begin
 s:= '';
 for i:= 0 to pred(FAnte.Count) do
  s:= s+'$'+(FAnte.Items[i] as TAssocItem).Description;
 s:= s+'==>';
 for i:= 0 to pred(FCons.Count) do
  s:= s+'$'+(FCons.Items[i] as TAssocItem).Description;
 s:= s+format('(%.4f ; %.4f ; %.4f)',[FSupport,FConfiance,FLift]);
 result:= s;
end;

function TAssocRuleStructure.DescriptionHTML: string;
var s: string;
begin
 s:= self.ShortDescriptionHTML();
 //infos
 s:= s+format('<TD align=right>%.3f</TD><TD align=right>%.3f</TD><TD align=right>%.3f</TD>',[FLift,FSupport,FConfiance]);
 //s:= s+'</TR>';
 //renvoyer le tout
 result:= s;
end;

destructor TAssocRuleStructure.Destroy;
begin
 FAnte.Free;
 FCons.Free;
 inherited;
end;

function TAssocRuleStructure.getAntecedentItem(k: integer): TAssocItem;
begin
 result:= FAnte.Items[k] as TAssocItem;
end;

function TAssocRuleStructure.getCountAntecedent: integer;
begin
 result:= FAnte.Count;
end;

procedure TAssocRuleStructure.RecupInfos(calcRule: TCalcRuleFromItemset);
var i: integer;
    item: TAssocItem;
begin
 //rcuprer les items
 for i:= 0 to pred(calcRule.curItemset.card) do
  begin
   item:= calcRule.curItemset.getItem(i);
   if calcRule.ItemInConsequent.Value[i]
    then FCons.Add(item)
    else FAnte.Add(item);
  end;
 //calculer les infos d'apprciation des rgles
 FSupport:= 1.0*calcRule.curItemset.Support/calcRule.BaseSize;
 FConfiance:= FSupport/(1.0*calcRule.BitAnte.Count/calcRule.BaseSize);
 FLift:= FConfiance/(1.0*calcRule.BitCons.Count/calcRule.BaseSize);
end;

function TAssocRuleStructure.ShortDescriptionHTML: string;
var s: string;
    i: integer;
begin
 s:= '';
 //antcdent
 s:= s+'<TD '+HTML_BGCOLOR_DATA_BLUE+'>';
 for i:= 0 to pred(FAnte.Count) do
  s:= s+'"'+(FAnte.Items[i] As TAssocItem).Description+'" - ';
 s:= copy(s,1,length(s)-3);
 s:= s+'</TD>';
 //consquent
 s:= s+'<TD '+HTML_BGCOLOR_DATA_GREEN+'>';
 for i:= 0 to pred(FCons.Count) do
  s:= s+'"'+(FCons.Items[i] As TAssocItem).Description+'" - ';
 s:= copy(s,1,length(s)-3);
 s:= s+'</TD>';
 result:= s;
end;

function TAssocRuleStructure.ShortDescriptionTXT: string;
var s: string;
    i: integer;
begin
 s:= '';
 //antcdent
 for i:= 0 to pred(FAnte.Count) do
  s:= s+'"'+(FAnte.Items[i] As TAssocItem).Description+'" - ';
 s:= copy(s,1,length(s)-3);
 s:= s+';';
 //consquent
 for i:= 0 to pred(FCons.Count) do
  s:= s+'"'+(FCons.Items[i] As TAssocItem).Description+'" - ';
 s:= copy(s,1,length(s)-3);
 s:= s+';';
 result:= s;
end;
{ TLstAssocRules }

procedure TLstAssocRules.addRule(rule: TAssocRuleStructure);
begin
 FLstRules.Add(rule);
end;

procedure TLstAssocRules.clear;
begin
 FLstRules.Clear();
end;

procedure TLstAssocRules.copy(source: TLstAssocRules);
begin
 self.FLstRules.Clear();
 self.FLstRules.Assign(source.FLstRules);
end;

function TLstAssocRules.count: integer;
begin
 result:= FLstRules.Count;
end;

constructor TLstAssocRules.create(prmOwner: boolean);
begin
 inherited Create();
 FLstRules:= TObjectList.Create(prmOwner);
end;

procedure TLstAssocRules.deleteRule(i: integer);
begin
 FLstRules.Delete(i);
end;

function TLstAssocRules.DescriptionHTML: string;
var buf: TBufString;
    i: integer;
    tmp: string;
begin
 buf:= TBufString.Create();
 buf.BeginUpdate();
 buf.AddStr(HTML_HEADER_TABLE_RESULT);
 buf.AddStr(HTML_TABLE_COLOR_DATA_GRAY+format('<TH colspan=7>Number of rules : %d</TH></TR>',[self.count]));
 buf.AddStr(format(HTML_TABLE_COLOR_HEADER_GRAY+'<TD>N</TD><TD %s>Antecedent</TD><TD %s>Consequent</TD><TD align=right>Lift</TD><TD align=right>Support</TD><TD align=right>Confidence</TD></TR>',[HTML_BGCOLOR_HEADER_BLUE,HTML_BGCOLOR_HEADER_GREEN]));
 for i:= 0 to pred(self.count) do
  begin
   tmp:= format('%s<TD>%d</TD>%s</TR>',[HTML_TABLE_COLOR_DATA_GRAY,succ(i),self.getRule(i).DescriptionHTML]);
   buf.AddStr(tmp);
  end;
 buf.AddStr('</table>');
 //suite normale
 buf.EndUpdate();
 result:= buf.BufS;
 buf.Free;
end;

destructor TLstAssocRules.destroy;
begin
 FLstRules.Free;
 inherited;
end;

function TLstAssocRules.getRule(i: integer): TAssocRuleStructure;
begin
 result:= FLstRules.Items[i] as TAssocRuleStructure;
end;

{comparaison sur les lifts}
function RuleCompareOnLift(item1, item2: Pointer): integer;
begin
 if (TAssocRuleStructure(item1).Lift<TAssocRuleStructure(item2).Lift)
  then result:= +1
  else if (TAssocRuleStructure(item1).Lift>TAssocRuleStructure(item2).Lift)
   then result:= -1
   else result:= 0;
end;

{comparaison sur le nombre d'items dans l'antcdent et le lift}
function RuleCompareOnNbAnteItemsAndLift(item1, item2: Pointer): integer;
begin
 if (TAssocRuleStructure(item1).FAnte.Count<TAssocRuleStructure(item2).FAnte.Count)
  then result:= -1
  else if (TAssocRuleStructure(item1).FAnte.Count>TAssocRuleStructure(item2).FAnte.Count)
   then result:= +1
   //deuxime niveau, comparaison selon le lift, en ordre invers
   else result:= RuleCompareOnLift(item1,item2);
end;

{*************************}

procedure TLstAssocRules.setOwner(prmOwner: boolean);
begin
 FLstRules.OwnsObjects:= prmOwner;
end;

procedure TLstAssocRules.sortRulesOn(funcSort: TListSortCompare);
begin
 FLstRules.Sort(funcSort);
end;

end.
