(**************************************************************************)
(* UCompAssocRulePrefixTreeCB.pas - Copyright (c) 2006 Ricco RAKOTOMALALA *)
(**************************************************************************)

{
@abstract(Gnration de rgles d'association - Appel de l'implmentation de Christian BORGELT)
@author(Ricco)
@created(28/01/2006)

La principale information dans cette histoire est que l'on utilise une nouvelle technologie,
on fait appel  un excutable externe dans une commande au SHELL.

Attention, l'appel n'est pas bloquant, il dmarre tout seul et nous on n'y pense plus par la suite,
mis  part que nous devons rcuprer les rsultats dans une fiche lorsque le traitement est fini.

}

unit UCompAssocRulePrefixTreeCB;

interface

USES
    Forms, Classes, IniFiles,
    UCompDefinition,
    UOperatorDefinition,
    UCompAssociationRuleDefinition,
    UDatasetExamples,
    UCalcAssocStructure,
    UCompAssocRuleAPriori,
    DosCommand;

TYPE
    //gnrateur
    TGenCompAssocRulePT = class(TGenCompAssocAPriori)
                          public
                          function    GetClassMLComponent: TClassMLComponent; override;
                          end;

    //composant
    TMLCompAssocRulePT = class(TMLCompAssocRule)
                          protected
                          function    getClassOperator: TClassOperator; override;
                          end;

    //oprateur
    TOpAssocAPrioriPT = class(TOpAssocRule)
                      private
                      FDosCommand: TDosCommand;
                      FTmpDataset: string;
                      //gnrer les donnes temporaires
                      function    generateTmpDataset(): string;
                      //supprimer le fichier de donnes temporaire
                      procedure   destroyTmpDataset(prmFile: string);
                      //gnerer pour les donnes discrtes
                      function    generateFromDiscrete(prmFile: string): string;
                      //gnrer pour les donnes 0/1 ; seul le cas 1 (en tous les cas > 0) nous intresse
                      function    generateFromContinuous(prmFile: string): string;
                      protected
                      function    getClassParameter: TClassOperatorParameter; override;
                      function    getClassAssocRule(): TClassCalcAssocRule; override;
                      function    getNewForm(): TForm; override;
                      public
                      //montrer la fiche et lancer par la suite les calculs
                      function    CoreExecute(): boolean; override;
                      //ne rien envoyer en sortie
                      function    getHTMLResultsSummary(): string; override;
                      //librer
                      destructor  Destroy; override;
                      //
                      property    DosCommand: TDosCommand read FDosCommand;
                      end;

    //paramtrage
    TOpPrmAssocAPrioriPT = class(TOpPrmAssocRule)
                         private
                         //fichier de sortie
                         FOutRule: string;
                         protected
                         function    CreateDlgParameters(): TForm; override;
                         procedure   SetDefaultParameters(); override;
                         public
                         function    getHTMLParameters(): string; override;
                         procedure   LoadFromStream(prmStream: TStream); override;
                         procedure   SaveToStream(prmStream: TStream); override;
                         procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                         procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                         property    OutRule: string read FOutRule write FOutRule;
                         end;
                         
implementation

uses
  Sysutils, UStringAddBuffered, UDatasetDefinition,
  UDatasetImplementation, ULogFile, UFrmOpViewAssocRulePrefixTree,
  UDlgOpPrmAssocRulePrefixTree;

{ TGenCompAssocRulePT }

function TGenCompAssocRulePT.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompAssocRulePT;
end;

{ TMLCompAssocRulePT }

function TMLCompAssocRulePT.getClassOperator: TClassOperator;
begin
 result:= TOpAssocAPrioriPT;
end;

{ TOpAssocAPriori }

function TOpAssocAPrioriPT.CoreExecute: boolean;
var cmdLine: string;
    prm: TOpPrmAssocAPrioriPT; 
begin
 //s'il n'est pas en cours d'excution, on va le lancer
 //sinon, on ne fait rien surtout
 if (FDosCommand = nil) OR (FDosCommand.Active = false)
  then
   begin
     self.destroyTmpDataset(FTmpDataset);
     if assigned(FDosCommand) then FreeAndNil(FDosCommand);
     //gnrer les donnes
     TRY
     FTmpDataset:= self.generateTmpDataset();
     if (FTmpDataset<>'')
      then
       begin
        TraceLog.WriteToLogFile(format('[A PRIORI Prefix Tree] dataset >>%s<< built',[FTmpDataset]));
        prm:= PrmOp as TOpPrmAssocAPrioriPT;
        //ligne de commande
        cmdLine:= ExtractFilePath(Application.ExeName)+'exe\apriori.exe';
        cmdLine:= cmdLine + format(' "%s" "%s"',[FTmpDataset,expandFileName(prm.OutRule)]);
        cmdLine:= cmdLine + format(' -y -m2 -n%d -s%d -c%d -k" /\ "',[prm.MaxRuleLength,trunc(100.0*prm.MinSupport),trunc(100.0*prm.MinConfidence)]);
        TraceLog.WriteToLogFile(format('[A PRIORI Prefix Tree] command line = %s',[cmdLine]));
        //prparer excution
        FDosCommand:= TDosCommand.Create(NIL);
        FDosCommand.CommandLine:= cmdLine;
        //tout va bien ??? -- on verra
        result:= TRUE;
       end
      else result:= FALSE;
     EXCEPT
     result:= FALSE;
     END;
   end
  else result:= TRUE;//il est dj en train de s'excuter
end;

destructor TOpAssocAPrioriPT.Destroy;
begin
 self.destroyTmpDataset(FTmpDataset);
 if assigned(FDosCommand) then FreeAndNil(FDosCommand);
 inherited;
end;

procedure TOpAssocAPrioriPT.destroyTmpDataset(prmFile: string);
begin
 if (prmFile <> '') and FileExists(prmFile)
  then
   begin
    deleteFile(prmFile);
    TraceLog.WriteToLogFile(format('[A PRIORI Prefix Tree] dataset >>%s<< deleted',[prmFile]));
   end;
end;

//*********************************************************
//quelques constantes et procdures locales de manipulation

const
    _space_ : CHAR = ' ';
    _replace_ : CHAR = '_';

    BUF_SIZE_KO = 16;
    SIZE_OF_BUF_TEXTFILE = BUF_SIZE_KO*1024;

//virer les espaces dans une chane de caractre
function suppr_space(s: string): string;
var p: integer;
    ss: string;
begin
 ss:= s;
 REPEAT
  p:= POS(_space_,ss);
  if (p > 0) then ss[p]:= _replace_;
 UNTIL (p = 0);
 result:= ss;
end;

//***********************************************************

function TOpAssocAPrioriPT.generateFromContinuous(prmFile: string): string;
var i,j: integer;
    F: TextFile;
    att: TAttribute;
    sLine: string;
    tabStr: array of string;
    buf: array[0..pred(SIZE_OF_BUF_TEXTFILE)] of char;//variable locale, limine automatiquement  la sortie
begin
 TRY
 setLength(tabStr,self.Inputs.Count);
 for j:= 0 to pred(self.Inputs.Count) do
  tabStr[j]:= suppr_space(self.Inputs.Attribute[j].Name);
 //
 TRY
 AssignFile(F,prmFile);
 SetTextBuf(F,buf,SIZE_OF_BUF_TEXTFILE); 
 Rewrite(F);
 for i:= 1 to self.WorkData.Examples.Size do
  begin
   sLine:= '';
   for j:= 0 to pred(self.Inputs.Count) do
    begin
     att:= self.Inputs.Attribute[j];
     if (att.cValue[i] > 0)
      then sLine:= sLine + tabStr[j] + ' ';
    end;
   if (length(sLine) > 1)
    then
     begin
       Delete(sLine,length(sLine),1);
       WRITELN(F,sLine);
     end;
  end;
 CloseFile(F);
 result:= prmFile;
 EXCEPT
 result:= '';
 END;

 //
 FINALLY
 Finalize(tabStr);
 END;
end;

function TOpAssocAPrioriPT.generateFromDiscrete(prmFile: string): string;
var i,j,k: integer;
    F: TextFile;
    att: TAttribute;
    sLine: string;
    tabStr: array of TStringList;
    buf: array[0..pred(SIZE_OF_BUF_TEXTFILE)] of char;//variable locale, limine automatiquement  la sortie
begin
 TRY
 //prparer le tableau temporaire de description
 setLength(tabStr,self.Inputs.Count);
 for j:= 0 to pred(self.Inputs.Count) do
  begin
   att:= self.Inputs.Attribute[j];
   tabStr[j]:= TStringList.Create();
   tabStr[j].Add(suppr_space(att.Name));
   for k:= 1 to att.nbValues do
    tabStr[j].Add(suppr_space(att.LstValues.getDescription(k)));
  end;

 //****************************************************************************
 //lancer la sauvegarde
 TRY
 AssignFile(F,prmFile);
 SetTextBuf(F,buf,SIZE_OF_BUF_TEXTFILE);
 Rewrite(F);
 for i:= 1 to self.WorkData.Examples.Size do
  begin
   sLine:= '';
   for j:= 0 to pred(self.Inputs.Count) do
    begin
     att:= self.Inputs.Attribute[j];
     sLine:= sLine + tabStr[j].Strings[0] + '=' + tabStr[j].Strings[att.dValue[self.WorkData.Examples.Number[i]]] + ' ';
    end;
   Delete(sLine,length(sLine),1);
   WRITELN(F,sLine);
  end;
 CloseFile(F);
 result:= prmFile;
 EXCEPT
 result:= '';
 END;
 
 //****************************************************************************
 FINALLY
 for j:= 0 to pred(self.Inputs.Count) do
  tabStr[j].Free();
 Finalize(tabStr);
 END;
end;

function TOpAssocAPrioriPT.generateTmpDataset: string;
var nomFichier: string;
begin
 //crer un nom de fichier temporaire
 nomFichier:= getTmpFileName('dat');
 if (nomFichier <> '')
  then
   begin
    if self.WorkData.LstAtts[asInput].isAllCategory(caDiscrete)
     then nomFichier:= self.generateFromDiscrete(nomFichier)
     else if self.WorkData.LstAtts[asInput].isAllCategory(caContinue)
           then nomFichier:= self.generateFromContinuous(nomFichier)
           //ce cas ne devrait jamais arriver !!!
           else nomfichier:= '';
   end;
 result:= nomFichier;
end;

function TOpAssocAPrioriPT.getClassAssocRule: TClassCalcAssocRule;
begin
 result:= NIL;
end;

function TOpAssocAPrioriPT.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmAssocAPrioriPT;
end;

function TOpAssocAPrioriPT.getHTMLResultsSummary: string;
begin
 result:= Format('Dataset : %s<br>Rules : %s',[FTmpDataset,(PrmOp as TOpPrmAssocAPrioriPT).OutRule]);
end;

function TOpAssocAPrioriPT.getNewForm: TForm;
begin
 result:= TfrmOpViewAssocPrefixTree.CreateFromOperator(self);
end;

{ TOpPrmAssocAPriori }

function TOpPrmAssocAPrioriPT.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmAssociationRulePrefixTree.CreateFromOpPrm(self);
end;

function TOpPrmAssocAPrioriPT.getHTMLParameters: string;
begin
 result:= '';
end;

procedure TOpPrmAssocAPrioriPT.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
  inherited;
  FOutRule:= prmINI.ReadString(prmSection,'rule_base',FOutRule);
end;

procedure TOpPrmAssocAPrioriPT.LoadFromStream(prmStream: TStream);
begin
  inherited;
  loadStringFromStream(FOutRule,prmStream);
end;

procedure TOpPrmAssocAPrioriPT.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
  inherited;
  prmINI.WriteString(prmSection,'rule_base',FOutRule);
end;

procedure TOpPrmAssocAPrioriPT.SaveToStream(prmStream: TStream);
begin
  inherited;
  saveStringToStream(FOutRule,prmStream);
end;

procedure TOpPrmAssocAPrioriPT.SetDefaultParameters;
begin
 inherited;
 FOutRule:= 'output.rul';
end;

initialization
 RegisterClass(TGenCompAssocRulePT);
end.
