(************************************************************************)
(* UCompAssocRuleSupervised.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(************************************************************************)

{
@abstract(Gnration de rgles d'association - Algorithme a priori supervis i.e. il y a une classe  prdire)
@author(Ricco)
@created(26/07/2004)

Reprendre les ides dans CBA et construire des rgles d'association avec une variable  prdire. Cet algo
peut tre gnralis d'ailleurs en choisisant plusieurs variables  mettre dans le consquent, pas forcment
une seule mais pour l'instant on s'en tient  un seul consquent... 26/07/2004
}

unit UCompAssocRuleSupervised;

interface

USES
        Contnrs,
        Forms,Classes,IniFiles,
        UCompDefinition,
        UOperatorDefinition,
        UCompAssociationRuleDefinition,
        UDatasetExamples,
        UCalcAssocStructure,
        UCompAssocRuleAPriori,
        UCompAssocRuleAPrioriMR,
        UDatasetDefinition,
        UDatasetImplementation;


TYPE
        {gnrateur de composant}
        TGenCompAssocRuleSpv = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;
                               end;

        {composant}
        TMLCompAssocRuleSpv = class(TMLCompAssocAPrioriMR)
                              protected
                              function    getClassOperator: TClassOperator; override;
                              end;

        {oprateur}
        TOpAssocRuleSpv = class(TOpAssocAPrioriMR)
                          private
                          {Variable classe}
                          FTarget: TAttribute;
                          {Valeur  prdire de l'attribut Target}
                          FTargetValue: TTypeDiscrete;
                          protected
                          function    getClassParameter: TClassOperatorParameter; override;
                          function    getClassAssocRule(): TClassCalcAssocRule; override;
                          {tester les attributs -- on demande un seul target discret supplmentaire}
                          function    CheckAttributes(): boolean; override;
                          public
                          function    getHTMLRulesDescription(): string; override;
                          function    getTXTRulesDescription(): string; override;
                          property    Target: TAttribute read FTarget;
                          property    TargetValue: TTypeDiscrete read FTargetValue;
                          end;

        {paramtre de l'oprateur -- un nouveau paramtre est demand, la modalit de la variable  prdire  traiter}
        TOpPrmAssocRuleSpv = class(TOpPrmAssocAPrioriMR)
                             private
                             FValueToPredict: string;
                             FBoundary: double; 
                             protected
                             function    CreateDlgParameters(): TForm; override;
                             function    getCoreHTMLParameters(): string; override;
                             function    getCoreTXTParameters(): string; override;
                             public
                             procedure   SetDefaultParameters(); override;
                             procedure   LoadFromStream(prmStream: TStream); override;
                             procedure   SaveToStream(prmStream: TStream); override;
                             procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                             procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                             property    ValueToPredict: string read FValueToPredict write FValueToPredict;
                             property    Boundary: double read FBoundary write FBoundary;
                             end;

        {computerizer}
        TCalcAssocRuleSpv = class(TCalcAssocAPrioriMR)
                            private
                            {Variable classe}
                            FTarget: TAttribute;
                            {Valeur de la classe  prdire}
                            FTargetValue: TTypeDiscrete;
                            {Toutes les rgles avant le tri sur le target}
                            FRulesBeforeTargetFiltering: TLstAssocRules;
                            {nombre d'items dans le input et dans le target}
                            //FNbInputItems, FNbTargetItems: integer;
                            protected
                            {liste des rgles simplifies}
                            FRulesSimplified: TLstAssocRules;
                            {construire les items}
                            procedure   buildItems(prmExamples: TExamples); override;
                            {construire les itemsets de card=2, l'astuce est de n'introduire que les target  ce stade, aprs on fait ce qu'on veut}
                            procedure   buildFrequentItemsetOfCard2(prmExamples: TExamples); override;
                            {classe de calcul des rgles  partir des itemsests}
                            function    getClassCalcRuleFromItemset(): TClassCalcRuleFromItemset; override;
                            {simple filtrage a posteriori pour vrifier les calculs}
                            procedure   buildRulesFromItemset(prmExamples: TExamples; prmClassAssocStructure: TClassAssocRuleStructure); override;
                            {new -- 10/03/2006 -- stratgie de simplification des rgles}
                            procedure   simplifyRules();
                            {tester si sous-rgle}
                            function    isSousRegle(regle,sousRegle: TAssocRuleStructure): boolean;
                            {tester si elle est significativement meilleure que la sous-rgle}
                            function    isSignificant(regle,sousRegle: TAssocRuleStructure): boolean;
                            public
                            constructor create(AssocOperator: TOpAssocRule); override;
                            destructor  destroy(); override;
                            //afficher selon ce qu'on veut, rgles simplifie ou non...
                            function    listingRulesHTML(): string; override;
                            //
                            property    Target: TAttribute read FTarget;
                            end;

        {gnrateur de rgles  partir d'un itemset -- seuls le target doit tre dans le consquent}
        TCalcRuleFromItemsetSpv = class(TCalcRuleFromItemset)
                                  public
                                  procedure    BuildRules(prmItemset: TAssocItemset; prmClassARStructre: TClassAssocRuleStructure); override;
                                  end;


implementation

USES
        Sysutils, Windows, ULogFile, UConstConfiguration,
        UStringAddBuffered, UDlgOpPrmAssocRuleSupervised;

CONST
        STR_CRLF = #13#10;

{ TGenCompAssocRuleSpv }

procedure TGenCompAssocRuleSpv.GenCompInitializations;
begin
 FMLComp:= mlcAssociation;
end;

function TGenCompAssocRuleSpv.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompAssocRuleSpv; 
end;

{ TMLCompAssocRuleSpv }

function TMLCompAssocRuleSpv.getClassOperator: TClassOperator;
begin
 result:= TOpAssocRuleSpv; 
end;

{ TOpAssocRuleSpv }

function TOpAssocRuleSpv.CheckAttributes: boolean;
begin
 result:= FALSE;
 //new -- 05/110/2004 --
 //on revient  la dfinition standard des spcifs ici, tous "inputs" discrets...
 //---------------------
 if ((self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caDiscrete)))
  then
   begin
    //tester le target
    if (self.WorkData.LstAtts[asTarget].Count=1) and (self.WorkData.LstAtts[asTarget].isAllCategory(caDiscrete))
     then
      Begin
       //les inputs
       FInputs:= self.WorkData.LstAtts[asInput];
       //le target
       FTarget:= self.WorkData.LstAtts[asTarget].Attribute[0];
       //reprer la modalit de l'attribut  prdire
       FTargetValue:= FTarget.LstValues.isValueAvailable((self.PrmOp as TOpPrmAssocRuleSpv).ValueToPredict);
       //TRUE si ok il y a qq chose  faire
       result:= (FTargetValue>0);
      End;
   end;
end;

function TOpAssocRuleSpv.getClassAssocRule: TClassCalcAssocRule;
begin
 result:= TCalcAssocRuleSpv; 
end;

function TOpAssocRuleSpv.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmAssocRuleSpv;
end;

function TOpAssocRuleSpv.getHTMLRulesDescription: string;
var tmp: string;
begin
 //mettre les rgles simplifies d'abord
 tmp:= format('<H2>Filtered = %d rules</H2>',[(self.CalcAssocRule as TCalcAssocRuleSpv).FRulesSimplified.Count]);
 tmp:= tmp + self.getHTMLRulesDescription((self.CalcAssocRule as TCalcAssocRuleSpv).FRulesSimplified);
 tmp:= tmp + '<H2>All rules</H2>';
 tmp:= tmp + inherited getHTMLRulesDescription();
 //
 result:= tmp;
end;

function TOpAssocRuleSpv.getTXTRulesDescription: string;
var tmp: string;
begin
 tmp:= format('Filtered = %d rules',[(self.CalcAssocRule as TCalcAssocRuleSpv).FRulesSimplified.Count]) + STR_CRLF;
 tmp:= tmp + self.getTXTRulesDescription((self.CalcAssocRule as TCalcAssocRuleSpv).FRulesSimplified) + STR_CRLF;
 tmp:= tmp + 'All rules' + STR_CRLF;
 tmp:= tmp + inherited getTXTRulesDescription();
 //
 result:= tmp;
end;

{ TCalcAssocRuleSpv }

procedure TCalcAssocRuleSpv.buildFrequentItemsetOfCard2(
  prmExamples: TExamples);
var lstItemsets: TLstAssocItemSet;
    i,j: integer;
    itemset: TAssocItemSet;
    item1,item2: TAssocItem;
begin
 //les items de cardinal 2
 lstItemsets:= FStructureItemsets.AddLstAssocItemset();
 //tester le croisement
 for i:= 0 to FItems.Count-2 do
  begin
   item1:= FItems.Item[i];
   //tester si Target candidat
   if (item1.Attribute = self.Target)
    then
     begin
       for j:= succ(i) to pred(FItems.Count) do
       begin
        item2:= FItems.Item[j];
        //s'assurer que non-target candidat
        if (item2.Attribute<>self.Target)
         then
          begin
            itemset:= TAssocItemSet.Create(item1,item2);
            //faire passer sur les individus et tester si acceptable
            //itemset.computeSupport(prmExamples);
            //avec les bit array, c'est inutile
            if (itemset.Support<FAbsMinSupport)
             then itemset.Free
             else lstItemsets.AddItemSet(itemset);
          end;
       end;
     end;
  end;
end;


procedure TCalcAssocRuleSpv.buildItems(prmExamples: TExamples);
var j: integer;
    att: TAttribute;
begin
 if assigned(FItems)
  then FItems.Free;
 //construire les items
 FItems:= TLstAssocItem.Create();
 //les items de target
 att:= FTarget;
 //FItems.buildItems(att,prmExamples);
 //************************************************************
 //*** new -- 05/08/2004 -- on prcise la valeur de sortie ****
 //*** !!!!! le target est donc forcment DISCRET !!!! ********
 //************************************************************
 FItems.buildValueItem(att,self.FTargetValue,prmExamples);
 //les items de input
 for j:= 0 to pred(FInputs.Count) do
  begin
   att:= FInputs.Attribute[j];
   FItems.buildItems(att,prmExamples);
  end;
 //filtrer les items sans procder  un tri pour viter les confusions et respecter l'ordre des variables
 FItems.FilterItemsOnSupportNoSort(FAbsMinSupport);
end;

procedure TCalcAssocRuleSpv.buildRulesFromItemset(prmExamples: TExamples;
  prmClassAssocStructure: TClassAssocRuleStructure);
var k,i: integer;
    rule: TAssocRuleStructure;
    item: TAssocItem;
    tps: cardinal;
begin
 inherited buildRulesFromItemset(prmExamples,prmClassAssocStructure);
 tps:= GetTickCount();
 {trier les rgles selon le nombre d'items dans l'antcdent, et en cas d'ex-aequo selon le lift -- 26/07/2004}
 FRules.SortRulesOn(RuleCompareOnNbAnteItemsAndLift);
 {puis un second filtrage sur le target -- trs lent pour l'instant mais on n'a pas mieux...}
 //copier les rgles
 self.FRulesBeforeTargetFiltering.copy(FRules);
 //changement de propitaire
 FRules.setOwner(FALSE);
 FRules.clear();
 //passer les rgles dans l'ordre de la target -- pas terrible comme stratgie mais a reste linaire en nombre de rgles
 //for k:= 1 to self.Target.nbValues do
 //new -- 01/12/2004 -- un seul item candidat pour le consquent -- choisi en paramtre
 for k:= self.FTargetValue to self.FTargetValue do
  begin
   for i:= 0 to pred(self.FRulesBeforeTargetFiltering.count) do
    begin
     rule:= self.FRulesBeforeTargetFiltering.getRule(i);
     //tester si la condition est de cardinal 1
     if (rule.Consequent.Count=1)
      then
       begin
        //tester s'il s'agit bien de la conclusion-target
        item:= rule.Consequent.Items[0] as TAssocItem;
        if (item.Attribute = self.Target) and (item.Value = k)
         then FRules.addRule(rule);
       end;
     end;
  end;
 tps:= GetTickCount()-tps;
 TraceLog.WriteToLogFile(format('[SUPERVISED ASSOC RULE] :: dure filtrage a posteriori des rgles sur target et nombre items = %d ms. (%d rgles)',[tps,FRules.Count]));
 //new -- 10/03/2006 -- introduction de la simplification des rgles
 tps:= GetTickCount();
 self.simplifyRules();
 TraceLog.WriteToLogFile(format('[SUPERVISED ASSOC RULE] :: dure simplification, de %d rules to %d rules = %d ms.',[FRules.Count,FRulesSimplified.Count,getTickCount()-tps]));
end;

constructor TCalcAssocRuleSpv.create(AssocOperator: TOpAssocRule);
begin
 inherited Create(AssocOperator);
 FTarget:= (AssocOperator as TOpAssocRuleSpv).Target;
 FTargetValue:= (AssocOperator as TOpAssocRuleSpv).TargetValue;
 FRulesBeforeTargetFiltering:= TLstAssocRules.create(TRUE);
 FRulesSimplified:= TLstAssocRules.create(FALSE); 
end;

destructor TCalcAssocRuleSpv.destroy;
begin
 if assigned(FRulesSimplified)
  then FRulesSimplified.Free();
 if assigned(FRulesBeforeTargetFiltering)
  then FRulesBeforeTargetFiltering.Free();
 inherited destroy();
end;

function TCalcAssocRuleSpv.getClassCalcRuleFromItemset: TClassCalcRuleFromItemset;
begin
 result:= TCalcRuleFromItemsetSpv;
end;

{ TCalcRuleFromItemsetSpv }

//new -- 26/07/2004
//!\\  ce stade, on est sr que si l'itemset est prsent, c'est que le premier item est forcment un item de la TARGET
//!\\ on court-cirtcuite l'appel  GENERATE RULES, en effet il n'est pas ncessaire d'explorer en profondeur les solutions
procedure TCalcRuleFromItemsetSpv.BuildRules(prmItemset: TAssocItemset;
  prmClassARStructre: TClassAssocRuleStructure);
var item: TAssocItem;
    k,iTarget: integer;
    curConf: double;
    rule: TAssocRuleStructure;
    nbAnte,nbCons: integer;
begin
 self.Initialize(prmItemset);
 //portage simplifi de GenerateRules directement  ce niveau i.e. dans la procdure appellante
 //enlever i (du target) de l'antcdent pour l'ajouter dans le consquent
 //il faut le chercher ???
 (*
 iTarget:= -1;
 for i:= 0 to pred(FCurItemset.card) do
  begin
   item:= FCurItemset.getItem(i);
   //test
   if (item.Attribute = (self.FCalcAssoc as TCalcAssocRuleSpv).Target)
    then
     begin
      iTarget:= i;
      BREAK;
     end;
  end;
 *)
 //non... a priori ... si l'itemset est prsent c'est qu'il est frquent ET target est prsent en position 0 ...
 iTarget:= 0;
 //zoo..
 if (iTarget>=0)
  then
   begin
     //prciser la target
     FItemInConsequent.Value[iTarget]:= TRUE;
     //comptage
     FBitCons.SetAllTrue;
     FBitAnte.SetAllTrue;
     nbAnte:= 0;
     nbCons:= 0;
     for k:= 0 to pred(FCurItemset.card) do
      begin
       item:= FCurItemset.getItem(k);
       if FItemInConsequent.Value[k]
        then
         begin
          FBitCons.AndArray(item.BoolArray);
          inc(nbAnte);
         end
        else
         begin
          FBitAnte.AndArray(item.BoolArray);
          inc(nbCons);
         end;
      end;
     //si la rgle est valable
     if (nbAnte>0) and (nbCons>0)
      then
       begin
         //valuer la confiance de la rgle forme
         FBitCons.RefreshCount;
         FBitAnte.RefreshCount;
         curConf:= 1.0*FCurItemset.Support/(1.0*FBitAnte.Count);
         //tester si ok
         if (curConf>FMinConfiance)
          then
           //on valide la rgle et on explore en profondeur
           begin
            //rule:= TAssocRuleStructure.Create(self);
            //rendre la chose paramtrable -- 23/05/2004
            rule:= prmClassARStructre.Create(self);
            ///suite std.
            FLstRules.Add(rule);
           end;
       end;
     //on dsinitialise la slection
     FItemInConsequent.Value[iTarget]:= FALSE;
  end;
end;

{comparaison sur le n de items et le nombre d'items dans l'antcdent -- une sorte d'ordre lexicographique}
//>> marche pas pour l'instant le tri de la rgle, on laisse tomber...
(*
function RuleCompareOnAntecedentDecrease(item1, item2: Pointer): integer;
var p1, p2: TAssocRuleStructure;
    curItem, comparison: integer;
    num_1,num_2: integer;
    len_1,len_2: integer;
begin
 p1:= TAssocRuleStructure(item1);
 p2:= TAssocRuleStructure(item2);
 curItem:= 0;
 comparison:= 0;
 //tant que la dcision n'est pas prise
 while (curItem < p1.getCountAntecedent()) and (curItem < p2.getCountAntecedent()) and (comparison = 0) do
  begin
   num_1:= p1.getAntecedentItem(curItem).Numero;
   num_2:= p2.getAntecedentItem(curItem).Numero;
   if ( num_1 < num_2)
    then comparison:= -1
    else
     begin
      if (num_1 > num_2)
       then comparison:= +1;
     end;
   //passage  l'item suivant
   inc(curItem);
  end;
 //tester les longueurs si pas de dcision prise... (la plus courte doit arriver devant puisque son numro est zro)
 if (comparison = 0)
  then
   begin
    len_1:= p1.getCountAntecedent();
    len_2:= p2.getCountAntecedent();
    if (len_1 < len_2)
     then comparison:= -1
     else comparison:= +1;
   end;
 //
 result:= comparison;
end;
*)

function TCalcAssocRuleSpv.isSignificant(regle,sousRegle: TAssocRuleStructure): boolean;
var m,v: double;
    nac,na,nc,n: double;
    vt: double;
    //coefficient de rduction pour revenir  100
    coef: double;
begin
 //calculer le VT de comparaison, avec la formule approche
 //rcuprer les infos -- tout est relatif  la sous-rgle !!!
 n:= (sousRegle as TAssocRuleStructureMR).appInfos.nA;
 nc:= (sousRegle as TAssocRuleStructureMR).appInfos.nAC;
 na:= (regle as TAssocRuleStructureMR).appInfos.nA;
 nac:= (regle as TAssocRuleStructureMR).appInfos.nAC;

 //ramener les chiffres  100
 if (n > 100.0)
  then
   begin
    coef:= 100.0 / n;
    n:= 100.0;
    nc:= coef * nc;
    na:= coef * na;
    nac:= coef * nac;
   end;

 //calculs
 m := (na * nc) / n;
 v := na * ((n - na) / (n - 1)) * (nc / n) * (1.0 - nc / n);

 //valeur test approche
 if (v > 0.0)
  then vt:= (nac - m) / sqrt(v)
  else vt:= 0.0;

 //tester si significant
 result:= (vt > (self.prmAssocRule as TOpPrmAssocRuleSpv).Boundary);
end;

function TCalcAssocRuleSpv.isSousRegle(regle,
  sousRegle: TAssocRuleStructure): boolean;
var i,j: integer;
    numItem: integer;
    ok,itemFound: boolean;
begin
 //si elle est pas plus courte, laisse tomber
 if (sousRegle.getCountAntecedent() >= regle.getCountAntecedent())
  then result:= false
  else
   begin
    //vrifier que tous ses items sont prsents
    ok:= true;
    for i:= 0 to pred(sousRegle.getCountAntecedent()) do
     begin
      numItem:= sousRegle.getAntecedentItem(i).Numero;
      itemFound:= false;
      for j:= 0 to pred(regle.getCountAntecedent()) do
       begin
        if (regle.getAntecedentItem(j).Numero = numItem)
         then itemFound:= true;
       end;
      ok:= ok and itemFound;
     end;
    result:= ok;
   end;
end;

function TCalcAssocRuleSpv.listingRulesHTML: string;
begin
 //result:= FRulesSimplified.DescriptionHTML();
 result:= '';
end;

procedure TCalcAssocRuleSpv.simplifyRules;
var i,j: integer;
    rule,ruleTest: TAssocRuleStructureMR;
    ok_rule: boolean;
begin
 //trs simplement, vrifier pour chaque rgle qu'il domine toutes ses sous-rgles
 //on part du dernier parce qu'ils sont tris par ordre de longueur croissante
 for i:= pred(FRules.count) downto 0 do
  begin
   rule:= FRules.getRule(i) as TAssocRuleStructureMR;
   //dans toute la liste, vrifier que RULE a des sous-rgles et qu'elle est systmatiquement significativement meilleure
   //comme on n'est pas trs sr de notre tri, on teste tout le monde
   ok_rule:= true;
   for j:= pred(FRules.count) downto 0 do
    begin
     if (j<>i)
      then
       begin
        ruleTest:= FRules.getRule(j) as TAssocRuleStructureMR;
        {$B-}
        if isSousRegle(rule,ruleTest) and not(isSignificant(rule,ruleTest))
         then
          begin
           ok_rule:= false;
           BREAK;
          end;
       end;
    end;
   //si RULE domine toutes ses sous-rgles, elle est OK
   //il suffit d'un cas de non-domination et la rgle est limine
   if ok_rule
    then FRulesSimplified.addRule(rule);
  end;
end;

{ TOpPrmAssocRuleSpv }

function TOpPrmAssocRuleSpv.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmAssociationRuleSpv.CreateFromOpPrm(self);
end;

function TOpPrmAssocRuleSpv.getCoreHTMLParameters: string;
begin
 result:= inherited getCoreHTMLParameters()+
          HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Value to predict</TD><TD align="right">%s</TD></TR>',[FValueToPredict]);
end;

function TOpPrmAssocRuleSpv.getCoreTXTParameters: string;
begin
 result:= inherited getCoreTXTParameters()+
          format('Value to predict;%s',[FValueToPredict])+STR_CRLF;
end;

procedure TOpPrmAssocRuleSpv.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
  inherited;
  FValueToPredict:= prmINI.ReadString(prmSection,'value_to_predict',FValueToPredict);
  FBoundary:= prmINI.ReadFloat(prmSection,'boundary',FBoundary);
end;

procedure TOpPrmAssocRuleSpv.LoadFromStream(prmStream: TStream);
begin
  inherited;
  loadStringFromStream(FValueToPredict,prmStream);
  prmStream.ReadBuffer(FBoundary,sizeof(FBoundary));
end;

procedure TOpPrmAssocRuleSpv.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
  inherited;
  prmINI.WriteString(prmSection,'value_to_predict',FValueToPredict);
  prmINI.WriteFloat(prmSection,'boundary',FBoundary);
end;

procedure TOpPrmAssocRuleSpv.SaveToStream(prmStream: TStream);
begin
  inherited;
  saveStringToStream(FValueToPredict,prmStream);
  prmStream.WriteBuffer(FBoundary,sizeof(FBoundary));
end;

procedure TOpPrmAssocRuleSpv.SetDefaultParameters;
begin
  inherited;
  FValueToPredict:= '';
  FBoundary:= 2.0;
end;

initialization
 Classes.RegisterClass(TGenCompAssocRuleSpv);
end.
