(************************************************************************)
(* UDlgOpPrmAssociationRule.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(************************************************************************)

unit UDlgOpPrmAssociationRule;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, LMDCustomControl, LMDCustomPanel, LMDCustomBevelPanel,
  LMDBaseEdit, LMDCustomEdit, LMDCustomMaskEdit, LMDMaskEdit, lmdstdcA;

type
  TDlgOpPrmAssociationRule = class(TDlgBaseOperatorParameter)
    label1: TLabel;
    edSupport: TLMDMaskEdit;
    edConfidence: TLMDMaskEdit;
    spinRuleCard: TLMDSpinEdit;
    edLift: TLMDMaskEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
  private
    { Dclarations prives }
  public
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;
  end;

var
  DlgOpPrmAssociationRule: TDlgOpPrmAssociationRule;

implementation

uses UCompAssociationRuleDefinition;

{$R *.dfm}

{ TDlgOpPrmAssociationRule }

procedure TDlgOpPrmAssociationRule.ApplyModifications;
var prm: TOpPrmAssocRule;
begin
 prm:= OpPrm as TOpPrmAssocRule;
 prm.MinSupport:= strtofloat(self.edSupport.Text);
 prm.MinConfidence:= strtofloat(self.edConfidence.Text);
 prm.MaxRuleLength:= self.spinRuleCard.Value;
 prm.MinLift:= strtofloat(self.edLift.Text);
end;

procedure TDlgOpPrmAssociationRule.SetParameters;
var prm: TOpPrmAssocRule;
begin
 prm:= OpPrm as TOpPrmAssocRule;
 self.edSupport.Text:= floattostr(prm.MinSupport);
 self.edConfidence.Text:= floattostr(prm.MinConfidence);
 self.spinRuleCard.Value:= prm.MaxRuleLength;
 self.edLift.Text:= floattostr(prm.MinLift);
end;

end.
