unit UFrmOpViewAssocRulePrefixTree;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBaseOperator, Menus, ActnList, ComCtrls, ExtCtrls, StdCtrls,
  UCompAssocRulePrefixTreeCB, Contnrs, VirtualTrees;

type
  TfrmOpViewAssocPrefixTree = class(TFrmBaseOperator)
    tabRules: TTabSheet;
    memoConsole: TMemo;
    Splitter1: TSplitter;
    Panel1: TPanel;
    PanelVTView: TPanel;
    Panel3: TPanel;
    panelRules: TPanel;
    procedure FormDestroy(Sender: TObject);
  private
    { Dclarations prives }
    OpAssoc: TOpAssocAPrioriPT;
    lstRules: TObjectList;
    vtView: TVirtualDrawTree;
    minLift, maxLift,rangeLift: single;
    procedure readRules(Sender: TObject; ExitCode: LongWord);
    procedure parseRules(prmFile: string);
    procedure prepareVirtualTreeView();
    procedure vtPaint(Sender: TBaseVirtualTree;
    TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
    CellRect: TRect);
    procedure vtHeaderClick(Sender: TVTHeader; Column: TColumnIndex; Button: TMouseButton; Shift: TShiftState; X,
    Y: Integer);
  public
    { Dclarations publiques }
    procedure   PrepareView(); override;
  end;

var
  frmOpViewAssocPrefixTree: TfrmOpViewAssocPrefixTree;

implementation

{$R *.dfm}

uses
    DosCommand, Math, ULogFile;

//structure de rgles
TYPE
    TRule = class
            number: integer;
            antecedent: string;
            consequent: string;
            support: single;
            confidence: single;
            lift: single;
            constructor create(description: string; num: integer);
            end;

{ TRule }

constructor TRule.create(description: string; num: integer);
var p: integer;
    s: string;
    err: integer;
    value: string;
begin
 inherited Create();
 // numro
 number:= num;
 s:= description;
 //consequent
 p:= pos('<-',s);
 consequent:= copy(s,1,p-1);
 delete(s,1,p+1);
 //antecedent
 p:= pos('(',s);
 antecedent:= copy(s,1,p-1);
 delete(s,1,p);
 TRY
 p:= pos(',',s);
 value:= copy(s,1,p-1);
 val(value,support,err);
 delete(s,1,p);
 p:= pos(',',s);
 value:= copy(s,1,p-1);
 val(value,confidence,err);
 delete(s,1,p);
 p:= pos(')',s);
 value:= copy(s,1,p-1);
 val(value,lift,err);
 EXCEPT
 END;
end;

//**********************************
//critres de comparaison des rgles

function SortOnNumber(Item1, Item2: Pointer): Integer;
begin
 if (TRule(Item1).number > TRule(Item2).number)
  then result:= +1
  else if (TRule(Item1).number < TRule(Item2).number)
       then result:= -1
       else result:= 0;
end;

function SortOnAntecedent(Item1, Item2: Pointer): Integer;
begin
 if (TRule(Item1).antecedent > TRule(Item2).antecedent)
  then result:= +1
  else if (TRule(Item1).antecedent < TRule(Item2).antecedent)
       then result:= -1
       else result:= 0;
end;

function SortOnConsequent(Item1, Item2: Pointer): Integer;
begin
 if (TRule(Item1).consequent > TRule(Item2).consequent)
  then result:= +1
  else if (TRule(Item1).consequent < TRule(Item2).consequent)
       then result:= -1
       else result:= 0;
end;

function SortOnSupport(Item1, Item2: Pointer): Integer;
begin
 if (TRule(Item1).support > TRule(Item2).support)
  then result:= -1
  else if (TRule(Item1).support < TRule(Item2).support)
       then result:= +1
       else result:= 0;
end;

function SortOnConfidence(Item1, Item2: Pointer): Integer;
begin
 if (TRule(Item1).confidence > TRule(Item2).confidence)
  then result:= -1
  else if (TRule(Item1).confidence < TRule(Item2).confidence)
       then result:= +1
       else result:= 0;
end;

function SortOnLift(Item1, Item2: Pointer): Integer;
begin
 if (TRule(Item1).lift > TRule(Item2).lift)
  then result:= -1
  else if (TRule(Item1).lift < TRule(Item2).lift)
       then result:= +1
       else result:= 0;
end;
//**********************************




procedure TfrmOpViewAssocPrefixTree.parseRules(prmFile: string);
var F: TextFile;
    sLine: string;
    rule: TRule;
begin
 //vider la liste actuelle, si elle existe
 lstRules.Clear();
 minLift:= Math.MaxSingle;
 maxLift:= -1.0*Math.MaxSingle;
 TRY
 //lire les rgles
 AssignFile(F,prmFile);
 Reset(F);
 while not(eof(f)) do
  begin
   readln(F,sLine);
   //crer la rgle
   rule:= TRule.create(sLine,succ(lstRules.Count));
   //ajouter dans la liste
   lstRules.Add(rule);
   //trouver les bornes
   if (rule.lift < minLift) then minLift:= rule.lift;
   if (rule.lift > maxLift) then maxLift:= rule.lift;
  end;
 rangeLift:= maxLift - minLift;
 TraceLog.WriteToLogFile(format('[A PRIORI Prefix Tree] LIFT (min = %.1f ; max = %.1f)',[minLift,maxLift]));
 FINALLY
 CloseFile(F);
 END;
 //affichage
 self.panelRules.Caption:= format('Rules [#%d association rules loaded]',[lstRules.Count]);
 //synchroniser la treeview avec la liste
 //plus simplement, en une seul fois
 vtView.RootNodeCount:= lstRules.Count;
end;

procedure TfrmOpViewAssocPrefixTree.PrepareView;
begin
 inherited;
 //liste des rgles
 lstRules:= TObjectList.Create(TRUE);
 //prparer le virtual treeview
 self.prepareVirtualTreeView();
 //se brancher sur l'oprateur
 OpAssoc:= Operator as TOpAssocAPrioriPT;
 //vrifier s'il a dj t excut ou pas...
 if assigned(OpAssoc) and (OpAssoc.DosCommand.ThreadStatus <> dtsSuccess)
  then
   begin
    //alors brancher les derniers lments
    OpAssoc.DosCommand.OnTerminated:= readRules;
    OpAssoc.DosCommand.OutputLines:= self.memoConsole.Lines;
    //lancer rellement l'excution
    OpAssoc.DosCommand.Execute();
   end
  else readRules(NIL,0);
end;

procedure TfrmOpViewAssocPrefixTree.readRules(Sender: TObject;
  ExitCode: LongWord);
var sRules: string;
begin
 if assigned(OpAssoc)
  then
   begin
     sRules:= (OpAssoc.PrmOp as TOpPrmAssocAPrioriPT).OutRule;
     if FileExists(sRules)
      then self.parseRules(sRules)
      else self.PanelRules.Caption:= 'Rules [-- NO RULES --]';
   end
  else self.PanelRules.Caption:= 'Rules [-- NO CURRENT OPERATOR AVAILABLE --]';
end;

procedure TfrmOpViewAssocPrefixTree.FormDestroy(Sender: TObject);
begin
 lstRules.Free();
 inherited;
end;

procedure TfrmOpViewAssocPrefixTree.prepareVirtualTreeView;
var vtc: TVirtualTreeColumn;
begin
 //crer
 vtView:= TVirtualDrawTree.Create(panelVTView);
 vtView.Parent:= panelVTView;
 vtView.Align:= alClient;
 //brancher les gestionnaires d'vnements 
 vtView.OnAfterCellPaint:= self.vtPaint;
 vtView.OnHeaderClick:= self.vtHeaderClick;
 //configurer, crer les colonnes
 vtc:= vtView.Header.Columns.Add();
 vtc.Text:= 'N';
 vtc.Width:= 30;
 vtc:= vtView.Header.Columns.Add();
 vtc.Text:= 'Antecedent';
 vtc.Width:= 350;
 vtc:= vtView.Header.Columns.Add();
 vtc.Text:= 'Consequent';
 vtc.Width:= 150;
 vtc:= vtView.Header.Columns.Add();
 vtc.Text:= 'Support';
 vtc:= vtView.Header.Columns.Add();
 vtc.Text:= 'Confidence';
 vtc:= vtView.Header.Columns.Add();
 vtc.Text:= 'Lift';
 vtView.Header.Options:= vtView.Header.Options + [hoVisible];
 //options d'affichage
 vtView.TreeOptions.PaintOptions:= vtView.TreeOptions.PaintOptions - [toShowTreeLines] + [toShowHorzGridLines];
 vtView.TreeOptions.SelectionOptions:= vtView.TreeOptions.SelectionOptions + [toFullRowSelect];
 vtView.Colors.FocusedSelectionBorderColor:= clInactiveCaptionText;
 vtView.Colors.FocusedSelectionColor:= clInfoBk;
end;

procedure TfrmOpViewAssocPrefixTree.vtPaint(Sender: TBaseVirtualTree;
  TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
  CellRect: TRect);
const couleur : array[3..5] of TColor = (clMoneyGreen,clSkyBlue,$0089CFF7);
var rule: TRule;
    fullWidth, width, height: integer;
    value: single;
begin
 if assigned(lstRules)
  then
   begin
    if (Node.Index < cardinal(lstRules.Count))
     then
      begin
       rule:= lstRules.Items[Node.Index] as TRule;
       TargetCanvas.Font.Color:= clBlack;
       case Column of
       0: TargetCanvas.TextOut(CellRect.Left+2,CellRect.Top+3,inttostr(rule.number));
       1: TargetCanvas.TextOut(CellRect.Left+2,CellRect.Top+3,rule.antecedent);
       2: TargetCanvas.TextOut(CellRect.Left+2,CellRect.Top+3,rule.consequent);
       3,4,5 : begin
                case Column of
                3: value:= rule.support;
                4: value:= rule.confidence
                else
                  begin
                    if (rangeLift > 0)
                     then value:= 100.0*(rule.lift - minLift)/rangeLift
                     else value:= 0.0;
                  end
                end;
                fullWidth:= CellRect.Right - CellRect.Left - 2;
                width:= TRUNC(1.0*value*fullWidth/100.0);
                height:= CellRect.Bottom - CellRect.Top - 2;
                TargetCanvas.Brush.Style:= bsSolid;
                TargetCanvas.Brush.Color:= couleur[Column];
                TargetCanvas.Pen.Color:= couleur[Column];
                TargetCanvas.Rectangle(CellRect.Left+1,CellRect.Top+1,CellRect.Left+1+width,CellRect.Top+1+height);
                TargetCanvas.Brush.Style:= bsClear;
                //remettre la vraie valeur du lift si c'est la colonne 5
                if (Column <5)
                 then TargetCanvas.TextOut(CellRect.Left+2,CellRect.Top+3,format('%.1f',[value]))
                 else TargetCanvas.TextOut(CellRect.Left+2,CellRect.Top+3,format('%.1f',[rule.lift]))
               end;
       end;
      end;
   end;
end;

procedure TfrmOpViewAssocPrefixTree.vtHeaderClick(Sender: TVTHeader;
  Column: TColumnIndex; Button: TMouseButton; Shift: TShiftState; X,
  Y: Integer);
begin
 case column of
 1: lstRules.Sort(sortOnAntecedent);
 2: lstRules.Sort(sortOnConsequent);
 3: lstRules.Sort(sortOnSupport);
 4: lstRules.Sort(sortOnConfidence);
 5: lstRules.Sort(sortOnLift)
 else lstRules.Sort(sortOnNumber);
 end;
 //mj l'affichage, bien videmment
 self.vtView.Refresh();
end;

end.
