(****************************************************************)
(* UDlgOpClusKMeans.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(****************************************************************)

unit UDlgOpClusKMeans;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, StdCtrls, CheckLst, ComCtrls,
  ExtCtrls, lmdstdcA;

type
  TDlgOpPrmClusKMeans = class(TDlgBaseOperatorParameter)
    Label1: TLabel;
    spinNbClusters: TLMDSpinEdit;
    rgDistNormalize: TRadioGroup;
    rgAvgComputation: TRadioGroup;
    Label2: TLabel;
    spinMaxIterations: TLMDSpinEdit;
    Label3: TLabel;
    spinTrials: TLMDSpinEdit;
    rgSeedRnd: TRadioGroup;
  private
  public
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;
  end;

var
  DlgOpPrmClusKMeans: TDlgOpPrmClusKMeans;

implementation

uses UCompClusteringKMeans, UCalcRndGenerator;

{$R *.dfm}

{ TDlgOpPrmClusKMeans }

procedure TDlgOpPrmClusKMeans.ApplyModifications;
var prm: TOpPrmClusKMeans;
begin
 prm:= OpPrm as TOpPrmClusKMeans;
 prm.NbClusters:= spinNbClusters.Value;
 prm.MaxIter:= spinMaxIterations.Value;
 prm.NbTrials:= spinTrials.Value;
 prm.Normalization:= rgDistNormalize.ItemIndex;
 prm.AvgComputation:= rgAvgComputation.ItemIndex;
 prm.ModeRndGenerator:= TStartSeed(rgSeedRnd.ItemIndex);
end;

procedure TDlgOpPrmClusKMeans.SetParameters;
var prm: TOpPrmClusKMeans;
begin
 prm:= OpPrm as TOpPrmClusKMeans;
 spinNbClusters.Value:= prm.NbClusters;
 spinMaxIterations.Value:= prm.MaxIter;
 spinTrials.Value:= prm.NbTrials;
 rgDistNormalize.ItemIndex:= prm.Normalization;
 rgAvgComputation.ItemIndex:= prm.AvgComputation;
 rgSeedRnd.ItemIndex:= ord(prm.ModeRndGenerator);
end;

end.
