unit UDlgOpPrmClusteringRNG;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls,
  lmdstdcA;

type
  TdlgOpPrmClusteringNG = class(TDlgBaseOperatorParameter)
    Label1: TLabel;
    spinMinClusSize: TLMDSpinEdit;
    Label2: TLabel;
    cmbPositiveClass: TComboBox;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;        
  end;

var
  dlgOpPrmClusteringNG: TdlgOpPrmClusteringNG;

implementation

uses UCompClusteringNG, UDatasetDefinition, UDatasetImplementation,
  UCompManageDataset;

{$R *.dfm}

{ TdlgOpPrmClusteringRNG }

procedure TdlgOpPrmClusteringNG.ApplyModifications;
begin
 if (cmbPositiveClass.ItemIndex >= 0)
  then (self.OpPrm as TOpPrmNG).PositiveClass := cmbPositiveClass.Items.Strings[cmbPositiveClass.ItemIndex]
  else (self.OpPrm as TOpPrmNG).PositiveClass := '';
end;

procedure TdlgOpPrmClusteringNG.SetParameters;
var att: TAttDiscrete;
    i: TTypeDiscrete;
    prm: TOpPrmNG;
begin
 prm:= self.OpPrm as TOpPrmNG;
 //lister les valeurs dispos de la target
 self.cmbPositiveClass.Items.Clear();
 //y a-t-il un target dj ?
 if ((self.OpPrm.Operator as TOpLocalData).WorkData.LstAtts[asTarget].Count=1) and ((self.OpPrm.Operator as TOpLocalData).WorkData.LstAtts[asTarget].isAllCategory(caDiscrete))
  then
   begin
    att:= (self.OpPrm.Operator as TOpLocalData).WorkData.LstAtts[asTarget].Attribute[0] as TAttDiscrete;
    //charger
    for i:= 1 to att.nbValues do
     cmbPositiveClass.Items.Add(att.LstValues.getDescription(i));
    //activer le bon
    cmbPositiveClass.ItemIndex:= pred(att.LstValues.isValueAvailable(prm.PositiveClass));
   end;
end;

end.
