unit UDlgOpPrmClusteringTree;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgBaseOperatorParameter, ComCtrls, StdCtrls, ExtCtrls,
  lmdstdcA;

type
  TdlgOpPrmClusteringTree = class(TDlgBaseOperatorParameter)
    tabSize: TTabSheet;
    tabPrePruning: TTabSheet;
    Label1: TLabel;
    cmbRnd: TComboBox;
    Label2: TLabel;
    cmbDistanceNorm: TComboBox;
    Label3: TLabel;
    spinMinSizeToSplit: TLMDSpinEdit;
    Label4: TLabel;
    spinMinSizeLeaves: TLMDSpinEdit;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    edGoodnessThreshold: TEdit;
    spinMaxDepth: TLMDSpinEdit;
    spinMaxClusters: TLMDSpinEdit;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;
  end;

var
  dlgOpPrmClusteringTree: TdlgOpPrmClusteringTree;

implementation

uses UCompClusteringTree,UCalcRndGenerator;

{$R *.dfm}

{ TdlgOpPrmClusteringTree }

procedure TdlgOpPrmClusteringTree.ApplyModifications;
var prm: TOpPrmClusTree;
begin
 prm:= OpPrm as TOpPrmClusTree;
 //
 prm.ModeRndGenerator:= TStartSeed(self.cmbRnd.ItemIndex);
 prm.Normalization:= self.cmbDistanceNorm.ItemIndex;
 prm.SizeBeforeSplit:= self.spinMinSizeToSplit.Value;
 prm.LeavesSizeAfterSplit:= self.spinMinSizeLeaves.Value;
 prm.MaxDepth:= self.spinMaxDepth.Value;
 prm.MaxNbClusters:= self.spinMaxClusters.Value;
 prm.GoodnessThreshold:= StrToFloat(self.edGoodnessThreshold.Text);
end;

procedure TdlgOpPrmClusteringTree.SetParameters;
var prm: TOpPrmClusTree;
begin
 prm:= OpPrm as TOpPrmClusTree;
 //
 self.cmbRnd.ItemIndex:= ord(prm.ModeRndGenerator);
 self.cmbDistanceNorm.ItemIndex:= prm.Normalization;
 self.spinMinSizeToSplit.Value:= prm.SizeBeforeSplit;
 self.spinMinSizeLeaves.Value:= prm.LeavesSizeAfterSplit;
 self.spinMaxDepth.Value:= prm.MaxDepth;
 self.spinMaxClusters.Value:= prm.MaxNbClusters;
 self.edGoodnessThreshold.Text:= Format('%.2f',[prm.GoodnessThreshold]);
end;

end.
