unit UDlgOpPrmClusteringTreeCART;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDlgOpPrmClusteringTree, StdCtrls, lmdstdcA, ComCtrls, ExtCtrls;

type
  TdlgOpPrmClusteringTreeCART = class(TdlgOpPrmClusteringTree)
    TabSheet1: TTabSheet;
    Label8: TLabel;
    Label9: TLabel;
    edSlopeCut: TEdit;
    chkShowAllSequences: TCheckBox;
    spinPruningSetSize: TLMDSpinEdit;
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure   ApplyModifications(); override;
    procedure   SetParameters(); override;
  end;

var
  dlgOpPrmClusteringTreeCART: TdlgOpPrmClusteringTreeCART;

implementation

uses UCompClusteringTreeCART;

{$R *.dfm}

{ TdlgOpPrmClusteringTreeCART }

procedure TdlgOpPrmClusteringTreeCART.ApplyModifications;
var prm: TOpPrmClusTreeCART;
begin
 inherited;
 prm:= OpPrm as TOpPrmClusTreeCART;
 prm.PruningSetSize:= self.spinPruningSetSize.Value;
 prm.ThresholdSlope:= StrToFloat(self.edSlopeCut.Text);
 prm.ShowAllTreeSeq:= self.chkShowAllSequences.Checked;
end;

procedure TdlgOpPrmClusteringTreeCART.SetParameters;
var prm: TOpPrmClusTreeCART;
begin
 inherited;
 prm:= OpPrm as TOpPrmClusTreeCART;
 self.spinPruningSetSize.Value:= prm.PruningSetSize;
 self.edSlopeCut.Text:= Format('%.3f',[prm.ThresholdSlope]);
 self.chkShowAllSequences.Checked:= prm.ShowAllTreeSeq;
end;

end.
