(************************************************************)
(* UCompDataset.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(************************************************************)

{
@abstract(Composant connexion aux donnes)
@author(Ricco)
@created(12/01/2004)
Le premier composant du diagramme, directement connect aux donnes. Il est plac par programme, il
n'apparat donc pas dans la palette de composants, il n' pas besoin de gnrateur donc.
}
unit UCompDataset;

interface

USES
        Forms, Classes,
        UOperatorDefinition,
        UCompDefinition,
        UCompManageDataset,
        UDatasetDefinition;

TYPE
        {Composant ensemble de donnes}
        TMLCompDataset = class(TMLCompLocalData)
                         private
                         FDatabaseName: string;
                         protected
                         {pas de rcupration ici justement}
                         procedure   getInfosGenerator(prmGen: TMLGenComp); override;
                         {la classe d'oprateur}
                         function    getClassOperator: TClassOperator; override;
                         {trs particulier ici puisque les donnes sont passs}
                         procedure  InitializeDataset(); override;
                         {connecter  la base de donnes}
                         procedure   InsertIntoDiagram(prmDiagram: TMLDiagram; prmPred: TMLComponent); override;
                         {rien ici pour le rahrachissement, ralis  la cration}
                         procedure   RefreshOutput(); override;
                         public
                         {compltement vide ici l'excution qui est ralise au dpart}
                         function  Execute(prmForce: boolean): boolean; override;                         
                         {connecter  l'ensemble de donnes initial}
                         procedure   ConnectToDatabase(prmLst: TLstAttributes);
                         {drfrencer tout simplement FLocalDataset}
                         destructor  Destroy; override;
                         {son nom de section est standard -> 'Dataset'}
                         function    sectionINI(): string; override;
                         {nom de la base}
                         property    DatabaseName: string read FDatabaseName;
                         end;

        {Oprateur ensemble de donnes}
        TOpDataset = class(TOperator)
                     protected
                     function    getClassParameter: TClassOperatorParameter; override;
                     public
                     constructor Create(AOwner: TObject); override;
                     function    getHTMLResultsSummary(): string; override;
                     end;

        {Paramtrage de l'oprateur}
        TOpPrmDataset = class(TOperatorParameter)
                        protected
                        procedure   SetDefaultParameters(); override;
                        function    CreateDlgParameters(): TForm; override;
                        procedure   GetParameters(var prmModif: boolean); override;
                        public
                        procedure   LoadFromStream(prmStream: TStream); override;
                        procedure   SaveToStream(prmStream: TStream); override;
                        {afficher le chemin et le nom de la base}
                        function    getHTMLParameters(): string; override;
                        end;

const
        DATASET_GEN_CLASS_NAME = 'TMLGenDataset';                         
        

implementation

uses
     SysUtils,   
     UDlgOpPrmDataset,
     UDatasetImplementation, UConstConfiguration, UStringAddBuffered;


resourcestring

     {base de donnes}
     ID_HTML_DATABASE = 'Database';

     
        

{ TMLCompDataset }

procedure TMLCompDataset.ConnectToDatabase(prmLst: TLstAttributes);
begin
 //un simple passage de pointeur sur les donnes initiales
 //attention, la liste est owned
 FLocalDataset:= prmLst;
end;

destructor TMLCompDataset.Destroy;
begin
 FLocalDataset:= NIL;
 inherited destroy;
end;

function TMLCompDataset.Execute(prmForce: boolean): boolean;
begin
 result:= TRUE;
end;

function TMLCompDataset.getClassOperator: TClassOperator;
begin
 result:= TOpDataset;
end;

procedure TMLCompDataset.getInfosGenerator(prmGen: TMLGenComp);
begin
 FNumIcon:= 0;
 FDescription:= 'Dataset';
 FMLGenClassName:= DATASET_GEN_CLASS_NAME;
end;

procedure TMLCompDataset.InitializeDataset;
begin
 FOutputMLData:= TMLDataset.CreateFromLstAtt(FLocalDataset);
end;

procedure TMLCompDataset.InsertIntoDiagram(prmDiagram: TMLDiagram;
  prmPred: TMLComponent);
begin
 //le nom de la base qui est inscrite sur le gestionnaire de diagramme
 FDatabaseName:= prmDiagram.DatabaseName;
 FDescription:= Format('Dataset (%s)',[ExtractFileName(FDatabaseName)]);
 //insertion effective
 inherited InsertIntoDiagram(prmDiagram,prmPred);
 //puis rcuprer les donnes
 self.ConnectToDatabase(prmDiagram.Dataset);
end;

procedure TMLCompDataset.RefreshOutput;
begin
 //No-one
end;

function TMLCompDataset.sectionINI: string;
begin
 result:= 'Dataset';
end;

{ TOpPrmDataset }

function TOpPrmDataset.CreateDlgParameters: TForm;
begin
 //result:= TDlgOpPrmDataset.CreateFromOpPrm(self);
 result:= NIL;
end;

function TOpPrmDataset.getHTMLParameters: string;
begin
 result:= Format('<P><B>%s : </B>%s',[ID_HTML_DATABASE,(self.Operator.MLOwner as TMLCompDataset).DatabaseName]);
end;

procedure TOpPrmDataset.GetParameters;
begin
 inherited GetParameters(prmModif);
 //ici, pas de modif de paramtres invalidant la suite
 prmModif:= FALSE;
end;

procedure TOpPrmDataset.LoadFromStream(prmStream: TStream);
begin
 //rien
end;

procedure TOpPrmDataset.SaveToStream(prmStream: TStream);
begin
 //rien
end;

procedure TOpPrmDataset.SetDefaultParameters;
begin
 //rien pour l'instant mais  voir plus tard...
end;

{ TOpDataset }

constructor TOpDataset.Create(AOwner: TObject);
begin
 inherited Create(AOwner);
 IsAvailable:= TRUE;//toujours...
end;

function TOpDataset.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmDataset;
end;

function TOpDataset.getHTMLResultsSummary: string;
var s: string;
    i: integer;
    data: TLstAttributes;
    att: TAttribute;
    bs: TBufString;    
begin
 data:= (self.MLOwner as TMLCompLocalData).OutputData.LstAtts[asAll];

 bs:= TBufString.Create();
 bs.BeginUpdate();

 s:= '<H3>Download information</H3>';
 s:= s+HTML_HEADER_TABLE_RESULT;
 s:= s+(self.MLOwner as TMLCompDataset).Diagram.HTMLAccessInfos.getInfosHTML();
 s:= s+'</table>';
 bs.AddStr(s);

 s:= '<H3>Dataset description</H3>';
 s:= s+Format('<B>%d attribute(s)</B>',[data.Count]);
 s:= s+Format('<BR><B>%d example(s)</B>',[data.Size]);
 s:= s+'<P>'+HTML_HEADER_TABLE_RESULT+HTML_TABLE_COLOR_HEADER_GRAY+'<TH>Attribute</TH><TH>Category</TH><TH>Informations</TH>';
 bs.AddStr(s);
 
 for i:= 0 to pred(data.Count) do
  begin
   att:= data.Attribute[i];
   s:= Format(HTML_TABLE_COLOR_DATA_GRAY+'<td>%s</td><td>%s</td>',[att.Name,att.sCategory]);
   if att.isCategory(caDiscrete)
    then
     begin
      //ajouter un contrle pour le nombre de modalits
      if (att.nbValues>HIGH(TTypeDiscrete))
       then s:= s+Format('<td bgcolor="red" align=right><b>(WARNING !!!) %d values</b></td>',[att.nbValues])
       else s:= s+Format('<td align=right>%d values</td>',[att.nbValues]);
     end
    else s:= s+'<td align=center>-</td>';
   s:= s+'</tr>';
   bs.AddStr(s);
  end;
 s:= '</TABLE>';
 bs.AddStr(s);

 bs.EndUpdate();
 
 result:= bs.BufS;

 bs.Free;
end;

end.
