(*************************************************************)
(* UFrmOpDataset.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(*************************************************************)

{
@abstract(Fiche pour la visualisation d'un dataset directement connect)
@author(Ricco)
@created(16/07/03)
(16/07/03)
}
unit UFrmOpDataset;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBaseOperator, ComCtrls, OleCtrls, SHDocVw, ExtCtrls;

type
  TFrmOpDataset = class(TFrmBaseOperator)
  lstViewData: TListView;
  private
  public
  procedure   PrepareView(); override;
  end;

var
  FrmOpDataset: TFrmOpDataset;

implementation

{$R *.dfm}

USES
        UDatasetImplementation,
        UCompDataset, UCompManageDataset,
        UDatasetDefinition;

{ TFrmOpDataset }

procedure TFrmOpDataset.PrepareView;
var FDataset: TMLDataset;
    att: TAttribute;
    allAtts: TLstAttributes;
    i: Integer;
    item: TListItem;
begin
 //on revient  l'anctre initial
 FDataset:= (Operator.MLOwner as TMLCompLocalData).OutputData;
 allAtts:= FDataset.LstAtts[asAll];
 //lister l'ensemble des variables charges
 for i:= 0 to pred(allAtts.Count) do
  begin
   att:= allAtts.Attribute[i];
   item:= lstViewData.Items.Add();
   item.Caption:= att.Name;
   item.SubItems.Add(att.sCategory);
   case att.Category of
    caDiscrete:
        begin
         item.SubItems.Add(IntToStr(att.nbValues)+' values');
        end;
   end;
  end;
 //infos sur les donnes
 Caption:= Format('Dataset - (%d examples, %d attributes)',[allAtts.Size,allAtts.Count]);
end;

end.
