(**********************************************************************)
(* UCompSDCrossTabutation.pas - Copyright (c) 2004 Ricco RAKOTOMALALA *)
(**********************************************************************)

{
@abstrcat(Analyse de relation entre deux variables catgorielles - tableaux croiss)
@author(Ricco)
@created(12/01/2004)
}
unit UCompSDCrossTabutation;

interface

USES
        Forms,Classes,
        IniFiles,
        UOperatorDefinition,
        UCompDefinition,
        UCompSDDefinition;

TYPE
        {gnrateur d'analyse de tableaux croiss}
        TMLGenCompSDCrossTab = class(TMLGenComp)
                               protected
                               procedure   GenCompInitializations(); override;
                               public
                               function    GetClassMLComponent: TClassMLComponent; override;        
                               end;

        {composant tableaux croiss}
        TMLCompSDCrossTab = class(TMLCompSD)
                            protected
                            function    getClassOperator: TClassOperator; override;
                            function    GetLogResultDescription(): string; override;        
                            end;

        {oprateur tableaux croiss}
        TOpSDCrossTab = class(TOpSD)
                        protected
                        procedure   InitializeListStat(); override;
                        function    getClassParameter: TClassOperatorParameter; override;
                        procedure   RebuildStatDes(); override;
                        function    CheckAttributes(): boolean; override;
                        public
                        {la prsentation des rsultats doit intgrer la mise en vidence des contributions}
                        function    getHTMLResultsSummary(): string; override;
                        end;

        {paramtrage d'oprateur tableaux croiss}
        TOpPrmSDCrossTab = class(TOpPrmSD)
                           private
                           {Type de liste de variables en entre : 0 - double liste (target/input), 1 - simple liste (input)  croiser}
                           FInputList: Byte;
                           {seuil contribution}
                           FContribThresold: single;
                           protected
                           function    CreateDlgParameters(): TForm; override;
                           procedure   SetDefaultParameters(); override;
                           public
                           procedure   LoadFromStream(prmStream: TStream); override;
                           procedure   SaveToStream(prmStream: TStream); override;
                           procedure   LoadFromINI(prmSection: string; prmINI: TMemIniFile); override;
                           procedure   SaveToINI(prmSection: string; prmINI: TMemIniFile); override;
                           function    getHTMLParameters(): string; override;
                           property    InputList: Byte read FInputList write FInputList;
                           property    ContribThresold: single read FContribThresold write FContribThresold;
                           end;     
        

implementation

USES
        Sysutils,
        UDatasetImplementation, UCalcStatDesCrossTab, UCalcStatDes,
  UDatasetDefinition, UConstConfiguration, UStringAddBuffered,
  UDlgOpPrmSDCrossTabulation, UStringsResources;

{ TMLGenCompSDCrossTab }

procedure TMLGenCompSDCrossTab.GenCompInitializations;
begin
 FMLComp:= mlcNonParametricStatistics;
end;

function TMLGenCompSDCrossTab.GetClassMLComponent: TClassMLComponent;
begin
 result:= TMLCompSDCrossTab;
end;

{ TMLCompSDCrossTab }

function TMLCompSDCrossTab.getClassOperator: TClassOperator;
begin
 result:= TOpSDCrossTab;
end;

function TMLCompSDCrossTab.GetLogResultDescription: string;
begin
 result:= Format('Description of %d attributes from %d ',[(Operator as TOpSDCrossTab).WorkData.LstAtts[asTarget].Count,
                (Operator as TOpSDCrossTab).WorkData.LstAtts[asInput].Count]);
end;

{ TOpSDCrossTab }

function TOpSDCrossTab.CheckAttributes: boolean;
var ok: boolean;
begin
 ok:= TRUE;
 case (self.PrmOp as TOpPrmSDCrossTab).InputList of
  //target x input
  0: begin
      ok:= ok and (self.WorkData.LstAtts[asTarget].Count>0) and (self.WorkData.LstAtts[asTarget].isAllCategory(caDiscrete));
      ok:= ok and (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caDiscrete));
     end;
  //cross-input
  1 : begin
       ok:= ok and (self.WorkData.LstAtts[asInput].Count>0) and (self.WorkData.LstAtts[asInput].isAllCategory(caDiscrete));
      end;
 end;
 result:= ok;
end;

function TOpSDCrossTab.getClassParameter: TClassOperatorParameter;
begin
 result:= TOpPrmSDCrossTab;
end;

function TOpSDCrossTab.getHTMLResultsSummary: string;
var s: string;
    scSign: string;
    stat: TCalcSDCrossTab;
    i,j,k: integer;
    Chi2,contrib,v: double;
    cThresold: double;
    pContribThresold: double;
    buf: TBufString;
begin
 pContribThresold:= (PrmOp as  TOpPrmSDCrossTab).ContribThresold;
 //l'en-tte
 buf:= TBufString.Create();
 buf.BeginUpdate();
 buf.AddStr(HTML_HEADER_TABLE_RESULT);
 buf.AddStr(FLstStat.GetHeaderHTML());
 //chaque ligne de rsultat
 for k:= 0 to pred(FLstStat.Count) do
  begin
   s:= HTML_TABLE_COLOR_DATA_GRAY;
   stat:= TCalcSDCrossTab(FLstStat.Stat(k));
   //envoyer le tout sauf le tableau, c'est le sens de -1
   s:= s+stat.getHTMLResult(-1);
   //envoyer le tableau de contingence
   Chi2:= stat.Chi2;
   s:= s+'<TD valign=top>'+HTML_HEADER_TABLE_RESULT+HTML_TABLE_COLOR_HEADER_BLUE+'<TH></TH>';

   //copier/coller modifi  partir de UCalcCrossTab
   //la liste des modalits sur la premire ligne
   for j:= 1 to stat.ColAtt.nbValues do
    s:= s +'<TH width=60>'+Stat.ColAtt.LstValues.getDescription(j)+'</TH>';
   //et la marge pour finir
   s:= s+format('<TH width=60 %s>Sum</TH></TR>',[HTML_BGCOLOR_HEADER_GREEN]);
   //pour chaque ligne du tableau
   for i:= 1 to Stat.RowAtt.nbValues do
    begin
     s:= s+format('<TR><TH %s>%s</TH>',[HTML_BGCOLOR_HEADER_BLUE,stat.RowAtt.LstValues.getDescription(i)]);
     //pour chaque cellule
     for j:= 1 to stat.ColAtt.nbValues do
      begin
       contrib:= 0.0;
       v:= 0.0;
       //calculer la contribution de la cellule
       if (stat.CrossTab.Value[0,0]>0)
        then
         begin
          v:= 1.0*stat.CrossTab.Value[i,0]*stat.CrossTab.Value[0,j]/(1.0*stat.CrossTab.Value[0,0]);
          contrib:= stat.CrossTab.Value[i,j]-v;
         end;
       //le signe de la contribution
       scSign:= '';
       if (contrib>0)
        then scSign:= '+'
        else scSign:= '-';
       if (v>0)
        then contrib:= 1.0*(contrib*contrib)/v;
       //contribution en pourcentage
       if (chi2>0)
        then contrib:= contrib/chi2;
       //tester si intressant -- tout a pour a !!!
       cThresold:= 0.0;
       if ((stat.RowAtt.nbValues*stat.ColAtt.nbValues)>0)
        then cThresold:= pContribThresold/(1.0*stat.RowAtt.nbValues*stat.ColAtt.nbValues);
       if (contrib>cThresold)
        then s:= s+format('<TD %s align=right>%d (%s%.2f)</TD>',[HTML_BGCOLOR_DATA_RED,stat.CrossTab.Value[i,j],scSign,contrib])
        else s:= s+format('<TD %s align=right>%d</TD>',[HTML_BGCOLOR_DATA_BLUE,stat.CrossTab.Value[i,j]])
      end;
     //la marge
     s:= s+format('<TD %s align=right>%d</TD></TR>',[HTML_BGCOLOR_DATA_GREEN,stat.CrossTab.Value[i,0]]);
    end;
   //la dernire ligne, la somme en colonne
   s:= s+format('<TR><TH %s>Sum</TH>',[HTML_BGCOLOR_HEADER_GREEN]);
   for j:= 1 to stat.ColAtt.nbValues do
    s:= s+format('<TD %s align=right>%d</TD>',[HTML_BGCOLOR_DATA_GREEN,stat.CrossTab.Value[0,j]]);
   //la marge totale
   s:= s+format('<TD %s align=right>%d</TD></TR>',[HTML_BGCOLOR_DATA_GREEN,stat.CrossTab.Value[0,0]]);

   //fin de description de la table
   s:= s+'</table></TD>';
   //fin du tableau de contingence
   s:= s+'</TR>';
   
   //add tu buffer
   buf.AddStr(s);
  end;
 buf.AddStr('</table>');
 buf.EndUpdate();
 
 //renvoyer le tout
 result:= buf.BufS;
 //don't forget
 buf.Free;
end;

procedure TOpSDCrossTab.InitializeListStat;
begin
 FLstStat:= TLstCalcStatDesCrossTab.Create(nil,nil);
end;

procedure TOpSDCrossTab.RebuildStatDes;
 //non, il n'est pas standard sur un ensemble de variables, ce qui est utilis entres autres en ACM
 //>> est invalid ici la procdure standard ::: FLstStat.RebuildStatDes(Workdata.LstAtts[asTarget],NIL);
 //on gre plutt les deux listes target et input
var stat: TCalcSDCrossTab;
    attI,attJ: TAttribute;
    i,j: integer;
begin
 case (PrmOp as TOpPrmSDCrossTab).FInputList of
  //double liste target-input
  0: begin
       //pour chaque variable de description
       for i:= 0 to pred(workdata.LstAtts[asTarget].Count) do
        begin
         attI:= workdata.LstAtts[asTarget].Attribute[i];
         //le type est ok ?
         if attI.isCategory(caDiscrete)
          then
           begin
            //les variables  dcrire
            for j:= 0 to pred(WorkData.LstAtts[asInput].Count) do
             begin
              attJ:= WorkData.LstAtts[asInput].Attribute[j];
              //petit test quand mme
              if attJ.isCategory(caDiscrete) and (attI<>attJ)
               then
                begin
                 stat:= TCalcSDCrossTab.Create(attI,attJ,nil);
                 self.LstStat.AddStat(stat);
                end;
             end;
           end;
        end;
     end
  else
   //simple liste input  croiser
   begin
    for i:= 0 to WorkData.LstAtts[asInput].Count-2 do
     begin
      attI:= workdata.LstAtts[asInput].Attribute[i];
      if attI.isCategory(caDiscrete)
       then
        begin
          for j:= succ(i) to pred(WorkData.LstAtts[asInput].Count) do
           begin
            attJ:= WorkData.LstAtts[asInput].Attribute[j];
            //le deuxime test renvoie toujours vrai sinon il y a un srieux problme
            if attJ.isCategory(caDiscrete) and (attJ<>attI)
             then
              begin
               stat:= TCalcSDCrossTab.Create(attI,attJ,nil);
               self.LstStat.AddStat(stat);
              end;
           end;
        end;
     end;
   end;
 end;
end;

{ TOpPrmSDCrossTab }

function TOpPrmSDCrossTab.CreateDlgParameters: TForm;
begin
 result:= TDlgOpPrmSDCrossTab.CreateFromOpPrm(self);
end;

function TOpPrmSDCrossTab.getHTMLParameters: string;
var s,sPrm: string;
begin
 s:= HTML_HEADER_TABLE_RESULT;
 s:= s+HTML_TABLE_COLOR_HEADER_GRAY+'<TH colspan=2>Cross-tab parameters</TH></TR>';
 if self.SortResult
  then sPrm:= 'yes'
  else sPrm:= 'non';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Sort results</TD><TD align="right">%s</TD></TR>',[sPrm]);
 if self.SortResult
  then
   begin
    case self.SortCriteria of
     0: sPrm:= 'Row attribute name';
     1: sPrm:= 'Column attribute name';
     2: sPrm:= 'Tschuprow statistic';
    end;
    s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Sort criterion</TD><TD align="right">%s</TD></TR>',[sPrm]);
   end;
 if (self.InputList=0)
  then sPrm:= 'Target (Row) and input (Column)'
  else sPrm:= 'Cross-input (Row x Column)';
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Input list</TD><TD align="right">%s</TD></TR>',[sPrm]);
 s:= s+HTML_TABLE_COLOR_DATA_GRAY+format('<TD>Contribution thresold</TD><TD align="right">%3.1f</TD></TR>',[self.ContribThresold]);
 s:= s+'</table>';
 result:= s;
end;

procedure TOpPrmSDCrossTab.LoadFromINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 inherited LoadFromINI(prmSection,prmINI);
 FInputList:= prmINI.ReadInteger(prmSection,'input_list',FInputList);
 FContribThresold:= prmINI.ReadFloat(prmSection,'contrib_thresold',FContribThresold);
end;

procedure TOpPrmSDCrossTab.LoadFromStream(prmStream: TStream);
begin
 inherited LoadFromStream(prmStream);
 prmStream.ReadBuffer(FInputList,sizeof(FInputList));
 prmStream.ReadBuffer(FContribThresold,sizeof(FContribThresold));
end;

procedure TOpPrmSDCrossTab.SaveToINI(prmSection: string;
  prmINI: TMemIniFile);
begin
 inherited SaveToINI(prmSection,prmINI);
 prmINI.WriteInteger(prmSection,'input_list',FInputList);
 prmINI.WriteFloat(prmSection,'contrib_thresold',FContribThresold);
end;

procedure TOpPrmSDCrossTab.SaveToStream(prmStream: TStream);
begin
 inherited SaveToStream(prmStream);
 prmStream.WriteBuffer(FInputList,sizeof(FInputList));
 prmStream.WriteBuffer(FContribThresold,sizeof(FContribThresold));
end;

procedure TOpPrmSDCrossTab.SetDefaultParameters;
begin
 inherited SetDefaultParameters();
 FInputList:= 0;
 FContribThresold:= 2.0;
end;

initialization
 RegisterClass(TMLGenCompSDCrossTab);
end.
